package adaptive.core;

import java.util.*;
import comms.core.*;
import java.net.*;
import java.io.*;
import adaptive.core.net.RemoteClassObjectInputStream;

class NetExecutor extends Thread implements ExecutorCallback, Runnable, AdaptiveProtocol  {
  private final static boolean kMLOG = false;
  
  SystemExecutor se;
  AgentLoader al;
  String owner;
  String instName;
  ServerSocket configTransferSSocket;
  //AgentContainer localConf;
  Hashtable localConf; //change jrj 7/8
  MessageQueue highLevelQueue;
  Thread messThread;

  /* synchronizes configuration events */
  Object opLock;

  /* the lock to wait on for completion of a configuration event.
     THIS SHOULD ALWAYS BE THE AGENT'S runLock */
  Object internalLock;
  boolean internalDone;
  boolean internalError;
  boolean fromTransfer = false;
  ObjectOutputStream outStream;
  ObjectInputStream inStream;

  //String dirHostname;
  //int dirPort;

  public NetExecutor(String own, String who,String srcIP, int srcPort) throws IOException {
    System.out.println("Owner: "+own);
    owner = own;
    //instName = own.substring(0,own.lastIndexOf('_'));
    instName="happyday";
    opLock = new Object();
    highLevelQueue = new MessageQueue();
    internalLock = null;
    internalDone = false;
    internalError = false;
    
    System.out.println("trying to connect to "+srcIP+" on "+srcPort);
    try {
      // connect to the coordinator
      Socket socket = new Socket(InetAddress.getByName(srcIP),srcPort);
      outStream=new ObjectOutputStream(socket.getOutputStream());
      outStream.flush();
      inStream = new RemoteClassObjectInputStream(socket.getInputStream());
    } catch (IOException e) {
      throw new IOException("Unable to connect to Coordinator");
    }
    Byte b;
    Hashtable system;
    System.out.println("NETEXECUTOR");
    try {
      if (CoordinatorProtocol.goodReceiver
	  (CoordinatorProtocol.kIAMANETEXECUTOR,
	   CoordinatorProtocol.kIAMACOORDINATOR,inStream,outStream)) {
	// we're connected
	// ask for an agent server.. we need it before we ask for the system
	outStream.writeObject(CoordinatorProtocol.kREQ_AGENTSERVER);
	System.out.print("waiting for agentserver..");
	Vector agentServer=null;
	
	if (CoordinatorProtocol.isOKPLUS(inStream.readObject())) {
	  agentServer = (Vector)inStream.readObject();
	  outStream.writeObject(CoordinatorProtocol.kOK);
	}
	System.out.println("received.");
	System.out.println(agentServer.elementAt(0));
	System.out.println(agentServer.elementAt(1));
	System.out.print("Requesting system..");
        al = new AgentLoader((String) null,(String)agentServer.elementAt(0),
                             ((Integer)agentServer.elementAt(1)).intValue());

        ((RemoteClassObjectInputStream) inStream).setClassLoader(al.nal);
        
	/* request directory server info */
	System.out.println("requesting dir info");
	outStream.writeObject(CoordinatorProtocol.kREQ_DIRSERVER);
	
	if (CoordinatorProtocol.isOKPLUS(inStream.readObject())) {
	  System.out.println("got OKPLUS");
	  Vector dirInfo = (Vector) inStream.readObject();
	  String dirHost = (String) dirInfo.elementAt(0);
	  int dirPort = ((Integer) dirInfo.elementAt(1)).intValue();
	  
	  /* request sysconfig only after receiving necessary dir server
	     info */
	  outStream.writeObject(CoordinatorProtocol.kREQ_SYSCONFIG);
        
	  if (CoordinatorProtocol.isOKPLUS(inStream.readObject())) {
	    system = (Hashtable)inStream.readObject();
	    Enumeration e = system.keys();
	    while (e.hasMoreElements()) {
	      System.out.println("Agent:"+e.nextElement());
	    }
	    
	    System.out.println("..received.");
	    boolean error=false;
	    String errMess= null;
	    System.out.println("Received system. initializing systemexecutor");
	    // we now have an agentServer Vector which has the agentserver host
	    // name as the first element, and the port as the second element.
	    // that can replace the commlink
	    Communications commLink=null;
	    se = new SystemExecutor(al,this);			 
	    String systemName=this.instName; 
	    se.setConfiguration(system,systemName);//added jrj 7/8 
	    // --if this works, it's a hack that should be fixed
	    //se.configureRaveComms(dirHost, dirPort);
	    se.setDirServer(dirHost, dirPort);
	    se.setup();
	    
	    if(!se.verifyAll()) {
	      throw new ConfigLoadException("Configuration verify failure.");
	    }
	    outStream.writeObject(CoordinatorProtocol.kOK);
	    // if this was caused because of a move, we have to queue a
	    // start message? maybe coordinator will do that for us..
	    // i'll just leave this comment here so we know what to add
	    // later.			 
	  }
	}	
      }
    } catch (Exception e) {
      System.out.println("NE exception");
      e.printStackTrace();
      outStream.writeObject(CoordinatorProtocol.kERROR);
      outStream.writeObject(e);
      throw new IOException(e.toString());
    }
  }

  public void run() {
    System.out.println("Beginning to read from highLevelQueue");
    /** NOTE: A kGIVEMOVELOCK IS CURRENTLY THE ONLY CASE WHERE WE NEED
        TO WAKE UP INTERNAL THREADS. ALL OTHERS ARE EXTERNALLY GENERATED
        MESSAGES */
    MessageQueue secondaryQueue = new MessageQueue();
    Message mess;
    StringTokenizer stk;
    String firstToken;
    String secondToken;
    Byte command;
    try {
      while(!isInterrupted()) {
	command = (Byte)inStream.readObject();
	if (command.equals(CoordinatorProtocol.kSTARTRUN)) {
	  if(!se.running) {
	    System.out.println("Starting everything...");
	    se.startAll();
	    if(!fromTransfer) {
	      outStream.writeObject(CoordinatorProtocol.kSYSTEMSTARTED);
	    } else {
	      fromTransfer = false;
	    }
	  }
	  System.out.println("Everything should be started");
	} else if(command.equals(CoordinatorProtocol.kSTOPRUN)) {
	  if(se.running) {
	    se.stopAll(); 
	  }
	  outStream.writeObject(CoordinatorProtocol.kOK);
	} else if(command.equals(CoordinatorProtocol.kPAUSEAG)) {
	  String name = (String)inStream.readObject();
	  se.pause(name);
	  outStream.writeObject(CoordinatorProtocol.kOK);
	} else if(command.equals(CoordinatorProtocol.kUNPAUSEAG)) {
	  String name = (String)inStream.readObject();
	  se.unpause(name);
	  outStream.writeObject(CoordinatorProtocol.kOK);
	} else if(command.equals(CoordinatorProtocol.kGOODBYE)) {
	  // other side is disconnecting.. but may reconnect in the
	  // future
	  interrupt();
	} else if(command.equals(CoordinatorProtocol.kSHUTDOWN)) {
	  // otherside wants us to bite the bullet
	  se.shutdown();
	  outStream.writeObject(CoordinatorProtocol.kGOODBYE);
	  // don't respond to this, it's not like the netexecutor
	  // is unable to shutdown...
	  
	  //outStream.writeObject(CoordinatorProtocol.kOK);
	  System.exit(0);
	} else if(command.equals(CoordinatorProtocol.kGIVEMOVELOCK)) {
	  // disabled for right now..
	  outStream.writeObject(CoordinatorProtocol.kERROR);
	  outStream.writeObject(new Exception("I cannot comply with that "+
					      "request. I don't know how to "+
					      "move things yet."));
		  
	  /*
	    String thirdToken = stk.nextToken();
	    String fourthToken = stk.nextToken();
	    MessageQueue tempQueue = new MessageQueue();
	    // move ourselves 
          
	    //  1 connect to remote via ConfigTransfer protocol
	    //  2 update our configuration with state data
	    //  3 send the config.
	    //  4 if successful send, then shutdown ourselves.
	    //  5 else signal internal that we failed moving 
	    Socket theSock=null;
	    ObjectOutputStream oos=null;
	    ObjectInputStream ois=null;
	    try {
            Object[] sockStuff = ConfigTransferProtocol.initiateNewRemote(
	    commLink,
	    configTransferSSocket,
	    tempQueue,
	    fourthToken,
	    owner,false);

            theSock = (Socket) sockStuff[0];
            oos = (ObjectOutputStream) sockStuff[1];
            ois = (ObjectInputStream) sockStuff[2];
            // update the configuration and transfer it to new location 
            se.saveStateAll();
            System.out.println("State has been saved. Attempting send now.");

            oos.writeObject(localConf);
            oos.flush();

            String response;
            try {
	    response = (String) ois.readObject();
            }
            catch(ClassNotFoundException cnfe) {
	    throw new IOException("Error in remote loading. -->"+
	    fourthToken);
            }
            if(!response.equals(ConfigTransferProtocol.kSETUP_SUCCESSST)) {
	    throw new IOException("Error in remote loading. -->"+
	    fourthToken);
            }
            // if we get here, everything loaded correctly and we are
            //   ready to report success to owner. The owner then sends
            //   us a corrected phone list which we relay to the moved
            //   version of ourselves. 
            commLink.setMessageQueue(owner, secondaryQueue);
            commLink.sendMessage(owner,RunControlProtocol.moveDone());
            boolean gotOwnerOkay = false;
            Message ownMess;
            String ownFirstTok;
            int spacePos=0;
            while(!gotOwnerOkay) {
	    ownMess = commLink.readNextMessage(secondaryQueue);
	    System.out.println("Got highlevel names message from owner.");
	    System.out.println("Message is: "+ownMess.getMessage());
	    ownFirstTok = ownMess.getMessage();
	    spacePos = ownFirstTok.indexOf(' ');
	    if(spacePos != -1) {
	    ownFirstTok =
	    ownFirstTok.substring(0,spacePos);
	    }
	    else {
	    ownFirstTok = ownMess.getMessage();
	    }
	    System.out.println("OwnFirstTok:>"+ownFirstTok+"<");
	    if(ownFirstTok.equals(AdaptiveProtocol.kCODE_MOVE_DONEST)) {
	    // ship this message over to the new location and get ready
	    //   to shutdown 
	    System.out.println("Got owner OKAY.");
	    gotOwnerOkay = true;
	    try {
	    System.out.println("Relaying OKAY message to new system.");
	    oos.writeObject(ownMess.getMessage());
	    oos.flush();
	    System.out.println("Done Relaying OKAY message to new system.");
	    String finalMess;
	    // wait for the okay signal to shutdown 
	    try {
	    System.out.println("Waiting for okay signal to shutdown.");
	    finalMess = (String) ois.readObject();
	    commLink.sendMessage(owner,
	    new Message(
	    AdaptiveProtocol.kSETUP_SUCCESSST));
	    // shutdown 
	    se.shutdown();
	    System.exit(0);
	    }
	    catch(ClassNotFoundException cnfe) {
	    throw new IOException(
	    "Error in wait for final shutdown okay.");
	    }
	    ConfigTransferProtocol.cleanupSocket(theSock,oos,ois);
	    }
	    catch(IOException ioe) {
	    commLink.sendMessage(owner,
	    new Message(
	    AdaptiveProtocol.kSETUP_FAILST));
	    throw new IOException("ignore");
	    }
	    }
	    else {
	    // we're in the move phase so we shouldn't be getting any
	    //   other types of messages. 
	    System.out.println(
	    "Error: Got nonvalid message while finalizing code move.");
	    }
            }
	    }
	    catch(IOException ioe) {
            commLink.setMessageQueue(owner,highLevelQueue);
	    //            ioe.printStackTrace();
            if(!ioe.getMessage().equals("ignore")) {
	    try {
	    System.out.println("Move FAILED!!");
	    commLink.sendMessage(owner,RunControlProtocol.moveFail());
	    }
	    catch(IOException ioe2) {
	    System.out.println("Owner is not responding.");
	    System.exit(0);
	    }
            }
            // this will only occur on failure 
            ConfigTransferProtocol.cleanupSocket(theSock,oos,ois);
            if(internalLock == null) {
	    System.out.println("DANGER: internalLock is null.");
            }
            synchronized(internalLock) {
	    internalDone = true;
	    internalLock.notify();
            }
	    } */
        } 
        else if(command.equals(CoordinatorProtocol.kREQUESTMOVELOCK)) {
          /* the net executor should never receive a move request */
        }
        else {
          //System.out.println("Got a unknown RCP message from "+
          //                   mess.getCorrespondent());
	  System.out.println("Unknown message");
        }
      }
      //else {
      //   System.out.println("Got a unknown message from "+
      //                       mess.getCorrespondent());
      // }
      //ignores non RCP messages
    } catch (Exception e) {
      // I don't know what happened here.
    }
	 
  }

  
  public void jumpShip(String newHost, Agent moverAg) {
    /*
      String resolvedName;
    
      boolean goodRequest = false;
      try {
      newHost = InetAddress.getByName(newHost).getHostName();
      goodRequest = true;
      }
      catch(UnknownHostException uhe) {
      goodRequest = false;
      }
      String whereTo = nameFromLocation(newHost);
    
      if(goodRequest && !whereTo.equals(commLink.getMyName())) {
      // ADD NETCONTROL LOOKUP HERE 
      synchronized(opLock) {
      try {
      commLink.sendMessage(owner,
      RunControlProtocol.requestMoveLock(
      commLink.getMyName(),
      whereTo));
      }
      catch(IOException ioe) {
      System.out.println("Can't send move request to "+owner);
      return;
      }
      // NOTE, WE ARE ABLE TO ACCESS runLock BECAUSE IT IS PACKAGE
      //   VISIBLE. MIGHT WANT TO ADD AN ACCESSOR METHOD TO
      //   BASICPORTAGENT 
      internalLock = ((BasicPortAgent) moverAg).runLock;
      synchronized(internalLock) {
      while(!internalDone) {
      try {
      internalLock.wait();
      }
      catch(InterruptedException ie) {
      System.out.println("Got interrupted in jumpShip.");
      }
      }
      internalDone = false;
      internalLock = null;
      }
      }
      }
      else if(whereTo.equals(commLink.getMyName())) {
      System.out.println("Error: Can't jumpShip to the current location.");
      } */
  }

  public boolean swapAgents(String name, String newAgentType){
    return false;
  }
  
  /*
    public void swapAgent(String name, String newAgentType) {
    }
  */
  
  private String nameFromLocation(String loc) {
    int place = loc.indexOf((int) '.');    
    if(place == -1) {
      return instName+"@"+loc;
    }
    else {
      return instName+"@"+loc.substring(0,place);  
    }
  }
  
  public static String usage() {
    return
      "java adaptive.core.Launcher <name> <owner> <source> <srcIP> <srcPort> <dirIP> <dirPort> [options]\n"+
      "Defaults: MessageLogging = "+kMLOG+"\n"+
      "Options:\n"+
      "Use -d to turn on remote debugging screen. NOT YET AVAILABLE\n"+
      "Use -m to turn on message logging\n"+
      "Use -h for this help file\n";
  }

  public static void commandLineError(char ch) throws Exception {
    throw new Exception("Bad Usage of -"+ch+". Use -h for help");
  }
  
  public static void main(String[] argv) {
    int srcPort;
    int port = 0;
    boolean mLog = kMLOG;
    int currArg=0;
	 
    try {
      if(argv.length < 4) {
	System.out.println("arg len < 4");
        throw new Exception("");
      }
      currArg = 7;
      
      while(currArg < argv.length) {
	if(argv[currArg].length() >= 2 && argv[currArg].charAt(0) == '-') {
	  switch(argv[currArg].charAt(1)) {
	  case 'm': //check for message logging flag
	    mLog = true;
	    currArg+=1;
	    break;
	  case 'd':
	    currArg+=1;
	    break;
	  default:
	    throw new Exception("Bad Switch: "+argv[currArg]+
                                "\n"+usage());
	  }
	}
	else {
	  throw new ComLineException("Bad argument: "+argv[currArg]+
                                     "\n"+usage());
	}
      }
      
      System.out.println(argv[1]);
      System.out.println(argv[2]);
      System.out.println(argv[3]);
      srcPort = Integer.parseInt(argv[4]);
      //port = Integer.parseInt(argv[6]);
      
      NetExecutor ne = new NetExecutor(argv[1], argv[2],
                                       argv[3], srcPort);
      ne.start();
    }
    catch(Exception e) {
      if(e instanceof IOException) {
	System.err.println(e.getMessage());
      }
      else {
	e.printStackTrace();
	System.err.println("Error in Main");
	System.err.println(e.getMessage());
      }
    }
  }
}
