package adaptive.core;

import adaptive.core.net.LocalHost;
//import comms.core.*;
import java.util.*;
import java.net.*;
import java.awt.*;
import java.io.*;

public class NetController extends Thread {
  
  public final static int kPORT = 7000;
  public final static boolean kMLOG = false;
  public final static String PROGRAM_NAME = "NetController";
  public final static String VERSION = "1.0";
  
  private int port;
  private boolean graphical;
  private NetControlFrame myFrame;
  private Thread messageLoop;
  private Hashtable runningNetExs;
  private OutputDirector outputDirector;
  
  public NetController(boolean graphicOn, String myName, int port) {
    runningNetExs = new Hashtable();
    graphical = graphicOn;
    this.port = port;
    messageLoop = new Thread(this);  
    outputDirector= new OutputDirector();
    outputDirector.start();
    
    if(graphical) {
      myFrame = new NetControlFrame(this, myName);
      outputDirector.setDisplay(myFrame.getTxtOutput());
      myFrame.setThread(outputDirector);
    }
    messageLoop.start();
  }
  
  public Hashtable getRunningNetExs() {
    return runningNetExs;
  }
  
  public void run() {
    try {
      System.out.println("NetController listening for connections...");
      Socket connection;
      ServerSocket serverSocket = new ServerSocket(port);
      
      while (true) {
	
	// listen for a connection
	connection = serverSocket.accept();
	(new Communicator(this,connection)).start();
	//yield();
      }
    } catch (Exception e) {
      System.err.println("NetController main thread error:"+e);
      System.exit(0);
    }
  }
  
  public OutputDirector getOutputDirector() {
    return outputDirector;
  }
  
  public void addProcess(PortProgram p) {
    synchronized(runningNetExs) {
      runningNetExs.put(p.name,p);
      if(graphical) {
        myFrame.relist();
      }
    }
  }

  public void removeProcess(PortProgram p) {
    synchronized(runningNetExs) {
      if(runningNetExs.containsKey(p.name)) {
        runningNetExs.remove(p.name);
        if(graphical) {
          myFrame.relist();
        }
      }
    }
  }

  public boolean killProcess( String name ) {
    PortProgram p;
    synchronized(runningNetExs) {
      if(runningNetExs.containsKey(name)) {
        p = (PortProgram) runningNetExs.remove(name);
        p.theProcess.destroy();
        if(graphical) {
          myFrame.relist();
        }
        return true;
      }
      return false;
    }
  }

  public void killProcessNoG(BufferedReader bR) {
    String pName;
    PortProgram p;
    synchronized(runningNetExs) {
      printProcesses();
      System.out.print("Type name of process to kill: ");
      pName = "";
      try {
        pName = bR.readLine();
      }
      catch (IOException ioe) {
      }
      if(runningNetExs.containsKey(pName)) {
        p = (PortProgram) runningNetExs.remove(pName);
        p.theProcess.destroy();
        System.out.println("Process "+pName+" killed!");
      }
      else {
        System.out.println("Invalid name. Nothing done!\n");
      }
    }
  }

  public void printProcesses() {
    Enumeration enum;
    PortProgram p;
    synchronized(runningNetExs) {
      enum = runningNetExs.elements();
      System.out.println("Net Executors");
      System.out.println("Name\t\tOwner");

      while(enum.hasMoreElements()) {
        p = (PortProgram) enum.nextElement();
        System.out.println(p.name+"\t\t"+p.owner);
      }
    }
  }

  /** returns a Vector of strings of the running NetExs.
      for use in GUI display */
  public Vector printProcessesG() {
    Enumeration enum;
    PortProgram p;
    Vector retVal = new Vector();
    synchronized(runningNetExs) {
      enum = runningNetExs.elements();
      while(enum.hasMoreElements()) {
        p = (PortProgram) enum.nextElement();
        retVal.addElement(p.name+"\t\t"+p.owner);
      }
    }
    return retVal;
  }

  /** destroy all running processes */
  public void shutdown() {
    Enumeration enum;
    PortProgram p;
    synchronized(runningNetExs) {
      enum = runningNetExs.elements();
      while(enum.hasMoreElements()) {
        p = (PortProgram) enum.nextElement();
        p.theProcess.destroy();
      }
      System.exit(0);
    }
  }

  static void printMenu() {
    System.out.println("NetController Menu\n");
    System.out.println("L\tList running NetExecutors.");
    System.out.println("K\tKill process.");
    System.out.println("Q\tQuit.");
    System.out.println("?\tThis menu.");
    System.out.println("");
  }

  static void printUsage() {
    System.out.println("Usage: java NetController <options>");
    //System.out.println("   -H <hostname>         Specify host name");
    //System.out.println("                          Default: localhost");
    System.out.println("   -p <port>             Specify port number");
    System.out.println("                          Default: 6500");
    //System.out.println("   -N <hostname> <port>  Enable network using hostname and port");
    //System.out.println("   -n                    For compatability. NOOP.");
    System.out.println("   -m                    Enable message logging.");
    System.out.println("                          Default: "+kMLOG);
    System.out.println("   -g                    Turn on graphical display");
    System.out.println("                          Overrides -h -p");
    System.out.println("   -v                    Print version");
    System.out.println("   -? -h                 Prints this");
    System.exit(0);
  }
  
  public static void main(String[] args) {

    String myName = null;
    int networkPort = kPORT;
    boolean mLog = kMLOG;
   
    boolean graphical = false;
	 
    try {
      String fullLocalHost =adaptive.core.net.LocalHost.getFullLocalHostName();
      //      String nameEnd = fullLocalHost.substring(0,fullLocalHost.indexOf((int) '.'));
      myName = "NetController - " + fullLocalHost;
      //hostname = argv[0];
      //port = Integer.parseInt(argv[1]);
		
      int currArg = 0;
		
      while(currArg < args.length) {
        if(args[currArg].length() >= 2 && args[currArg].charAt(0) == '-') {
          switch(args[currArg].charAt(1)) {
	    case 'p':
	      if ((args.length-currArg-1)>=1) {
		networkPort=Integer.parseInt(args[++currArg]);
		currArg++;
	      } else {
		System.err.println("No port specified after -p");
		System.exit(1);
	      }
	      break;
	    case 'v':
	      System.out.println(PROGRAM_NAME+" version "+VERSION);
	      break;
	    case 'h':
	    case '?':
	      printUsage();
	      break;
	    case 'm': //check for message logging flag
	      mLog = true;
	      currArg+=1;
	      break;
	    case 'g': //check for the graphical flag
	      graphical = true;
	      currArg+=1;
	      break;				
	    default:
	      System.err.println("Ignoring unknown switch: "+args[currArg]);
          }
        }
      }
      
      //comms = new Communications( myName, networkHost, networkPort,
      //                          mLog, true);
      
      NetController netCon = new NetController( graphical,
						myName,
						networkPort);
      
      if(!graphical) {
        InputStreamReader inSR = new InputStreamReader(System.in);
        BufferedReader bR = new BufferedReader(inSR);
        char key;
        String line;
        boolean quit = false;
        while(!quit) {
          System.out.print("Command: ");
          line = bR.readLine();
          key = line.charAt(0);
          switch(key) {
	    case 'L':
	    case 'l':
	      netCon.printProcesses();
	      break;
	    case 'K':
	    case 'k':
	      netCon.killProcessNoG(bR);
	      break;
	    case '?':
	      netCon.printMenu();
	      break;
	    case 'q':
	    case 'Q':
	      quit = true;
	      break;
	    default:
	      System.out.println("Invalid command!");
	      break;
          }
        }
        System.exit(0);
      }
    }
    catch(Exception e) {
      e.printStackTrace();
      System.err.println("Error in Main");
      System.err.println(e.getMessage());
    }
  }
}

class Communicator extends Thread {

  Socket socket;
  NetController netController;
  ObjectOutputStream outStream;
  ObjectInputStream inStream;
  
  public Communicator(NetController netController,Socket socket) {
    this.socket=socket;
    this.netController=netController;
	 
  }
  
  /**
   * Close down the streams and the socket.
   */
  public void close() {
    // Try to close the streams..
    try {
      inStream.close();
      outStream.close();
    } catch (IOException e) {
      inStream=null;
      outStream=null;
    }
    
    // try to close the socket
    try {      
      socket.close();
    } catch (IOException e) {
      socket=null;
    }
  }
  
  public void run() {
    Runtime runtime = Runtime.getRuntime();
    Object o;
    String mess;
    String token;
    String who;
    StringTokenizer stk;
    boolean messageProcessed;
    byte command;
    String name,owner;
    Process newP;
    int exitVal;
    Byte b;
    
    try {
      inStream=new ObjectInputStream(socket.getInputStream());
      outStream=new ObjectOutputStream(socket.getOutputStream());
      outStream.flush();
      
      if (!CoordinatorProtocol.goodSender
	  (CoordinatorProtocol.kIAMACOORDINATOR,
	   CoordinatorProtocol.kIAMANETCONTROLLER,inStream,outStream)) {
	interrupt();
	socket.close();
      }
      
	
      while(!isInterrupted()) {
	messageProcessed=false;
        o = inStream.readObject();
	if (o instanceof Byte) {
	  b = (Byte)o;
	  if (b.equals(CoordinatorProtocol.kNOOP)) {
	    messageProcessed=true;
	  } else if(b.equals(CoordinatorProtocol.kGOODBYE)) {
	    close();
	    interrupt();
	    messageProcessed=true;
	  } else if (b.equals(CoordinatorProtocol.kLISTPROCS)) {
	    //
	    //
	    // List the processes running on this host
	    //
	    //
            //StringBuffer allProcesses= new StringBuffer(200);
            Enumeration enum;
            PortProgram pp;
	    Vector allProcesses = new 
	      Vector(netController.getRunningNetExs().size()+10);
            synchronized(netController.getRunningNetExs()) {
              enum = netController.getRunningNetExs().elements();
				
              while(enum.hasMoreElements()) {
                pp = (PortProgram) enum.nextElement();
                allProcesses.addElement(pp.name+" "+pp.owner+" ");
              }
            }
	    outStream.writeObject(CoordinatorProtocol.kOKPLUS);
	    outStream.writeObject(allProcesses);
	    messageProcessed=true;
	  } else if(b.equals(CoordinatorProtocol.kKILLPROCESS)) {
	    try {
	      String whichKill = (String)inStream.readObject();
	      if(netController.killProcess(whichKill)) {
		//process killed successfully
		outStream.writeObject(CoordinatorProtocol.kOK);
	      } else {
		//nothing killed
		outStream.writeObject(CoordinatorProtocol.kERROR);
		outStream.writeObject(new Exception("Unable to Kill Process"));
	      }
	      messageProcessed = true;
	    } catch (ClassCastException e) {
	      outStream.writeObject(CoordinatorProtocol.kERROR);
	      outStream.writeObject(e);
	    }
          } else if(b.equals(CoordinatorProtocol.kRUNCOMMAND)) {
	    //
	    //
	    // Run a command on the host
	    //
	    //
	    try {
	      String[] s = (String[])inStream.readObject();
	      name = s[0];
	      owner = s[1];
	      String commandString = s[2];
	      Hashtable runningNetExs=netController.getRunningNetExs();
	      synchronized(runningNetExs) {
		newP = runtime.exec(commandString);
		try {
		  //give the process some time to execute
		  Thread.sleep(200);
		} catch(Exception ex) {
		}
					 
		try {
		  exitVal=newP.exitValue();
		  //if this didn't throw an exception, then the
		  //program must have had an error and exited
		  if (exitVal!=0) {
		    outStream.writeObject(CoordinatorProtocol.kERROR);
		    outStream.writeObject(new Exception("Unable to execute"));
		  } else {
		    outStream.writeObject(CoordinatorProtocol.kOK);
		  }
		} catch(IllegalThreadStateException itse) {
		  //the process is running so store tracking data and
		  //tell initiator that it's up
		  netController.getOutputDirector().addStream
		    (newP.getInputStream());
		  netController.getOutputDirector().addStream
		    (newP.getErrorStream());
		  PortProgram p = new PortProgram(name,owner,newP);
		  netController.addProcess(p);
		  WaiterThread wt = new WaiterThread(netController,p);
		  wt.start();
		  outStream.writeObject(CoordinatorProtocol.kOK);
		}
	      }
	      messageProcessed=true;
	    } catch (ClassCastException e) {
	      outStream.writeObject(CoordinatorProtocol.kERROR);
	      outStream.writeObject(e);				  
	    }
	  } else if(b.equals(CoordinatorProtocol.kPROCESSREQUEST)) {
	    //
	    //
	    //  Start a new NetExecutor 
	    //
	    //
	    try {
	      String cmdLine;
	      String[] env=null;
	      cmdLine = System.getProperty("java.class.path");
	      if(cmdLine != null) {
		env = new String [1];
		env[0] = "CLASSPATH="+cmdLine;
	      }
	      cmdLine = null;
	      who = "idunno";  // do we need a who?
	      Vector v = (Vector)inStream.readObject();
	      name = (String)v.elementAt(0);
	      owner = (String)v.elementAt(1);
	      String srcIP = (String)v.elementAt(2);
	      int srcPort = ((Integer)v.elementAt(3)).intValue();
	      /* we are about to add a new process, 
		 don't let anything else get at runningNetExs*/
	      Hashtable runningNetExs=netController.getRunningNetExs();
	      synchronized(runningNetExs) {
		cmdLine = "java adaptive.core.NetExecutor "+name+" "+owner+" "+who+" "+srcIP+" "+srcPort;
		// something about a -d
		newP = runtime.exec(cmdLine,env);
		try {
		  //give the process some time to execute
		  Thread.sleep(200);
		} catch(Exception ex) {
		}
		
		try {
		  newP.exitValue();
		  //if this didn't throw an exception, then the
		  //program must have had an error and exited
		  outStream.writeObject(CoordinatorProtocol.kERROR);
		  outStream.writeObject(new Exception("Unable to execute"));
		  System.out.println("Error starting a NetExecutor");
		} catch(IllegalThreadStateException itse) {
		  //the process is running so store tracking data and
		  //tell initiator that it's up
		  netController.getOutputDirector().addStream
		    (newP.getInputStream());
		  netController.getOutputDirector().addStream
		    (newP.getErrorStream());
		  PortProgram p = new PortProgram(name,owner,newP);
		  netController.addProcess(p);
		  WaiterThread wt = new WaiterThread(netController,p);
		  wt.start();
		  outStream.writeObject(CoordinatorProtocol.kOK);
		}
	      }
	      messageProcessed = true;
	    } catch (ClassCastException e) {
	      outStream.writeObject(CoordinatorProtocol.kERROR);
	      outStream.writeObject(e);
	    }	
	  }
	}
        if(!messageProcessed) {
	  outStream.writeObject(CoordinatorProtocol.kERROR);
	  outStream.writeObject(new Exception("Unknown command"));
        }
      }
    } catch (Exception ex) {
      if(ex instanceof IOException) {
        System.err.println("NetCon: Send failure.");
	ex.printStackTrace();
      } else {
        System.err.println("NetCon: Error in message loop.");
        ex.printStackTrace();
      }
    }
  }  
}


class WaiterThread extends Thread {
  
  public PortProgram p;
  public NetController n;

  public WaiterThread(NetController nn, PortProgram pp) {
    super();
    p = pp;
    n = nn;
  }

  public void run() {
    try {
      p.theProcess.waitFor();
    }
    catch (Exception e) {
      System.err.println("Wait for Port Program end failed!");
    }

    //when we get here, the process has exited so remove it from the
    //listing
    n.removeProcess(p);
  }
}

class PortProgram {
  public String owner;
  public String name;
  public Process theProcess;

  public PortProgram( String n, String own,Process p ) {
    owner = own;
    name = n;
    theProcess = p;
  }
}

class OutputDirector extends Thread {
  private final static int kBUFFSIZE = 2048;
  private final static int kTRIMOUTPUT = 102400;
  private final static int kKEEPONTRIM = 76800;

  private boolean displayActive=false;
  private TextArea display;
  private Vector inputStreams;
  private byte[] b;
  private boolean continueRunning=true;
  private Object o;
  
  public OutputDirector() {
    inputStreams=new Vector(3);
    b = new byte[kBUFFSIZE];
    o = new Object();
    //setPriority(NORM_PRIORITY-1);
  }
  
  public void setDisplay(TextArea ta) {
    display=ta;
    displayActive=true;
  }
  
  public void addStream(InputStream is) {
    synchronized (inputStreams) {
      inputStreams.addElement(is);
      if (inputStreams.size()==1) {
        synchronized (o) { 
          o.notify(); 
        }
      }
    }
  }
  
  public void stopThread() {
    continueRunning=false;
  }
  
  public void startThread() {
    continueRunning=true;
    synchronized(o) {
      o.notify();
    } 
  }
  
  
  public void run() {
    while (true) {
      synchronized(o) {
        while (!continueRunning) {
          try {
            o.wait();
          } catch (Exception fe) {
          }
        }
      }
      
      if (displayActive) {
        Enumeration e = inputStreams.elements();
        InputStream is;
        int i;
        int j;
        String clearString;
        int clearLength;
        while (e.hasMoreElements()) {
          is = (InputStream)e.nextElement();
          try {
            if ((i=is.available()) > 0) {
              //System.out.println("Stuff to display: "+i);

              //if(i >kBUFFSIZE) i=kBUFFSIZE;
              //some data is available, so read it in.
              //the amount of available data may grow before we read
              //it in so mine as well grab up to a full buffersize of it
              //j will contain the number of chars actually read
              j=is.read(b,0,kBUFFSIZE);                 
            
              //System.out.println("Before append");
              display.append(new String(b,0,j));
              clearString = display.getText();
              clearLength = clearString.length();
	      //System.out.println("Size of text: " +clearLength);
              
              if(clearLength > kTRIMOUTPUT) {
                display.setText(
				clearString.substring(clearLength-kKEEPONTRIM));
                display.setCaretPosition(kKEEPONTRIM);
                //System.out.println("Shrinking text area...");
              }
              //System.out.println("After append");
            }
          }
          catch (IOException ex) {
            inputStreams.removeElement(is);
            while(inputStreams.size()==0) {
              synchronized(o) {
                try {
                  o.wait();
                } catch (Exception eff) {
                }
              }
            }
          }
        }
      }
      /* got to sleep for a while */
      try {
        sleep(30);
      }
      catch(InterruptedException ie) {
        System.err.println("Got interrupted in OutputDirector.");
      }
      //yield();
    }
  }
}

class NetControlFrame extends Frame {
  public final static String kCLEARSTRING = "CLEARING\n";
  NetController nc;
  TextArea ta,txtOutput;
  Button killButton,displayButton,clearButton;
  TextField killWho;
  TextField status;
  OutputDirector thread;
  
  public NetControlFrame(NetController n, String name) {
    nc = n;

    setLayout (new BorderLayout ());
    status = new TextField("Net Controller");
    status.setEditable(false);
    add(status, "North");

    Panel processFields = new Panel();
    Panel txtfields = new Panel();
    txtfields.setLayout(new BorderLayout());
    processFields.setLayout(new BorderLayout());
    
    Label taLabel =
      new Label("Process:                               Owner:");
    processFields.add(taLabel,"North");
    ta = new TextArea ("",8,40,TextArea.SCROLLBARS_VERTICAL_ONLY);
    ta.setEditable (false);
    processFields.add (ta, "Center");
    txtfields.add(processFields, "North");
    
    Panel panel1 = new Panel ();
    panel1.setLayout (new FlowLayout ());

    Label label1 = new Label("Name to Kill:");
    panel1.add(label1);
    killWho = new TextField ("",25);
    panel1.add(killWho);
    killButton = new Button ();
    killButton.setLabel ("Kill");
    displayButton=new Button("stop output");
    clearButton=new Button("clear output");
    panel1.add (killButton);
    panel1.add(displayButton);
    panel1.add(clearButton);
    add( panel1, "South");


    txtOutput = new TextArea("",8,40,TextArea.SCROLLBARS_VERTICAL_ONLY);
    txtOutput.setEditable(false);
    txtfields.add(txtOutput,"Center");
    add(txtfields,"Center");
	 
    setTitle(name);
    validate();
    pack();
    show();
  }

  public void setThread(OutputDirector t) {
    thread=t;
  }
  
  public TextArea getTxtOutput() {
    return txtOutput;
  }
  
  public void relist(){
    Vector processes;
    processes = nc.printProcessesG();
    //clear the text area.
    ta.setText("");
    for(int i = 0; i < processes.size(); i++ ) {
      //add the processes one by one
      ta.append(((String) processes.elementAt(i)) +"\n");
    }
  }

  public synchronized boolean handleEvent(Event e){
    if(e.id == e.WINDOW_DESTROY) {
      nc.shutdown();
      return true;
    }
    else if(e.id == e.ACTION_EVENT) {
      if(e.target == killButton || e.target == killWho) {
        String whoToKill = killWho.getText();
        if(nc.killProcess( whoToKill )) {
          status.setText("Kill successful!");
        }
        else {
          status.setText("Kill failed!");
        }
        return true;
      } else if(e.target==displayButton) {
        if (displayButton.getLabel().equals("watch output")) {
          thread.startThread();
          displayButton.setLabel("stop output");
        } else if(displayButton.getLabel().equals("stop output")) {
          thread.stopThread();
          displayButton.setLabel("watch output");
        }
        return true;
      } else if(e.target==clearButton) {
        txtOutput.setText(kCLEARSTRING);
        txtOutput.setCaretPosition(kCLEARSTRING.length());
        return true;
      }
    }
    return super.handleEvent(e);
  }
}

