package adaptive.core;

/*****************************************************************
 * <!
 * PROJECT: Adaptable 
 *
 * FILE: PBAgent.java
 * 
 * ABSTRACT:
 * >
 * Input port for agents.
 *
 * @author Charles Tennent <A HREF="mailto:tennent@andrew.cmu.edu">tennent@andrew.cmu.edu</A>
 * @author <br>Ted Pham <A HREF="mailto:telamon@CMU.EDU">telamon@CMU.EDU</A></br>
 * @version  1.00 11/18/98
 *
 * <!
 * REVISION HISTORY:
 * Version  Date       Who        What
 * -------  -------    -------    --------------------  
 * 1.10     11/18/98   cht        Created.
 * >
 *****************************************************************/
class InputPort extends Port {
  /** output port that I am getting input from */
  private OutputPort provider;
  
  /******************************************************************
   * <!
   * Method: InputPort()
   *
   * Description:
   * >
   * Constructor that sets port type to the specified type
   * 
   * @param portType the type of the input port
   *
   * @return 
   *
   * @exception 
   ******************************************************************/

  InputPort(Class portType) {
    super(portType);
    provider = null;
  }

  /******************************************************************
   * <!
   * Method: InputPort()
   *
   * Description:
   * >
   * Constructor that sets port name to the specified type
   * 
   * @param portName the name of the input port
   *
   * @return 
   *
   * @exception 
   ******************************************************************/

  InputPort(String portName) {
    super(portName);
    provider = null;
  }
  
  /******************************************************************
   * <!
   * Method: getMapping()
   *
   * Description: 
   * >
   * Returns the name and output port number of this input port's currently
   * mapped source.
   * 
   * @param 
   *
   * @return a space seperated string containing the providing agent's
   *         name and output number or null if no provider is mapped to this
   *         input port
   *
   * @exception 
   ******************************************************************/
  synchronized String getMapping() {
    if(provider != null) {
      return new String(provider.getOwnerID()+" "+provider.getIndex());
    }
    return null;
  }

  /******************************************************************
   * <!
   * Method: setMapping()
   *
   * Description: 
   * >
   * Sets the input port's source if the types match.
   * 
   * @param p the new source port
   *
   * @return true if the source was set. <br> false if the source
   *         was not set <\br>
   *
   * @exception 
   ******************************************************************/
  synchronized boolean setMapping(OutputPort p) {
    if( getType().isAssignableFrom(p.getType()) ) {
      provider = p;
      return true;
    }
    return false;
  }

  /******************************************************************
   * <!
   * Method: getInput()
   *
   * Description: 
   * >
   * Gets the current source value from the providing agent
   * 
   * @param 
   *
   * @return the source data; <br> null if input port isn't currently
   *         mapped to an output port<\br>
   *
   ******************************************************************/
  
  public synchronized Object getInput() {

    if(provider == null) {
      return null;
    }
    return provider.getOutput();
  }

  /******************************************************************
   * <!
   * Method: verify()
   *
   * Description: 
   * > 
   * Checks to see if there is a data provider. 
   * @param 
   *
   * @return true if everything is valid; <br> false if any of the above is
   *         invalid <\br>
   *
   * @exception 
   *
   ******************************************************************/
  synchronized boolean verify() {
      System.out.println("Verifying "+this+" from "+provider);
    if(provider != null &&
       this.getType().isAssignableFrom(provider.getType())) {
      return true;
    }
    return false;
  }
  public String toString(){
    return ("InputPort{class="+getType()+"}");
  }
}
