package adaptive.core;

import java.io.*;
/*****************************************************************************
 * <! Copyright 1998, Institute for Complex Engineered Sytems,
 *                    Carnegie Mellon University
 *
 * PROJECT: Adaptable 
 *
 * FILE: InputLocation.java 
 * >
 *
 * Class representing an agent input mapping.
 *
 * @author  Charles Tennent <A HREF="mailto:cht@cs.cmu.edu">cht@cs.cmu.edu</A>
 *
 * @version  1.00 11/18/98<br> </br>
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log: InputLocation.java,v $
 * Revision 1.5  1999/04/06 15:11:58  yatish
 * Massive changes to the Save File format along with the addition of Macro
 * support.
 *
 * Revision 1.4  1998/12/07 13:17:33  telamon
 * fixed the SystemExecutor
 *
 * >
 ****************************************************************************/
public class InputLocation implements Serializable, Cloneable{

  static final long serialVersionUID = 2687110204160241822L;
  /** the agent providing the output for this input location */
  public String agentID;
  /** what output from agentID are we using? */
  public int outputNum;
  /** what input is the ouput being wired to */
  public int inputNum;

  /******************************************************************
   *
   * Default constructor that sets everything to null or 0.
   * 
   * @param 
   *
   * @return 
   *
   * @exception
   *
   ******************************************************************/
  public InputLocation() {
    agentID = null;
    outputNum = 0;
    inputNum = 0;
  }
  
  /***************************************************************************
   *
   * Constructor that takes providing agentID, providing agent output
   * number and agent's input number.
   *
   * @param agID providing agentID
   * @param oNum providing agent output number
   * @param iNum the agent's input number
   *
   * @return 
   *
   * @exception 
   *
   **************************************************************************/
  public InputLocation(String agID, int oNum, int iNum) {
    agentID = agID;
    outputNum = oNum;
    inputNum = iNum;
  }

  
  /***************************************************************************
   *
   * Get the providing agent ID.
   *
   * @param 
   *
   * @return the providing agent's ID.
   *
   * @exception 
   *
   **************************************************************************/
  public String getAgentID() {
    return agentID;    
  }

  /***************************************************************************
   *
   * Sets the providing agent ID.
   *
   * @param agID the providing agent's ID.
   *
   * @return 
   *
   * @exception 
   *
   **************************************************************************/
  public void setAgentID(String agID) {
    agentID = agID;    
  }

  /***************************************************************************
   *
   * Get the providing agent output number.
   *
   * @param 
   *
   * @return the providing agent output number.
   *
   * @exception 
   *
   **************************************************************************/
  public int getOutputNum() {
    return outputNum;    
  }

  /***************************************************************************
   *
   * Sets the providing agent ID.
   *
   * @param oNum the providing agent output number.
   *
   * @return 
   *
   * @exception 
   *
   **************************************************************************/
  public void setOutputNum(int oNum) {
    outputNum = oNum;    
  }

  /***************************************************************************
   *
   * Get the input number.
   *
   * @param 
   *
   * @return the input number
   *
   * @exception 
   *
   **************************************************************************/
  public int getInputNum() {
    return inputNum;    
  }

  /***************************************************************************
   *
   * Sets the input number.
   *
   * @param iNum the input number
   *
   * @return 
   *
   * @exception 
   *
   **************************************************************************/
  public void setInputNum(int iNum) {
    inputNum = iNum;    
  }
  
  /******************************************************************
   *
   * Makes a new copy of itself.
   *  
   * @param 
   *
   * @return cloned self
   *
   * @exception 
   ******************************************************************/
  public Object clone() {
    InputLocation retVal = new InputLocation();    
    retVal.setAgentID(this.getAgentID());
    retVal.setOutputNum(this.getOutputNum());
    retVal.setInputNum(this.getInputNum());
    return retVal;
  }

  public String toString() {
	return "InputLocation: "+outputNum+" from "+agentID+" to "+inputNum;
  }
  
}
