package adaptive.core;

/*****************************************************************************
 * <! Copyright 1998, Institute for Complex Engineered Sytems,
 *                    Carnegie Mellon University
 *
 * PROJECT: Adaptable 
 *
 * FILE: ExecutorCallback.java 
 * >
 *
 * An interface for code transplanting and morphing. The
 * SystemExecutor basically contains loading code and port management code.
 * It must be wrapped in a Launcher or a NetExecutor which manage control and
 * manipulate configurations as well as multi-computer cooperation. ExecutorCallback
 * is passed to SystemExecutors upon creation to grant Evaluator agents the power to
 * reconfigure the code.
 * 
 * @author Theodore Q Pham <A HREF="mailto:telamon@CMU.EDU">telamon@CMU.EDU</A>
 *         <br> </br>
 *
 * @version  1.00 xx/xx/98<br> </br>
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log: ExecutorCallback.java,v $
 * Revision 1.2  1999/02/09 20:08:15  telamon
 *  new Adaptive core for 2/10 demo
 *
# Revision 1.1  99/02/07  15:23:38  telamon
# blah
# 
 * >
 ****************************************************************************/
public interface ExecutorCallback {
  /** Currently only the coarsest code migration is available. i.e. you
      can only move the system as a whole.

      whereToJump is the hostname of the machine the code should move to.

      NOTE: This method only returns if an error ocurrs. Otherwise,
      this executor will shut down.
  */
  public void jumpShip(String whereToJump, Agent moverAg);
  
  /** on the fly switch from one agent to another. the
      agents must be port for port compatible to use this method */
  public boolean swapAgents(String name, String newAgentType);
}
