package adaptive.core;

import java.io.FilenameFilter;
import java.io.File;
/*****************************************************************************
 * <! Copyright 1998, Institute for Complex Engineered Sytems,
 *                    Carnegie Mellon University
 *
 * PROJECT: Adaptable 
 *
 * FILE: DirectoryFilter.java 
 * >
 *
 * Filters directory listings for directories.
 * 
 * @author Theodore Q Pham <A HREF="mailto:telamon@CMU.EDU">telamon@CMU.EDU</A>
 *         <br> </br>
 *
 * @version  1.00 9/24/98<br> </br>
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log: DirectoryFilter.java,v $
 * Revision 1.2  1999/02/05 21:13:06  telamon
 * new agentloader
 *
 * >
 ****************************************************************************/
public class DirectoryFilter implements FilenameFilter {
  
  File theFile;

  public DirectoryFilter() {
    super();
  }

  public boolean accept(File dir, String name) {
    theFile = new File(dir,name);
    if(theFile.isDirectory()) {
      return true;
    }
    else {
      return false;
    }
  }
}
