package adaptive.core;

import java.util.*;
import adaptive.core.net.*;
import java.io.*;
import java.net.*;

public class CoordinatorTest extends Thread {
  Socket socket;
  String host;
  int port;
  SystemConfiguration sc;
  ObjectOutputStream outStream;
  ObjectInputStream inStream;
  Vector agentServer;
  public boolean goon;
  
  public CoordinatorTest(String host,int port,SystemConfiguration sc,Vector v) {
    this.host=host;
    this.port=port;
    this.sc=sc;
    this.agentServer=v;
    goon=true;
  }
  public void setFalse() {
    System.out.println("setting goon to false");
    goon=false;
    System.out.println("goon is now at:"+goon);
  }
  
  public void run() {
    try {
      socket = new Socket(host,port);
      outStream = new ObjectOutputStream(socket.getOutputStream());
      inStream = new ObjectInputStream(socket.getInputStream());
      System.out.print("Sending identification..");
      if (CoordinatorProtocol.goodReceiver(CoordinatorProtocol.kIAMAMODULEMANAGER,CoordinatorProtocol.kIAMACOORDINATOR,inStream,outStream)) {
	System.out.println("..success.");
      } else {
	System.out.println("..unable to identify");
	socket.close();
	return;
      }

      /* this cannot be sent until after a system has been received.
	 but a system cannot be received until it knows about an
	 agentserver.  so we piggy back the agentserver on the
	 systemconfiguration
      outStream.writeObject(CoordinatorProtocol.kUSEAGENTSERVER);
      outStream.writeObject(agentServer);
      Byte d=(Byte)inStream.readObject();
      if (!d.equals(CoordinatorProtocol.kOK)) {
	System.out.println("ACK! didn't like agentserver demand");
      }
      */
      Byte d;
      
      outStream.writeObject(CoordinatorProtocol.kRECEIVESYSTEM);
      if (CoordinatorProtocol.isOK(inStream.readObject())) {
	System.out.print("Sending sysconfig...");
	Vector v = new Vector(2);
	v.setSize(2);
	v.setElementAt(sc,0);
	v.setElementAt(agentServer,1);
	outStream.writeObject(v);
	if (CoordinatorProtocol.isOK(inStream.readObject())) {
	  System.out.println("..success");
	} else {
	  System.out.println("..FAILED!");
	  socket.close();
	  return;
	} 
      }


      
      System.out.print("Starting system..");
      outStream.writeObject(CoordinatorProtocol.kSTARTRUN);
      outStream.writeObject(sc.getType());
      if (CoordinatorProtocol.isOK(inStream.readObject())) {
	System.out.println("Success..");
      }
      // read in the kSYSTEMSTARTED message
      d=(Byte)inStream.readObject();
      System.out.println("message:"+d); 
      try {
	while (goon && !isInterrupted()) {
	  sleep(1000);
	}
      } catch (Exception e) {
	System.out.println("catch exception "+e);
      }
      
      System.out.print("Stoping system..");
      outStream.writeObject(CoordinatorProtocol.kSTOPRUN);
      Byte c = (Byte)inStream.readObject();
      if (CoordinatorProtocol.isOK(c)) {
	System.out.println("..success.");
      } else if(c.equals(CoordinatorProtocol.kERROR)) {
	System.out.print("..Error ");
	System.out.println((Exception)inStream.readObject());
      }
      System.out.println("response=="+c);
      System.out.print("shutting down system..");
      outStream.writeObject(CoordinatorProtocol.kSHUTDOWN);
      c=(Byte)inStream.readObject();
      System.out.print(c);
      if (CoordinatorProtocol.isOK(c)) {
	System.out.println("..success");
      } else {
	if (c.equals(CoordinatorProtocol.kERROR)) {
	  Exception j = (Exception)inStream.readObject();
	  System.out.print(j);
	}
	System.out.println("..failed");
      }
      outStream.writeObject(CoordinatorProtocol.kGOODBYE);
      socket.close();
    } catch (Exception e) {
      System.out.println("Socket closed. Closing down.");
    }
    System.out.println("end run");
  }
  
  public void close() {
    interrupt();
    System.out.println("interrupting");
    /*
    try {
      socket.close();
    } catch (Exception e) {
    }*/
  }
  
	
  public static void main(String args[]) {
    String filename = args[0];
    try {
      System.out.print("Opening system configuration...");
    ObjectInputStream ois =
      new ObjectInputStream(new java.util.zip.GZIPInputStream(new FileInputStream(filename)));
    SystemConfiguration sc= (SystemConfiguration)ois.readObject();
    ois.close();
    System.out.println("...success.");
    System.out.print("Contacting directory server...");
    DirectoryInfo dirInfo = new DirectoryInfo(args[1],Integer.parseInt(args[2]),"CoordTest");
    dirInfo.retrieveDirInfo();
    Enumeration e =dirInfo.getCoordinators();
    System.out.println("...sucesss.");
    CoordinatorTest ct=null;
    System.out.print("Contacting coordinator...");
    if (e==null) {
      System.out.println(".FAILED! No Coordinator found.");
      System.exit(0);
    }
    Vector v=new Vector();
    v.setSize(2);
    PhoneEntry pe=dirInfo.getAgentServerEntry();
    v.setElementAt(pe.getHost(),0);
    v.setElementAt(new Integer(pe.getPort()),1);
    while (e.hasMoreElements()) {
      String name=(String)e.nextElement();
      System.out.println("name:"+name);
      pe = dirInfo.getCoordinatorEntry(name);
      System.out.println("coordinator:"+pe);
      ct = new CoordinatorTest(pe.getHost(),pe.getPort(),sc,v);
      ct.start();
    }
    if (ct==null) {
      System.out.println(".FAILED! No Coordinator found.");
      System.exit(0);
    }
    System.out.println("...success.");
    byte keyPress=0;
    while(keyPress != (byte) 'q' && keyPress != (byte) 'Q') {
      System.err.print("Quit? ");
      keyPress = (byte) System.in.read();
    }
    System.out.println("calling ct.interrupt()");
  
    ct.setFalse();
  
    ct.interrupt();

    while(ct.isAlive()) {
    }
    System.out.println("no longer alive");
    } catch (Exception e) {
      e.printStackTrace();
    }
    
    //System.exit(0);
  }
  
}

