package adaptive.core;

import java.net.*;
import java.io.*;
import java.util.*;
import comms.core.*;

public class ConfigTransferProtocol implements AdaptiveProtocol {
  /** 1 minutes */
  final static int kTIMEOUTMILLIS = 60000;

  public static Message moveCodeResponse(String names) {
    return new Message(AdaptiveProtocol.kCODE_MOVE_DONEST+names);
  }
  
  /** returns Object[3]
      0) The local socket that the NetExecutor connected too
      1) The buffered ObjectOutputStream for 0
      2) The buffered ObjectInputStream for 0
  */
  public static Object[] initiateNewRemote(Communications commLink, ServerSocket ss, MessageQueue mq, String remoteName, String owner, boolean remoteDebug) throws IOException {
    /* 1. Send a NetExecutor creation request to the NetControl corresponding
          to the remote name.
       2. Wait for the NetController response. and quit if denied
       3. Accept the connection to ss.
       4. Map the Object in and out streams.
       5. make sure the person on the other end of the object stream
          is who we expected
    */
    Object[] retVal;
    String currNetCon = "NetControl"+remoteName.substring(remoteName.lastIndexOf('@'));
    StringBuffer sb = new StringBuffer(150);
    boolean error=false;
    String errMess=null;
    //step 1.
    ss.setSoTimeout(kTIMEOUTMILLIS);
    commLink.setMessageQueue(currNetCon,mq,true);
    sb.append((char)kPROCESSREQUEST);
    sb.append(remoteName);
    sb.append(" ");
    sb.append(owner);
    sb.append(" ");
    sb.append(commLink.getLocalHost());
    sb.append(" ");
    sb.append(ss.getLocalPort());
    if(remoteDebug) {
      sb.append(" ");
      sb.append(true);
    }
    try{
      commLink.sendMessage(currNetCon, new Message(sb.toString()));
    }
    catch(NoPhoneNumberException npne){
      error = true;
      errMess = "No directory entry for "+currNetCon;
    }
    catch(IOException ioe){
      error = true;
      errMess = ioe.getMessage();
    }
    if(error){
      commLink.closeConnection(currNetCon);
      commLink.unsetMessageQueue(currNetCon);
      throw new IOException(errMess);
    }

    //step 2.
    System.out.println("before listening to netCon response");
    Message netConResponse = commLink.readNextMessage(mq);
    System.out.println("after listening to netCon response");
    String netConResSt = netConResponse.getMessage();
    if(netConResSt.equals(Communications.kDISCONNECTED)) {
      throw new IOException("Net Controller failure. -->"+currNetCon);
    }
    else if(kPROCSUCCESS != (byte) netConResSt.charAt(0)) {
      commLink.closeConnection(currNetCon);
      commLink.unsetMessageQueue(currNetCon);
      throw new IOException("Net Controller denied remote launch request. -->"+currNetCon);
    }
    //made it here so we definitely got a proccess success

    System.out.println("Successful process request from net controller.");
    
    //step 3.
    retVal = new Object[3];
    boolean rightOne = false;
    String ident;
    while(!rightOne) {
      try {
        System.out.println("Waiting for connection from remote.");
        retVal[0] = ss.accept();
        //step 4.
        retVal[1] = new ObjectOutputStream(
          new BufferedOutputStream(((Socket)retVal[0]).getOutputStream()));
        ((ObjectOutputStream)retVal[1]).flush();
        retVal[2] = new ObjectInputStream(
          new BufferedInputStream(((Socket)retVal[0]).getInputStream()));
        
        ident = (String) ((ObjectInputStream)retVal[2]).readObject();
        if(ident.equals(remoteName)) {
          rightOne = true;
        }
      }
      catch(IOException ioe) {
        if(ioe instanceof InterruptedIOException) {
          System.out.println(remoteName+
                             " timed out connecting to "+
                             commLink.getMyName());
          cleanupSocket((Socket) retVal[0], (ObjectOutputStream) retVal[1],
                        (ObjectInputStream) retVal[2]);
          retVal[0] = null;
          retVal[1] = null;
          retVal[2] = null;
          commLink.closeConnection(currNetCon);
          commLink.unsetMessageQueue(currNetCon);
          throw ioe;
        }
      }
      catch(ClassNotFoundException uce) {
        System.err.println("Unknown Class read object. THIS SHOULD NOT HAPPEN.");
        uce.printStackTrace();
        System.exit(0);
      }
    }
    commLink.unsetMessageQueue(currNetCon);
    return retVal;
  }

  public static void cleanupSocket(Socket s,ObjectOutputStream oos,
                                   ObjectInputStream ois) {
    try {
      if(oos != null) {
        oos.close();
      }
    }
    catch(IOException ioe) {  
    }
    try {
      if(ois != null) {
        ois.close();
      }
    }
    catch(IOException ioe) {  
    }
    try {
      if(s != null) {
        s.close(); 
      }
    }
    catch(IOException ioe) {  
    }
  }

  /** If we successfully return from this functionm, then we've made our connection with
      the other side and we can sit and wait for further orders. Like an agent
      container coming down the pipe. If this method throws an exception, we're dead,
      nothing more to do.
  */
  public static Object[] respondToInitiator(String hostname, int port, String myName) throws IOException {
    Object[] retVal = new Object[3];
    //careful, order of instantiation matters for the in/out streams
    System.out.println("Host: "+hostname+" Port"+port);
    System.out.println("Before socket.");
    retVal[0] = new Socket(hostname, port);
    System.out.println("after socket.");
    System.out.println("before out stream.");
    retVal[1] = new ObjectOutputStream(
      new BufferedOutputStream(((Socket) retVal[0]).getOutputStream()));
    System.out.println("after out stream.");
    ((ObjectOutputStream) retVal[1]).flush();
    ((ObjectOutputStream) retVal[1]).writeObject(myName);
    ((ObjectOutputStream) retVal[1]).flush();
    System.out.println("before in stream.");
    retVal[2] = new ObjectInputStream(
      new BufferedInputStream(((Socket) retVal[0]).getInputStream()));
    System.out.println("after in stream.");
    return retVal;
  }
}

