package adaptive.core;

import comms.core.*;

public class AgentServerProtocol {
  public static final byte kDEAD = 1;
  public static final byte kHANDSHAKE = 2;
  public static final String kHELLOCLIENT = ""+(char) kHANDSHAKE+"MODCLIENT";
  public static final String kHELLOSERVER = ""+(char) kHANDSHAKE+"MODSERVER";
  public static final String kREJECTCONNECT = ""+(char) kHANDSHAKE+"REJECT";
  public static final byte kDENIED = 3;
  public static final byte kOKAY = 4;
  public static final byte kNO = 5;
  public static final byte kTIMEOUT = 6;
  public static final byte kUNKNOWN = 7;
  /** client sends this to the server before closing connection */
  public static final byte kBYE = 8;
  public static final byte kREQ_PACKAGEROOT = 9;
  public static final byte kREQ_CLASS = 10;
  public static final byte kREQ_LISTDIR = 11;
  public static final byte kREQ_LISTFILES = 12;
  public static final byte kREQ_LISTAGENTS = 13;
  public static final byte kREQ_PATHISFILE = 14;
  public static final byte kREQ_PATHISDIR = 15;
  public static final byte kREQ_PATHEXISTS = 16;
  public static final byte kREQ_GETFILEINSTREAM = 17;
  public static final byte kREQ_GETFILEOUTSTREAM = 18;
  public static final byte kREQ_DELETE = 19;
  public static final byte kREQ_MKDIR = 20;
  public static final byte kREQ_RENAME = 21;
  
  public static byte identifyRequest(byte b) {
    if(b >= kBYE &&
       b <= kREQ_RENAME) {
      return b;
    }
    return kUNKNOWN;
  }

  /* start is the beginning index, end is the end index */
  private static int parseIntSubstring(String s, int start, int end)
    throws NumberFormatException {
    int retVal=0;
    if( s == null ) {
      throw new NumberFormatException("Null string.");
    }
    if( s.length() < 1 ||
        start < 0 ||
        start >= s.length() ||
        end < 0 ||
        end >= s.length()) {
      throw new NumberFormatException("Empty string or bad indices.");
    }
    for(int i=end,tens=1; i >= start; i--,tens*=10) {
      if(s.charAt(i)<'0' || s.charAt(i) > '9'){
        throw new NumberFormatException(s.substring(start,end+1));
      }
      retVal += tens*(s.charAt(i) - '\u0030');
    }
    return retVal;
  }
}

  
  

