package adaptive.core;

import java.io.FilenameFilter;
import java.io.File;


public class AgentNameFilter implements FilenameFilter {
 /** 
    * PROJECT: <What's our official name?>
    *
    * FILE: AgentNameFilter.java
    *
    * ABSTRACT: Filters directory listings for just class files.
    *           <Also may be used to enforce a prefix for Agent names.
    *            So we don't try to load every class we come across.>
    *
    *
    * AUTHOR: Ted Pham <telamon@CMU.EDU>
    *
    * REVISION HISTORY:
    * Version             Date       Who
    * -------             -------    ---------------
    * Revision 1.00       9/24/98    telamon
    * Created. 
    *
    **/
  File theFile;

  public AgentNameFilter() {
    super();
  }

  public boolean accept(File dir, String name) {
    theFile = new File(dir,name);
    if(name.startsWith("PBA") &&
       name.endsWith(".class") &&
       (name.indexOf((int) '$') == -1) &&
       theFile.isFile()) {
      return true;
    }
    else {
      return false;
    }
  }
}
