package adaptive.agentserver;

import comms.core.EntryTypes;
import adaptive.core.LocalAgentLoader;
import adaptive.core.AgentLoaderException;
import adaptive.core.net.DirectoryInfo;
//import java.util.*;

import java.net.Socket;
import java.net.ServerSocket;
import java.io.File;
import java.io.IOException;
import java.io.FileInputStream;


//import java.lang.reflect.*;

public class AgentServer extends LocalAgentLoader implements Runnable {
  final static String kDIRIP = "localhost";
  final static int kDIRPORT = 6500;
  final static String kSERVERNAME = "AgentServer";
  final static boolean kMLOG = false;

  DirectoryInfo dirInfo;
  ServerSocket serverSocket;
  
  /***************************************************************************
   *
   * AgentServer constructor.
   *
   * 1. init super class with package root
   * 2. Opens a server socket port to listen for clients.
   * 3. Registers it's listening port with Directory Server.
   *
   * @param dirHost the directory server hostname
   * @param dirPort the directory server port number
   * @param pRoot   the package root
   *
   * @return 
   *
   * @exception AgentLoaderException thrown when pRoot is not valid
   * @exception IOException thrown if the directory server can't
   *                                 be contacted
   *
   **************************************************************************/
  public AgentServer(String dirHost, int dirPort, String pRoot)
    throws AgentLoaderException, IOException {
    super(pRoot);

    /* start up a server socket on the first available port to
       listen for connections */
    serverSocket = new ServerSocket(0);

    /* init directory info and regsiter with the dir server */
    dirInfo = new DirectoryInfo(dirHost, dirPort, kSERVERNAME);
    dirInfo.registerWithDirectory( serverSocket.getLocalPort(),
                                   EntryTypes.ADAPTABLE_MODULESERVER);
    System.out.println("Successfully registered with directory");
  }
  
  
  public void run() {
    //main connection listening loop
    while(true){
      Socket newClientSock;
      try {
        
        newClientSock = serverSocket.accept();
      
        AgentServerClientThread asc;
        asc = new AgentServerClientThread(newClientSock, this );
        asc.setDaemon(true);
        asc.start();
      }
      catch(IOException ioe) {
        ioe.printStackTrace();
      }
    }
  }

  /***************************************************************************
   * Convert a full classname to a file name.
   * Start with package root.
   * then add on a file seperator char
   * then do a simple replace on all . to a file seperator char
   * finally add the .class
   * Notice, this method has trouble locating 
   ***************************************************************************/
  protected byte[] getClassBytes(String cname) throws ClassNotFoundException{
    try{
      byte[] retVal;
      StringBuffer sb = new StringBuffer(200);
      String fullCPath;
      File cFile;
      sb.append(getPackageRoot());
      sb.append(File.separatorChar);
      sb.append(cname.replace('.',File.separatorChar));
      sb.append(".class");
      fullCPath = sb.toString();
      cFile = new File(fullCPath);
      retVal = new byte[(int) cFile.length()];

      FileInputStream fis = new FileInputStream(fullCPath);
      fis.read(retVal);
      return retVal;
    }
    catch(IOException ioe){
      throw new ClassNotFoundException(ioe.getMessage());
    }
  }
    
  public static String usage() {
    return "java adaptive.agentserver.AgentServer [options]\n"+
      "Defaults: DirIP = "+kDIRIP + "\n"+
      "          DirPort = "+kDIRPORT + "\n"+
      "          RootPath = "+kPACKAGEROOT+"\n"+
      "          MessageLogging = "+kMLOG+"\n"+
      "Options:\n"+
      "Use -N <DirIP> <DirPort> to override defaults\n"+ 
      "Note: -N overrides -h and -p as well\n"+
      "use -H <DirIP> to override default DirIP\n"+ 
      "Use -p <DirPort> to override default DirPort\n"+ 
      "Use -r <RootPath> to set the root path\n"+ 
      "Use -? or -h for this help file\n";
  }

  public static void commandLineError(char ch) throws Exception {
    throw new Exception("Bad Usage of -"+ch+". Use -h or -? for help");
  }
  
  public static void main(String[] args) {
    boolean bigNet = false;
    boolean littleNet = false;
    String hostname = kDIRIP;
    int port = kDIRPORT;
    String rootPath = null;
    boolean mLog = kMLOG;
    int currArg = 0;
    try {
      while(currArg < args.length) {
	if(args[currArg].length() >= 2 && args[currArg].charAt(0) == '-') {
	  switch(args[currArg].charAt(1)) {
            case 'r': 
              if((args.length - currArg -1) >= 1) {
                rootPath = args[currArg +1];
                currArg+=2;
              }
              else {
                commandLineError('r');
              }
              break;
            case 'N':
              if((args.length - currArg-1) >= 2) {
                hostname = args[currArg+1];
                port = Integer.parseInt(args[currArg+2]);
                bigNet = true;
                currArg+=3;
                if(littleNet) {
                  System.err.println("-N overriding -h and -p");
                }
              }
              else {
                commandLineError('N');
              }
              break;
            case 'H':
              if((args.length - currArg-1) >= 1) {
                if(!bigNet) {
                  hostname = args[currArg+1];
                  littleNet = true;
                }
                else {
                  System.err.println("-N already overriding -H");
                }
                currArg+=2;
              }
              else {
                commandLineError('H');
              }
              break;
            case 'p':
              if((args.length - currArg-1) >= 1) {
                if(!bigNet) {
                  port = Integer.parseInt(args[currArg+1]);
                  littleNet = true;  
                }
                else {
                  System.err.println("-N already overriding -p");
                }
                currArg+=2;
              }
              else {
                commandLineError('p');
              }
              break;
            case '?':
            case 'h':
              System.err.println(usage());
              System.exit(0);
              break;
            default:
              throw new Exception("Bad Switch: "+args[currArg]+"\n"+usage());
	  }
	}
	else {
	  throw new Exception("Bad argument: "+args[currArg]+"\n"+usage());
	}
      }
      
      AgentServer agentserver = new AgentServer(hostname,port,rootPath);      

      Thread t = new Thread(agentserver);
      t.setDaemon(true);
      t.start();
      
      System.out.println("Press Q to quit.");
      byte keyPress = 0;
      while(keyPress != (byte) 'q' && keyPress != (byte) 'Q') {
        System.err.print("Quit? ");
        keyPress = (byte) System.in.read();
      }
      System.exit(0);
    }
    catch(AgentLoaderException ale) {
      System.err.println(ale.getMessage());
      System.err.println(">>"+rootPath+"<<");
    }
    catch(Exception e) {
      //e.printStackTrace();
      //System.err.println("Error in Main");
      System.err.println(e.getMessage());
    }
  }  /* main() */
} /* class AgentServer */
