package adaptive.agents;

import adaptive.core.*;

import java.io.*;
import java.util.*;
import java.lang.*;

/*****************************************************************************
 * <! Copyright 2000, Institute for Complex Engineered Systems,
 *                    Carnegie Mellon University
 * >
 *
 * < Description: 
 * >
 * 
 * @author Kevin R. Dixon <A HREF="mailto:krd@cs.cmu.edu">krd@cs.cmu.edu</A>
 *
 * @version  1.00
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log:        PBARandom.java,v $
 * >
 ****************************************************************************/
public class PBARandom extends PBAgent {


/****************************************************************************
 * <!
 * Description: set up the ports for this module.
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected void initialize() {

	/* we have to tell the system how many input and output ports this module has:
	   we have 0 inputs and 1 output */
	setNumInputsOutputs( 0, 1 );

	try {
	    /* tell the system what type of data we generate on output port 0 */
	    setOutputPortType( "java.lang.Double", 0 );   
	}
	catch( Exception e ) {
	    System.out.println( e.getClass() + ": Invalid port type: " + e.getMessage() );
	    e.printStackTrace();
	}
	/*Tell the system how long the agent should sleep at the end of each call of runLoop*/
	this.setSleepTime(1000); 
    }

    

/****************************************************************************
 * <!
 * Description: set up internals (if we have any)  using this object
 * >
 *
 * @param state: object to use for internal state
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected boolean processInternalState( Object state ) {

	return( true );

    }



/****************************************************************************
 * <!
 * Description: set our output ports to an initial value
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected boolean initOutputVals() {

	/* I will arbitrarily choose to set output port 0 to "0.0" initially*/
	setOutput( new Double( 0.0 ), 0 );

	/* we should return "true" if A-OK, "false" otherwise */
	return( true );
	

    }



/****************************************************************************
 * <!
 * Description: serializes the internal state for this module
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    public Object dumpState() {

	/* we don't have any state, so we need not worry */
	return( null );

    }



/****************************************************************************
 * <!
 * Description: this function gets called periodically to perform some computation
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected void runLoop() {

	/* just set the output to some random value */
	setOutput( new Double( Math.random() ), 0 );

    }

} 
