package adaptive.agents;

import adaptive.core.*;

import java.io.*;
import java.util.*;
import java.lang.*;

/*****************************************************************************
 * <! Copyright 2000, Institute for Complex Engineered Systems,
 *                    Carnegie Mellon University
 * >
 *
 * < Description: simply prints the object on its input port 
 * >
 * 
 * @author Kevin R. Dixon <A HREF="mailto:krd@cs.cmu.edu">krd@cs.cmu.edu</A>
 *
 * @version  1.00
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log:        PBAPrint.java,v $
 * >
 ****************************************************************************/
public class PBAPrint extends PBAgent {


/****************************************************************************
 * <!
 * Description: set up the ports for this module.
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected void initialize() {

	/* we have to tell the system how many input and output ports this module has:
	   we have 1 inputs and 0 output */
	setNumInputsOutputs( 1, 0 );

	try {
	    /* tell the system what type of data we are expecting on input ports 0 and 1 */
	    setInputPortType( "java.lang.Object", 0 );
	}
	catch( Exception e ) {
	    System.out.println( e.getClass() + ": Invalid port type: " + e.getMessage() );
	    e.printStackTrace();
	}
	/*Tell the system how long to sleep between calls to runLoop*/
	this.setSleepTime(100);
    }

    

/****************************************************************************
 * <!
 * Description: set up internals (if we have any)  using this object
 * >
 *
 * @param state: object to use for internal state
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected boolean processInternalState( Object state ) {

	return( true );

    }



/****************************************************************************
 * <!
 * Description: set our output ports to an initial value
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected boolean initOutputVals() {

	/* we should return "true" if A-OK, "false" otherwise */
	return( true );

    }



/****************************************************************************
 * <!
 * Description: serializes the internal state for this module
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    public Object dumpState() {

	/* we don't have any state, so we need not worry */
	return( null );

    }



/****************************************************************************
 * <!
 * Description: this function gets called periodically to perform some computation
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected void runLoop() {

	/* look at what's on my input port, then print it */
	System.out.println( getID() + ": " + getInput( 0 ).toString() );

    }


} 
