package adaptive.agents;

import adaptive.core.*;

import java.io.*;
import java.util.*;
import java.lang.*;

/*****************************************************************************
 * <! Copyright 2000, Institute for Complex Engineered Systems,
 *                    Carnegie Mellon University
 * >
 *
 * < Description: Logical OR gate
 * >
 * 
 * @author Kevin R. Dixon <A HREF="mailto:krd@cs.cmu.edu">krd@cs.cmu.edu</A>
 *
 * @version  1.00
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log:        PBAORGate.java,v $
 * >
 ****************************************************************************/
public class PBAORGate extends PBAgent {
    

/****************************************************************************
 * <!
 * Description: set up the ports for this module.
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected void initialize() {

	/* we have to tell the system how many input and output ports this module has:
	   we have 2 inputs and 1 output */
	setNumInputsOutputs( 2, 1 );

	try {
	    /* tell the system what type of data we are expecting on input ports 0 and 1 */
	    setInputPortType( "java.lang.Boolean", 0 );
	    setInputPortType( "java.lang.Boolean", 1 );
	    
	    /* tell the system what type of data we generate on output port 0 */
	    setOutputPortType( "java.lang.Boolean", 0 );   
	}
	catch( Exception e ) {
	    System.out.println( e.getClass() + ": Invalid port type: " + e.getMessage() );
	    e.printStackTrace();
	}
	/*Tell the system how long to sleep between calls to runLoop*/
	this.setSleepTime(1000);
    }

    

/****************************************************************************
 * <!
 * Description: set up internals (if we have any)  using this object
 * >
 *
 * @param state: object to use for internal state
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected boolean processInternalState( Object state ) {

	return( true );

    }



/****************************************************************************
 * <!
 * Description: set our output ports to an initial value
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected boolean initOutputVals() {

	/* I will arbitrarily choose to set output port 0 to "false" initially (though "true" would be fine too) */
	setOutput( Boolean.FALSE, 0 );

	/* we should return "true" if A-OK, "false" otherwise */
	return( true );
	

    }



/****************************************************************************
 * <!
 * Description: serializes the internal state for this module
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    public Object dumpState() {

	/* we don't have any state, so we need not worry */
	return( null );

    }



/****************************************************************************
 * <!
 * Description: this function gets called periodically to perform some computation
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected void runLoop() {

	Boolean	input0	= (Boolean) getInput( 0 );
	Boolean	input1	= (Boolean) getInput( 1 );
	
	/* since we're a PBAORGate, we want need to compute the output based on the input values
	   and set the output accordingly */
	setOutput( new Boolean( input0.booleanValue() || input1.booleanValue() ), 0 );
	

    }


} 
