package adaptive.agents;

import adaptive.core.*;

import java.io.*;
import java.util.*;
import java.lang.*;

/*****************************************************************************
 * <! Copyright 2000, Institute for Complex Engineered Systems,
 *                    Carnegie Mellon University
 * >
 *
 * < Description: Agent example simulating a logic Clock. It uses
 * Boolean type for it's output port. <b>Note:<\b> Depending on the
 * platform and load on your system, timing may be imprecise. This is
 * an inherent problem in Java since we really don't have interrupts.
 * >
 * 
 * @author Kevin R. Dixon <A HREF="mailto:krd@cs.cmu.edu">krd@cs.cmu.edu</A>
 *
 * @version  1.00
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log:        PBAClock.java,v $
 * >
 ****************************************************************************/
public class PBAClock extends PBAgent {

    protected	long	m_half_clock_period;
    protected	long	m_last_time;

/****************************************************************************
 * <!
 * Description: set up the ports for this module.
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected void initialize() {

	/* we have to tell the system how many input and output ports this module has:
	   we have 0 inputs and 1 output */
	setNumInputsOutputs( 0, 1 );

	try {
	    /* tell the system what type of data we generate on output port 0 */
	    setOutputPortType( "java.lang.Boolean", 0 );   
	}
	catch( Exception e ) {
	    System.out.println( e.getClass() + ": Invalid port type: " + e.getMessage() );
	    e.printStackTrace();
	}
	/*Set sleep time to zero to stop default call of sleep between calls to runLoop*/
	this.setSleepTime(0);
    }

    

/****************************************************************************
 * <!
 * Description: set up internals (if we have any)  using this object
 * >
 *
 * @param state: object to use for internal state
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected boolean processInternalState( Object state ) {

	boolean	retval = true;
	

	m_last_time = 0L;

	/* if the state is null, the I'll arbitrarily say that the half clock period is 200 ms */
	if( state == null ) {
	    m_half_clock_period = 300L;
	}

	/* otherwise, state contains for info for us... let's see what it says! */
	else {
	    try {
		/* we'll cast it to a Long and see what the last period used to be */
		m_half_clock_period = ((Long) state).longValue();
		retval = true;
	    }
	    catch( Exception e ) {
		System.out.println( e.getClass() + ": " + e.getMessage() );
		e.printStackTrace();
		retval = false;
	    }
	}

	return( retval );

    }



/****************************************************************************
 * <!
 * Description: set our output ports to an initial value
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected boolean initOutputVals() {

	/* I will arbitrarily choose to set output port 0 to "false" initially (though "true" would be fine too) */
	setOutput( Boolean.FALSE, 0 );

	/* we should return "true" if A-OK, "false" otherwise */
	return( true );
	

    }



/****************************************************************************
 * <!
 * Description: serializes the internal state for this module
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    public Object dumpState() {

	/* here we're returning the clock period as the state of this module */
	return( new Long( m_half_clock_period ) );

    }


/****************************************************************************
 * <!
 * Description: this function gets called periodically to perform some computation
 * >
 *
 * @param 
 *
 * @return 
 *
 * @exception 
 *
 ***************************************************************************/
    protected void runLoop() {

	if( m_last_time == 0L ) {
	    m_last_time = System.currentTimeMillis();
	}
	
	long now_time = System.currentTimeMillis();
	
	/* if it's been long enough, then flip the output value */
	if( (now_time - m_last_time) >= m_half_clock_period ) {
	    setOutput( new Boolean( !(((Boolean) getOutput( 0 )).booleanValue()) ), 0 );

	    /* make sure we remember what time we flipped the output */
	    m_last_time = now_time;
	}

	/* let's yield the CPU to another needy thread */
	Thread.yield();

    }


} 
