(* moc-applet: control the MOC audio player
   Copyright (C) 2006  Eric C. Cooper <ecc@cmu.edu>
   Released under the GNU General Public License *)

let add_info pairs line =
  try
    let i = String.index line ':' in
    let key = String.lowercase (String.sub line 0 i) in
    let len = String.length line in
    if i + 2 < len && line.[i + 1] = ' ' then
      let value = String.sub line (i + 2) (len - i - 2) in
      (key, value) :: pairs
    else
      pairs
  with Not_found ->
    pairs

let read_lines chan =
  let next () =
    try Some (input_line chan)
    with End_of_file -> None
  in
  let rec loop lines =
    match next () with
    | Some line -> loop (line :: lines)
    | None -> lines
  in
  loop []

let unwind_protect body post =
  try let result = body () in post (); result
  with e -> post (); raise e

let with_process cmd f =
  let chan = Unix.open_process_in cmd in
  unwind_protect
    (fun () -> f chan)
    (fun () -> Unix.close_process_in chan)

let info = ref []

let update () =
  let lines = with_process "/usr/bin/mocp --info" read_lines in
  info := List.fold_left add_info [] lines

let lookup key = List.assoc key !info
