/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.io.files;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;
import org.jmat.io.files.DataFile;

public class ASCIIFile
extends DataFile {
    public ASCIIFile(File f) {
        super(f);
    }

    public static String read(File f) {
        ASCIIFile af = new ASCIIFile(f);
        return af.read();
    }

    public static String[] readLines(File f) {
        ASCIIFile af = new ASCIIFile(f);
        return af.readLines();
    }

    public static String readLine(File f, int i) {
        ASCIIFile af = new ASCIIFile(f);
        return af.readLine(i);
    }

    public static void write(File f, String t) {
        ASCIIFile af = new ASCIIFile(f);
        af.write(t, false);
    }

    public static void append(File f, String t) {
        ASCIIFile af = new ASCIIFile(f);
        af.write(t, true);
    }

    public String read() {
        StringBuffer text = new StringBuffer((int)this.file.length());
        try {
            FileReader fr = new FileReader(this.file);
            BufferedReader b = new BufferedReader(fr);
            boolean eof = false;
            String ret = "\n";
            while (!eof) {
                String line = b.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                text.append(line);
                text.append(ret);
            }
            b.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unreadable : ").append(e.toString()))));
        }
        return text.toString();
    }

    public String[] readLines() {
        Vector<String> linesVector = new Vector<String>();
        try {
            FileReader fr = new FileReader(this.file);
            BufferedReader b = new BufferedReader(fr);
            boolean eof = false;
            while (!eof) {
                String line = b.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                linesVector.add(line);
            }
            b.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unreadable : ").append(e.toString()))));
        }
        String[] lines = new String[linesVector.size()];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = (String)linesVector.get(i);
        }
        return lines;
    }

    public String readLine(int i) {
        String line = new String("");
        try {
            FileReader fr = new FileReader(this.file);
            BufferedReader b = new BufferedReader(fr);
            boolean eof = false;
            for (int j = 0; j < i; ++j) {
                if (eof) {
                    throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Line ").append(i).append(" is not found in the file ").append(this.file.getName()).append("."))));
                }
                b.readLine();
                if (line != null) continue;
                eof = true;
            }
            line = b.readLine();
            b.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unreadable : ").append(e.toString()))));
        }
        return line;
    }

    public void write(String text, boolean append) {
        if (this.file.exists()) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Warning : the file ").append(this.file.getName()).append(" already exists !"))));
        }
        try {
            FileWriter fw = new FileWriter(this.file, append);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(text);
            bw.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unwritable : ").append(e.toString()))));
        }
    }

    public static void main(String[] args) {
        File f = new File("read.txt");
        System.out.println(ASCIIFile.read(f));
        String[] lines = ASCIIFile.readLines(f);
        for (int i = 0; i < lines.length; ++i) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("line ").append(i).append(" : ").append(lines[i]))));
        }
        System.out.println(ASCIIFile.readLine(f, 0));
        System.out.println(ASCIIFile.readLine(f, lines.length - 1));
        ASCIIFile.append(new File("write.txt"), Calendar.getInstance().getTime().toString());
    }
}

