/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.io;

import java.util.Vector;
import org.jmat.data.AbstractDoubleArray;
import org.jmat.data.Matrix;

public class MatrixVector {
    public static Vector printMatrix(AbstractDoubleArray m) {
        Vector<Double> v = new Vector<Double>();
        if (m.getRowDimension() == 1) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                v.add(new Double(m.get(0, j)));
            }
        } else if (m.getColumnDimension() == 1) {
            for (int i = 0; i < m.getRowDimension(); ++i) {
                v.add(new Double(m.get(i, 0)));
            }
        } else {
            throw new IllegalArgumentException("Matrix must be a single row or a single column.");
        }
        return v;
    }

    public static Matrix readVector(Vector v) {
        Matrix X = new Matrix(v.size(), 1);
        for (int i = 0; i < v.size(); ++i) {
            if (!(v.get(i) instanceof Double)) {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Vector element at position ").append(i).append(" is not convertible into a double."))));
            }
            X.set(i, 0, (Double)v.get(i));
        }
        return X;
    }

    public static void main(String[] args) {
        Vector<Double> v = new Vector<Double>();
        for (int i = 0; i < 10; ++i) {
            v.add(new Double(i));
        }
        Matrix X = MatrixVector.readVector(v);
        X.toCommandLine("X");
    }
}

