/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plots;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.gui.FrameView;
import org.jmat.gui.Plot2DPanel;
import org.jmat.gui.Plot3DPanel;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plots.Plot;

public class ScatterPlot
extends Plot {
    public ScatterPlot(AbstractMatrix XY, Color c, String n, Base b) {
        super(XY, c, n, b);
    }

    public void plot(Graphics comp, Color c) {
        Graphics2D comp2D = (Graphics2D)comp;
        comp2D.setColor(c);
        for (int i = 0; i < this.datas.getRowDimension(); ++i) {
            this.drawDot(this.datas.toDoubleRowArray(i), comp2D);
        }
    }

    public void note(Graphics comp) {
        this.plot(comp, Color.black);
    }

    public static void main(String[] args) {
        Matrix X = (Matrix)Matrix.random(10, 2).divide(10000.0).ebeExp();
        new FrameView(new Plot2DPanel(X, "Scatter Plot 2D", "SCATTER"));
        new FrameView(new Plot3DPanel(Matrix.random(10, 3), "Scatter Plot 3D", "SCATTER"));
    }
}

