/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plotObjects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plotObjects.Coord;
import org.jmat.gui.plotObjects.Noteable;

public class RelativeCoord
extends Coord
implements Noteable {
    protected Base base;
    protected boolean isNoteable = true;

    public RelativeCoord(double[] pC, Base b) {
        this.base = b;
        this.plotCoord = pC;
        this.updateScreenCoord();
    }

    public static RelativeCoord barycenter(RelativeCoord A, double p1, Coord B, double p2) {
        double[] pC = new double[A.getPlotCoordCopy().length];
        for (int i = 0; i < A.getPlotCoordCopy().length; ++i) {
            pC[i] = (A.getPlotCoordCopy()[i] * p1 + B.getPlotCoordCopy()[i] * p2) / (p1 + p2);
        }
        return new RelativeCoord(pC, A.getBase());
    }

    public int[] getScreenCoordCopy() {
        this.updateScreenCoord();
        return super.getScreenCoordCopy();
    }

    public Base getBase() {
        return this.base;
    }

    public void setBase(Base b) {
        this.base = b;
    }

    public void setPlotCoord(double[] pC) {
        this.plotCoord = pC;
        this.updateScreenCoord();
    }

    public void setPlotCoord(double pCi, int i) {
        this.plotCoord[i] = pCi;
        this.updateScreenCoord();
    }

    public RelativeCoord projection(int dimension) {
        double[] pC = this.getPlotCoordCopy();
        pC[dimension] = this.base.getCoords()[0].getPlotCoordCopy()[dimension];
        return new RelativeCoord(pC, this.getBase());
    }

    public RelativeCoord addVector(double[] v) {
        double[] end = this.getPlotCoordCopy();
        for (int i = 0; i < end.length; ++i) {
            int n = i;
            end[n] = end[n] + v[i];
        }
        return new RelativeCoord(end, this.base);
    }

    public void addVectorEquals(double[] v) {
        for (int i = 0; i < v.length; ++i) {
            int n = i;
            this.plotCoord[n] = this.plotCoord[n] + v[i];
        }
        this.updateScreenCoord();
    }

    public void addVectorEquals(double vi, int i) {
        int n = i;
        this.plotCoord[n] = this.plotCoord[n] + vi;
        this.updateScreenCoord();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("(");
        for (int i = 0; i < this.plotCoord.length - 1; ++i) {
            String coordStr = new String("".concat(String.valueOf(String.valueOf(RelativeCoord.approx(this.getPlotCoordCopy()[i], RelativeCoord.getPower(this.base.getPrecisionUnit()[i]))))));
            s.append(coordStr).append(",");
        }
        String coordStr = new String("".concat(String.valueOf(String.valueOf(RelativeCoord.approx(this.getPlotCoordCopy()[this.plotCoord.length - 1], RelativeCoord.getPower(this.base.getPrecisionUnit()[this.plotCoord.length - 1]))))));
        s.append(coordStr).append(")");
        return s.toString();
    }

    public void setNotable(boolean b) {
        this.isNoteable = b;
    }

    public boolean tryNote(int[] sC) {
        return sC[0] > this.screenCoord[0] - 5 && sC[0] < this.screenCoord[0] + 5 && sC[1] > this.screenCoord[1] - 5 && sC[1] < this.screenCoord[1] + 5;
    }

    public boolean tryNote(int[] sC, Graphics comp) {
        if (this.isNoteable && this.tryNote(sC)) {
            this.note(comp);
            return true;
        }
        return false;
    }

    public void note(Graphics comp) {
        Graphics2D comp2D = (Graphics2D)comp;
        comp2D.setColor(Color.black);
        comp2D.drawString(this.toString(), this.screenCoord[0], this.screenCoord[1]);
        for (int i = 0; i < this.base.getCoords().length - 1; ++i) {
            RelativeCoord p = this.projection(i);
            comp2D.drawLine(this.getScreenCoordCopy()[0], this.getScreenCoordCopy()[1], ((Coord)p).getScreenCoordCopy()[0], ((Coord)p).getScreenCoordCopy()[1]);
        }
    }

    private void updateScreenCoord() {
        this.screenCoord = this.base.screenProjection(this.plotCoord);
    }

    private static int getPower(double precisionUnit) {
        return -((int)(Math.log(precisionUnit / (double)10000) / Math.log(10.0)));
    }

    public static double approx(double val, int decimal) {
        if (decimal < 0) {
            return Math.rint(val / Math.pow(10.0, -decimal)) * Math.pow(10.0, -decimal);
        }
        return Math.rint(val * Math.pow(10.0, decimal)) / Math.pow(10.0, decimal);
    }

    public void checkSameRelativesBases(RelativeCoord B) {
        if (this.base != B.base) {
            throw new IllegalArgumentException("Using two Coordinates, their bases must be the same");
        }
    }
}

