/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plotObjects;

import java.awt.Color;
import org.jmat.data.Matrix;
import org.jmat.gui.FrameView;
import org.jmat.gui.Plot3DPanel;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plotObjects.BaseScalesDependant;
import org.jmat.gui.plotObjects.Coord;
import org.jmat.gui.plotObjects.Label;
import org.jmat.gui.plotObjects.RelativeCoord;

public class BaseLabel
extends Label
implements BaseScalesDependant {
    private double[] positionOnAxes;
    private Base base;

    public BaseLabel(String l, Base b, double[] pOA, Color c) {
        super(l, BaseLabel.buildRelativeCoord(pOA, b), c);
        this.positionOnAxes = pOA;
        this.base = b;
    }

    public static RelativeCoord buildRelativeCoord(double[] pOA, Base base) {
        Coord origin = base.getCoords()[0];
        int nbDim = base.dimension;
        double[] plotCoord = new double[base.dimension];
        for (int i = 0; i < nbDim; ++i) {
            if (base.getAxeScale(i) == 0) {
                plotCoord[i] = origin.getPlotCoordCopy()[i] + (base.getCoords()[i + 1].getPlotCoordCopy()[i] - origin.getPlotCoordCopy()[i]) * pOA[i];
                continue;
            }
            if (base.getAxeScale(i) != 1) continue;
            int numPow10 = (int)Math.rint(Math.log(base.getMaxBounds()[i] / base.getMinBounds()[i]) / Math.log(10.0));
            plotCoord[i] = origin.getPlotCoordCopy()[i] * Math.pow(10.0, (double)numPow10 * pOA[i]);
        }
        return new RelativeCoord(plotCoord, base);
    }

    public void updateBase() {
        this.coord = BaseLabel.buildRelativeCoord(this.positionOnAxes, this.base);
    }

    public static void main(String[] args) {
        Plot3DPanel p3d = new Plot3DPanel(new double[]{0.0, 0.0, 0.0}, new double[]{10.0, 10.0, 10.0}, new int[3], new String[]{"x", "y", "z"});
        new FrameView(p3d);
        p3d.addPlot(Matrix.random(10, 3), "plot", "SCATTER");
        p3d.addPlotable(new BaseLabel("label", p3d.getBase(), new double[]{-0.1, 0.5, 0.5}, Color.RED));
    }
}

