/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plotObjects;

import org.jmat.gui.plotObjects.AbsoluteCoord;
import org.jmat.gui.plotObjects.Coord;
import org.jmat.gui.plotObjects.RelativeCoord;
import org.jmat.io.CommandLinePrintable;

public abstract class Base
implements CommandLinePrintable {
    public static final int LINEAR = 0;
    public static final int LOG = 1;
    public static double DEFAULT_BORDER;
    protected Coord[] baseCoords;
    protected double[] precisionUnit;
    protected double[] Xmin;
    protected double[] Xmax;
    protected int[] panelSize;
    protected int dimension;
    protected double borderCoeff;
    protected int[] axesScales;

    public Base(Coord[] b) {
        this.baseCoords = b;
    }

    public Base(double[] Xmi, double[] Xma, int[] dim, int[] scales, double bC) {
        this.dimension = Xmi.length;
        this.axesScales = scales;
        this.panelSize = dim;
        this.borderCoeff = bC;
        this.initBounds(Xmi.length);
        this.setnRoundBounds(Xmi, Xma);
        this.setBaseCoords();
    }

    public void setPanelSize(int[] dim) {
        this.panelSize = dim;
    }

    public void setAxesScales(int[] scales) {
        this.axesScales = scales;
        this.setnRoundBounds(this.Xmin, this.Xmax);
        this.setBaseCoords();
    }

    public void setAxesScales(int i, int scale) {
        this.axesScales[i] = scale;
        this.setnRoundBounds(this.Xmin, this.Xmax);
        this.setBaseCoords();
    }

    private void setPrecisionUnit(int i, double Xmi, double Xma) {
        this.precisionUnit[i] = Xma - Xmi > 0.0 ? Math.pow(10.0, Math.rint(Math.log(Xma - Xmi) / Math.log(10.0))) : 1.0;
    }

    public double getBorder() {
        return this.borderCoeff;
    }

    public Coord[] getCoords() {
        return this.baseCoords;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int[] getAxesScales() {
        return this.axesScales;
    }

    public int getAxeScale(int i) {
        return this.axesScales[i];
    }

    public double[] getMinBounds() {
        return this.Xmin;
    }

    public double[] getMaxBounds() {
        return this.Xmax;
    }

    public double[] getPrecisionUnit() {
        return this.precisionUnit;
    }

    private void initBounds(int i) {
        this.Xmin = new double[i];
        this.Xmax = new double[i];
    }

    private void setBounds(int i, double Xmi, double Xma) {
        if (Xmi < 0.0 && this.axesScales[i] == 1) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Error while bounding dimension ").append(i + 1).append(" : bounds [").append(Xmi).append(",").append(Xma).append("] are incompatible with Logarithm scale."))));
        }
        if (Xmi == Xma) {
            Xmi = Xma - 1.0;
        }
        if (Xmi > Xma) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Error while bounding dimension ").append(i + 1).append(" : min ").append(Xmi).append(" must be < to max ").append(Xma))));
        }
        this.Xmin[i] = Xmi;
        this.Xmax[i] = Xma;
    }

    private void setBounds(double[] Xmi, double[] Xma) {
        for (int i = 0; i < Xmi.length; ++i) {
            this.setBounds(i, Xmi[i], Xma[i]);
        }
    }

    public void setFixedBounds(int i, double Xmi, double Xma) {
        this.setPrecisionUnit(i, Xmi, Xma);
        this.setBounds(i, Xmi, Xma);
    }

    public void setFixedBounds(double[] Xmi, double[] Xma) {
        for (int i = 0; i < Xmi.length; ++i) {
            this.setFixedBounds(i, Xmi[i], Xma[i]);
        }
    }

    public void setnRoundBounds(int i, double Xmi, double Xma) {
        this.setPrecisionUnit(i, Xmi, Xma);
        if (this.axesScales[i] == 1) {
            this.setBounds(i, Math.pow(10.0, Math.floor(Math.log(Xmi) / Math.log(10.0))), Math.pow(10.0, Math.ceil(Math.log(Xma) / Math.log(10.0))));
        } else if (this.axesScales[i] == 0) {
            this.setBounds(i, this.precisionUnit[i] * Math.floor(Xmi / this.precisionUnit[i]), this.precisionUnit[i] * Math.ceil(Xma / this.precisionUnit[i]));
        }
    }

    public void setnRoundBounds(double[] Xmi, double[] Xma) {
        this.precisionUnit = new double[Xmi.length];
        for (int i = 0; i < Xmi.length; ++i) {
            this.setnRoundBounds(i, Xmi[i], Xma[i]);
        }
    }

    public void includeInBounds(int dim, double XY) {
        double[] Xmi = new double[this.Xmin.length];
        for (int i = 0; i < this.Xmin.length; ++i) {
            Xmi[i] = i == dim ? Math.min(XY, this.Xmin[i]) : this.Xmin[i];
        }
        double[] Xma = new double[this.Xmax.length];
        for (int i = 0; i < this.Xmax.length; ++i) {
            Xma[i] = i == dim ? Math.max(XY, this.Xmax[i]) : this.Xmax[i];
        }
        this.setnRoundBounds(Xmi, Xma);
        this.setBaseCoords();
    }

    public void includeInBounds(double[] XY) {
        double[] Xmi = new double[this.Xmin.length];
        for (int i = 0; i < this.Xmin.length; ++i) {
            Xmi[i] = Math.min(XY[i], this.Xmin[i]);
        }
        double[] Xma = new double[this.Xmax.length];
        for (int i = 0; i < this.Xmax.length; ++i) {
            Xma[i] = Math.max(XY[i], this.Xmax[i]);
        }
        this.setnRoundBounds(Xmi, Xma);
        this.setBaseCoords();
    }

    public void translate(int[] screenTranslation) {
        for (int i = 0; i < this.baseCoords.length; ++i) {
            this.baseCoords[i].setScreenCoord(new int[]{this.baseCoords[i].getScreenCoordCopy()[0] + screenTranslation[0], this.baseCoords[i].getScreenCoordCopy()[1] + screenTranslation[1]});
        }
    }

    public void dilate(int[] screenOrigin, double[] screenRatio) {
        for (int i = 0; i < this.baseCoords.length; ++i) {
            this.baseCoords[i].setScreenCoord(new int[]{(int)((double)(this.baseCoords[i].getScreenCoordCopy()[0] - screenOrigin[0]) / screenRatio[0]), (int)((double)(this.baseCoords[i].getScreenCoordCopy()[1] - screenOrigin[1]) / screenRatio[1])});
        }
    }

    public void updateScreenCoord() {
        for (int i = 0; i < this.baseCoords.length; ++i) {
            double[] ratio = this.baseCoordsScreenProjectionRatio(this.baseCoords[i].getPlotCoordCopy());
            int[] sC = new int[]{(int)((double)this.panelSize[0] * (this.borderCoeff + (1.0 - (double)2 * this.borderCoeff) * ratio[0])), (int)((double)this.panelSize[1] - (double)this.panelSize[1] * (this.borderCoeff + (1.0 - (double)2 * this.borderCoeff) * ratio[1]))};
            this.baseCoords[i] = new AbsoluteCoord(this.baseCoords[i].getPlotCoordCopy(), sC);
        }
    }

    public void setBaseCoords() {
        this.baseCoords = new AbsoluteCoord[this.Xmin.length + 1];
        for (int i = 0; i < this.Xmin.length + 1; ++i) {
            double[] pC = (double[])this.Xmin.clone();
            if (i > 0) {
                pC[i - 1] = this.Xmax[i - 1];
            }
            double[] ratio = this.baseCoordsScreenProjectionRatio(pC);
            int[] sC = new int[]{(int)((double)this.panelSize[0] * (this.borderCoeff + (1.0 - (double)2 * this.borderCoeff) * ratio[0])), (int)((double)this.panelSize[1] - (double)this.panelSize[1] * (this.borderCoeff + (1.0 - (double)2 * this.borderCoeff) * ratio[1]))};
            this.baseCoords[i] = new AbsoluteCoord(pC, sC);
        }
    }

    public int[] screenProjection(double[] pC) {
        double[] sC = new double[]{this.baseCoords[0].getScreenCoordCopy()[0], this.baseCoords[0].getScreenCoordCopy()[1]};
        for (int i = 0; i < this.baseCoords[0].getPlotCoordCopy().length; ++i) {
            if (this.axesScales[i] == 1) {
                sC[0] = sC[0] + (Math.log(pC[i]) - Math.log(this.baseCoords[0].getPlotCoordCopy()[i])) / (Math.log(this.baseCoords[i + 1].getPlotCoordCopy()[i]) - Math.log(this.baseCoords[0].getPlotCoordCopy()[i])) * (double)(this.baseCoords[i + 1].getScreenCoordCopy()[0] - this.baseCoords[0].getScreenCoordCopy()[0]);
                sC[1] = sC[1] + (Math.log(pC[i]) - Math.log(this.baseCoords[0].getPlotCoordCopy()[i])) / (Math.log(this.baseCoords[i + 1].getPlotCoordCopy()[i]) - Math.log(this.baseCoords[0].getPlotCoordCopy()[i])) * (double)(this.baseCoords[i + 1].getScreenCoordCopy()[1] - this.baseCoords[0].getScreenCoordCopy()[1]);
                continue;
            }
            if (this.axesScales[i] != 0) continue;
            sC[0] = sC[0] + (pC[i] - this.baseCoords[0].getPlotCoordCopy()[i]) / (this.baseCoords[i + 1].getPlotCoordCopy()[i] - this.baseCoords[0].getPlotCoordCopy()[i]) * (double)(this.baseCoords[i + 1].getScreenCoordCopy()[0] - this.baseCoords[0].getScreenCoordCopy()[0]);
            sC[1] = sC[1] + (pC[i] - this.baseCoords[0].getPlotCoordCopy()[i]) / (this.baseCoords[i + 1].getPlotCoordCopy()[i] - this.baseCoords[0].getPlotCoordCopy()[i]) * (double)(this.baseCoords[i + 1].getScreenCoordCopy()[1] - this.baseCoords[0].getScreenCoordCopy()[1]);
        }
        return new int[]{(int)sC[0], (int)sC[1]};
    }

    protected abstract double[] baseCoordsScreenProjectionRatio(double[] var1);

    public RelativeCoord getGravCenter() {
        double[] g = this.baseCoords[0].getPlotCoordCopy();
        for (int i = 0; i < this.baseCoords.length - 1; ++i) {
            g[i] = g[i] + this.baseCoords[i].getPlotCoordCopy()[i] / (double)2;
        }
        return new RelativeCoord(g, this);
    }

    public boolean authorizedLogScale(int i) {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Xmin[").append(i).append("] = ").append(this.Xmin[i]))));
        return this.Xmin[i] > 0.0;
    }

    public void toCommandLine(String title) {
        System.out.println(String.valueOf(String.valueOf(title)).concat(" : "));
        for (int i = 0; i < this.baseCoords.length; ++i) {
            this.baseCoords[i].toCommandLine("point ".concat(String.valueOf(String.valueOf(i))));
        }
    }

    static {
        LINEAR = 0;
        LOG = 1;
        DEFAULT_BORDER = 0.15;
    }
}

