/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plotObjects;

import org.jmat.gui.plotObjects.Coord;

public class AbsoluteCoord
extends Coord {
    public AbsoluteCoord(double[] pC, int[] sC) {
        this.plotCoord = pC;
        this.screenCoord = sC;
        if (sC.length != 2) {
            throw new IllegalArgumentException("Screen coordinates must be in 2D!");
        }
    }

    public static AbsoluteCoord barycenter(Coord A, double p1, Coord B, double p2) {
        double[] plotCoord = new double[A.getPlotCoordCopy().length];
        for (int i = 0; i < A.getPlotCoordCopy().length; ++i) {
            plotCoord[i] = (A.getPlotCoordCopy()[i] * p1 + B.getPlotCoordCopy()[i] * p2) / (p1 + p2);
        }
        int[] screenCoord = new int[]{(int)(((double)A.getScreenCoordCopy()[0] * p1 + (double)B.getScreenCoordCopy()[0] * p2) / (p1 + p2)), (int)(((double)A.getScreenCoordCopy()[1] * p1 + (double)B.getScreenCoordCopy()[1] * p2) / (p1 + p2))};
        return new AbsoluteCoord(plotCoord, screenCoord);
    }
}

