/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jmat.data.AbstractMatrix;
import org.jmat.gui.components.DatasFrame;
import org.jmat.gui.components.PlotToolBar;
import org.jmat.gui.components.SetScalesFrame;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plotObjects.BaseLabel;
import org.jmat.gui.plotObjects.BaseScalesDependant;
import org.jmat.gui.plotObjects.Coord;
import org.jmat.gui.plotObjects.Grid;
import org.jmat.gui.plotObjects.Label;
import org.jmat.gui.plotObjects.Plotable;
import org.jmat.gui.plotObjects.RelativeCoord;
import org.jmat.gui.plots.Plot;

public abstract class PlotPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ComponentListener,
BaseScalesDependant {
    public static final int ZOOM = 0;
    public static final int TRANSLATION = 1;
    public static final int LINEAR = 0;
    public static final int LOG = 1;
    public static final String SCATTER = "SCATTER";
    public static final String LINE = "LINE";
    public static final String BAR = "BAR";
    public static final String HISTOGRAM = "HISTOGRAM";
    public static final String BOX = "BOX";
    public static final String STAIRCASE = "STAIRCASE";
    public static Color[] colorList;
    private static final RenderingHints AALIAS;
    public static int[] panelSize;
    protected Base base;
    protected Grid grid;
    protected Vector plots;
    protected Vector objects;
    public int ActionMode = 0;
    protected int[] mouseCurent = new int[2];
    protected int[] mouseClick = new int[2];
    public PlotToolBar toolBar;

    public PlotPanel() {
        this.setLayout(new BorderLayout());
        this.initToolBar();
        this.initPanel();
        this.initBasenGrid();
    }

    public PlotPanel(double[] min, double[] max) {
        this.setLayout(new BorderLayout());
        this.initToolBar();
        this.initPanel();
        this.initBasenGrid(min, max);
    }

    public PlotPanel(double[] min, double[] max, int[] axesScales, String[] axesLabels) {
        this.setLayout(new BorderLayout());
        this.initToolBar();
        this.initPanel();
        this.initBasenGrid(min, max, axesScales, axesLabels);
    }

    private void initToolBar() {
        this.toolBar = new PlotToolBar(this);
        this.add((Component)this.toolBar, "North");
        this.toolBar.setFloatable(false);
    }

    private void initPanel() {
        this.objects = new Vector();
        this.plots = new Vector();
        this.setSize(panelSize[0], panelSize[1]);
        this.setPreferredSize(new Dimension(panelSize[0], panelSize[1]));
        this.setBackground(Color.white);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setActionMode(int am) {
        this.ActionMode = am;
    }

    public void setNoteCoords(boolean b) {
        if (b) {
            for (int i = 0; i < this.plots.size(); ++i) {
                ((Plot)this.plots.get(i)).setNoteEachCoord(true);
            }
        } else {
            for (int i = 0; i < this.plots.size(); ++i) {
                ((Plot)this.plots.get(i)).setNoteEachCoord(false);
            }
        }
    }

    public abstract void initBasenGrid(double[] var1, double[] var2, int[] var3, String[] var4);

    public abstract void initBasenGrid(double[] var1, double[] var2);

    public abstract void initBasenGrid();

    public void resetBase() {
        this.base.setBaseCoords();
        this.repaint();
    }

    public Base getBase() {
        return this.base;
    }

    public Plot[] getPlots() {
        Object[] plotarray = new Plot[this.plots.size()];
        this.plots.copyInto(plotarray);
        return plotarray;
    }

    public Plot getPlot(int i) {
        return (Plot)this.plots.get(i);
    }

    public Plotable[] getObjects() {
        Object[] plotablearray = new Plotable[this.objects.size()];
        this.objects.copyInto(plotablearray);
        return plotablearray;
    }

    public Plotable getObject(int i) {
        return (Plotable)this.objects.get(i);
    }

    public Grid getGrid() {
        return this.grid;
    }

    public int[] getAxesScales() {
        return this.base.getAxesScales();
    }

    public void setAxesLabels(String[] labels) {
        this.grid.setLegend(labels);
        this.repaint();
    }

    public void setAxeLabel(int axe, String label) {
        this.grid.setLegend(axe, label);
        this.repaint();
    }

    public void setAxesScales(int[] scales) {
        this.base.setAxesScales(scales);
        this.setAutoBounds();
    }

    public void setAxeScale(int axe, int scale) {
        this.base.setAxesScales(axe, scale);
        this.setAutoBounds(axe);
    }

    public void setFixedBounds(double[] min, double[] max) {
        this.base.setFixedBounds(min, max);
        this.updateBase();
        this.repaint();
    }

    public void setFixedBounds(int axe, double min, double max) {
        this.base.setFixedBounds(axe, min, max);
        this.updateBase();
        this.repaint();
    }

    public void setAutoBounds() {
        if (this.plots.size() > 0) {
            Plot plot0 = this.getPlot(0);
            this.base.setnRoundBounds(plot0.getDatas().min().toDoubleArray(), plot0.getDatas().max().toDoubleArray());
        } else {
            double[] min = new double[this.base.getDimension()];
            double[] max = new double[this.base.getDimension()];
            for (int i = 0; i < this.base.getDimension(); ++i) {
                if (this.base.getAxeScale(i) == 0) {
                    min[i] = 0.0;
                    max[i] = 1.0;
                    continue;
                }
                if (this.base.getAxeScale(i) != 1) continue;
                min[i] = 1.0;
                max[i] = 10.0;
            }
            this.base.setnRoundBounds(min, max);
        }
        for (int i = 1; i < this.plots.size(); ++i) {
            Plot ploti = this.getPlot(i);
            this.base.includeInBounds(ploti.getDatas().min().toDoubleArray());
            this.base.includeInBounds(ploti.getDatas().max().toDoubleArray());
        }
        this.updateBase();
        this.repaint();
    }

    public void setAutoBounds(int axe) {
        if (this.plots.size() > 0) {
            Plot plot0 = this.getPlot(0);
            this.base.setnRoundBounds(axe, plot0.getDatas().min().get(0, axe), plot0.getDatas().max().get(0, axe));
        } else {
            double min = 0.0;
            double max = 0.0;
            if (this.base.getAxeScale(axe) == 0) {
                min = 0.0;
                max = 1.0;
            } else if (this.base.getAxeScale(axe) == 1) {
                min = 1.0;
                max = 10.0;
            }
            this.base.setnRoundBounds(axe, min, max);
        }
        for (int i = 1; i < this.plots.size(); ++i) {
            Plot ploti = this.getPlot(i);
            this.base.includeInBounds(axe, ploti.getDatas().min().get(0, axe));
            this.base.includeInBounds(axe, ploti.getDatas().max().get(0, axe));
        }
        this.updateBase();
        this.repaint();
    }

    public void updateBase() {
        this.base.setBaseCoords();
        this.grid.updateBase();
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof BaseScalesDependant)) continue;
            ((BaseScalesDependant)this.objects.get(i)).updateBase();
        }
    }

    public void addLabel(String text, double[] where, Color c) {
        this.addLabel(text, new RelativeCoord(where, this.base), c);
    }

    public void addLabel(String text, Coord where, Color c) {
        this.addPlotable(new Label(text, where, c));
    }

    public void addBaseLabel(String text, double[] where, Color c) {
        this.addPlotable(new BaseLabel(text, this.base, where, c));
    }

    public void addPlotable(Plotable p) {
        this.objects.add(p);
        this.repaint();
    }

    public void removePlotable(Plotable p) {
        this.objects.remove(p);
        this.repaint();
    }

    public void removePlotable(int i) {
        this.objects.remove(i);
        this.repaint();
    }

    public void addPlot(Plot newPlot) {
        this.plots.add(newPlot);
        this.setAutoBounds();
    }

    public void addPlot(AbstractMatrix XY, String name, String type) {
        this.addPlot(XY, name, type, colorList[this.plots.size() % colorList.length]);
    }

    public abstract void addPlot(AbstractMatrix var1, String var2, String var3, Color var4);

    public void removePlot(int I) {
        this.plots.remove(I);
        if (this.plots.size() == 0) {
            this.initBasenGrid();
        } else {
            this.setAutoBounds();
        }
    }

    public void removePlot(Plot p) {
        this.plots.remove(p);
        if (this.plots.size() == 0) {
            this.initBasenGrid();
        } else {
            this.setAutoBounds();
        }
    }

    public void removeAllPlots() {
        this.plots.removeAllElements();
        this.initBasenGrid();
    }

    public void toGraphicFile(File file) {
        this.toolBar.setVisible(false);
        this.repaint();
        Image image = this.createImage(this.getWidth(), this.getHeight());
        this.paint(image.getGraphics());
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, Color.WHITE, null);
        g.dispose();
        this.toolBar.setVisible(true);
        this.repaint();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (IOException e) {
            JOptionPane.showConfirmDialog(null, "Save failed : ".concat(String.valueOf(String.valueOf(e.getMessage()))), "Error", -1, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void displaySetScalesFrame() {
        new SetScalesFrame(this);
    }

    public void displayDatasFrame() {
        new DatasFrame(this);
    }

    public void paint(Graphics comp) {
        int i;
        Graphics2D comp2D = (Graphics2D)comp;
        comp2D.addRenderingHints(AALIAS);
        comp2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        comp2D.setColor(this.getBackground());
        comp2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.grid.plot(comp);
        for (i = 0; i < this.objects.size(); ++i) {
            this.getObject(i).plot(comp);
        }
        for (i = 0; i < this.plots.size(); ++i) {
            this.getPlot(i).plot(comp);
            this.getPlot(i).tryNote(this.mouseCurent, comp);
        }
        switch (this.ActionMode) {
            case 0: {
                comp2D.setColor(Color.black);
                comp2D.drawRect(Math.min(this.mouseClick[0], this.mouseCurent[0]), Math.min(this.mouseClick[1], this.mouseCurent[1]), Math.abs(this.mouseCurent[0] - this.mouseClick[0]), Math.abs(this.mouseCurent[1] - this.mouseClick[1]));
            }
        }
        this.setBackground(Color.white);
        if (this.toolBar.isVisible()) {
            this.toolBar.update(comp);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        switch (this.ActionMode) {
            case 1: {
                int[] t = new int[]{this.mouseCurent[0] - this.mouseClick[0], this.mouseCurent[1] - this.mouseClick[1]};
                this.base.translate(t);
                this.mouseClick[0] = this.mouseCurent[0];
                this.mouseClick[1] = this.mouseCurent[1];
            }
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        this.mouseClick[0] = e.getX();
        this.mouseClick[1] = e.getY();
        e.consume();
    }

    public void mouseClicked(MouseEvent e) {
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        this.mouseClick[0] = this.mouseCurent[0];
        this.mouseClick[1] = this.mouseCurent[1];
        switch (this.ActionMode) {
            case 0: {
                double[] ratio;
                int[] origin;
                if (e.getModifiers() == 16) {
                    origin = new int[]{this.mouseCurent[0] - panelSize[0] / 4, this.mouseCurent[1] - panelSize[1] / 4};
                    ratio = new double[]{0.5, 0.5};
                } else {
                    origin = new int[]{this.mouseCurent[0] - panelSize[0], this.mouseCurent[1] - panelSize[1]};
                    ratio = new double[]{2.0, 2.0};
                }
                this.base.dilate(origin, ratio);
            }
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        switch (this.ActionMode) {
            case 0: {
                if (e.getModifiers() != 16 || this.mouseCurent[0] == this.mouseClick[0] || this.mouseCurent[1] == this.mouseClick[1]) break;
                int[] origin = new int[]{Math.min(this.mouseClick[0], this.mouseCurent[0]), Math.min(this.mouseClick[1], this.mouseCurent[1])};
                double[] ratio = new double[]{Math.abs((double)(this.mouseCurent[0] - this.mouseClick[0]) / (double)panelSize[0]), Math.abs((double)(this.mouseCurent[1] - this.mouseClick[1]) / (double)panelSize[1])};
                this.base.dilate(origin, ratio);
            }
        }
        this.mouseClick[0] = this.mouseCurent[0];
        this.mouseClick[1] = this.mouseCurent[1];
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        this.mouseClick[0] = this.mouseCurent[0];
        this.mouseClick[1] = this.mouseCurent[1];
        this.repaint();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        panelSize = new int[]{(int)this.getSize().getWidth(), (int)this.getSize().getHeight()};
        this.base.setPanelSize(panelSize);
        this.base.updateScreenCoord();
        this.repaint();
    }

    public void componentShown(ComponentEvent e) {
    }

    static {
        ZOOM = 0;
        TRANSLATION = 1;
        LINEAR = 0;
        LOG = 1;
        SCATTER = SCATTER;
        LINE = LINE;
        BAR = BAR;
        HISTOGRAM = HISTOGRAM;
        BOX = BOX;
        STAIRCASE = STAIRCASE;
        colorList = new Color[]{Color.blue, Color.red, Color.green, Color.yellow, Color.orange, Color.pink, Color.cyan, Color.magenta};
        AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        panelSize = new int[]{400, 400};
    }
}

