/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui;

import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.gui.DataPanel;
import org.jmat.gui.FrameView;

public class MatrixTablePanel
extends DataPanel {
    private JTable table;
    private TableModel model;
    private AbstractMatrix M;
    private boolean viewHeaders = false;
    private String[] headers;

    public MatrixTablePanel(AbstractMatrix m) {
        this.M = m;
        this.headers = new String[this.M.getColumnDimension()];
        this.setModel();
        this.toWindow();
    }

    public MatrixTablePanel(double[][] d) {
        this(new Matrix(d));
    }

    public void toClipBoard() {
        try {
            this.M.toClipBoard();
        }
        catch (IllegalStateException e) {
            JOptionPane.showConfirmDialog(null, "Copy to clipboard failed : ".concat(String.valueOf(String.valueOf(e.getMessage()))), "Error", -1, 0);
        }
    }

    public String toString() {
        return this.M.toString();
    }

    public void toASCIIFile(File file) {
        try {
            this.M.toASCIIFile(file);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void setModel() {
        Object[][] array = new Double[this.M.getRowDimension()][this.M.getColumnDimension()];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                array[i][j] = new Double(this.M.get(i, j));
            }
        }
        this.model = new DefaultTableModel(array, this.headers);
    }

    public void setHeaders(String[] h) {
        if (h.length != this.M.getColumnDimension()) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Headers of the table must have ").append(this.M.getColumnDimension()).append(" elements."))));
        }
        this.headers = h;
        this.update();
    }

    public void update() {
        this.setModel();
        super.update();
    }

    public void setMatrix(Matrix m) {
        this.M = m;
        this.headers = new String[this.M.getColumnDimension()];
        this.update();
    }

    protected void toWindow() {
        this.table = new JTable(this.model);
        if (!this.viewHeaders) {
            this.table.setTableHeader(null);
        }
        this.table.setAutoResizeMode(4);
        this.table.setCellSelectionEnabled(true);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(this.getSize());
        this.scrollPane.setSize(this.getSize());
        this.add((Component)this.scrollPane, "Center");
    }

    public AbstractMatrix getMarix() {
        return this.M;
    }

    public static void main(String[] args) {
        MatrixTablePanel mt = new MatrixTablePanel(Matrix.random(20, 3));
        FrameView fv = new FrameView(mt);
        mt.setMatrix(Matrix.random(40, 4));
    }
}

