/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.function;

import org.jmat.data.AbstractDoubleArray;
import org.jmat.data.Matrix;
import org.jmat.function.MatrixFunction;
import org.jmat.function.expressionParser.Evaluator;

public class MatrixFunctionExpression
extends MatrixFunction {
    private String expression;
    private String[] variables;
    private Evaluator ME = new Evaluator();

    public MatrixFunctionExpression(String exp, String[] vars) {
        this.argNumber = vars.length;
        this.setFunction(exp, vars);
    }

    public MatrixFunctionExpression(String exp, String vars) {
        this.argNumber = 1;
        String[] variable = new String[]{vars};
        this.setFunction(exp, variable);
    }

    private void setFunction(String exp, String[] vars) {
        this.expression = exp;
        this.variables = vars;
    }

    private void setVariableValues(AbstractDoubleArray[] values) {
        for (int i = 0; i < this.variables.length; ++i) {
            this.ME.addVariable(this.variables[i], values[i]);
        }
        this.ME.setExpression(this.expression);
    }

    private void setVariableValues(AbstractDoubleArray value) {
        this.ME.addVariable(this.variables[0], value);
        this.ME.setExpression(this.expression);
    }

    public Matrix eval(AbstractDoubleArray[] values) {
        this.checkArgNumber(values.length);
        this.setVariableValues(values);
        return (Matrix)this.ME.getValue();
    }

    public Matrix eval(AbstractDoubleArray value) {
        this.checkArgNumber(1);
        this.setVariableValues(value);
        return (Matrix)this.ME.getValue();
    }

    public String toString() {
        String s = new String("y(".concat(String.valueOf(String.valueOf(this.variables[0]))));
        for (int i = 1; i < this.variables.length; ++i) {
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(this.variables[i]))))));
        }
        s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(") = ".concat(String.valueOf(String.valueOf(this.expression))))));
        return s;
    }

    public void toCommandLine(String title) {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Function ").append(title).append(" ").append(this.toString()))));
    }
}

