/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.data.matrixTools;

import java.util.Vector;
import org.jmat.data.AbstractDoubleArray;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.data.matrixTools.Sorting;

public class Slicing {
    public static final String AUTO_BOUNDS = "AUTO";
    public static final String UNIFORM_BOUNDS = "UNIFORM";
    public static double epsilon;
    private AbstractMatrix M;
    private Slice[] slice;

    public Slicing(AbstractMatrix m, int[] n, String bounds) {
        m.checkColumnDimension(n.length);
        this.M = m;
        if (bounds == UNIFORM_BOUNDS) {
            this.setSlicesUniformBounds(n);
        } else if (bounds == AUTO_BOUNDS) {
            this.setSlicesAutoBounds(n);
        } else {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("The bounds type : ").append(bounds).append("is unknown. You must specify AUTO or UNIFORM."))));
        }
    }

    public Slicing(AbstractMatrix m, AbstractMatrix[] bounds) {
        m.checkColumnDimension(bounds.length);
        this.M = m;
        for (int i = 0; i < bounds.length; ++i) {
            bounds[i].checkColumnDimension(1);
        }
        this.setSlicesBounds(bounds);
    }

    public Slicing(AbstractMatrix m, AbstractMatrix[] centers, AbstractMatrix[] widths) {
        m.checkColumnDimension(centers.length);
        if (centers.length != widths.length) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Slices centers = ").append(centers.length).append(" != Slices widths = ").append(widths.length))));
        }
        this.M = m;
        for (int i = 0; i < centers.length; ++i) {
            centers[i].checkColumnDimension(1);
            widths[i].checkColumnDimension(1);
        }
        this.setSlicesCentersnWidths(centers, widths);
    }

    public Slicing(AbstractMatrix m, int[][] n) {
        this.M = m;
        this.setSlices(n);
    }

    public static AbstractMatrix UniformBounds(AbstractMatrix pop, int[] n) {
        Slicing s = new Slicing(pop, n, UNIFORM_BOUNDS);
        return s.getSlicingMatrix();
    }

    public static AbstractMatrix AutoBounds(AbstractMatrix pop, int[] n) {
        Slicing s = new Slicing(pop, n, AUTO_BOUNDS);
        return s.getSlicingMatrix();
    }

    public static AbstractMatrix DefinedBounds(AbstractMatrix pop, AbstractMatrix[] bounds) {
        Slicing s = new Slicing(pop, bounds);
        return s.getSlicingMatrix();
    }

    public static AbstractMatrix DefinedCentersnWidths(AbstractMatrix pop, AbstractMatrix[] centers, AbstractMatrix[] widths) {
        Slicing s = new Slicing(pop, centers, widths);
        return s.getSlicingMatrix();
    }

    public static AbstractMatrix DefinedGroups(AbstractMatrix pop, int[][] bounds) {
        Slicing s = new Slicing(pop, bounds);
        return s.getSlicingMatrix();
    }

    public AbstractMatrix getSlicingMatrix() {
        AbstractMatrix X = this.getSlicesCenters();
        X.mergeColumnsEquals(this.getSlicesCardinals());
        X.mergeColumnsEquals(this.getSlicesWidths());
        return X;
    }

    public AbstractMatrix getSlicesCardinals() {
        Matrix cards = new Matrix(this.slice.length, 1);
        for (int i = 0; i < this.slice.length; ++i) {
            ((AbstractDoubleArray)cards).set(i, 0, this.slice[i].cardinal);
        }
        return cards;
    }

    public AbstractMatrix getSlicesWidths() {
        Matrix w = new Matrix(this.slice.length, this.M.getColumnDimension());
        for (int i = 0; i < this.slice.length; ++i) {
            w.setRow(i, this.slice[i].width);
        }
        return w;
    }

    public AbstractMatrix getSlicesCenters() {
        Matrix c = new Matrix(this.slice.length, this.M.getColumnDimension());
        for (int i = 0; i < this.slice.length; ++i) {
            c.setRow(i, this.slice[i].center);
        }
        return c;
    }

    public int findSlice(Matrix x) {
        int s = -1;
        for (int i = 0; i < this.slice.length; ++i) {
            if (!this.slice[i].isIn(x)) continue;
            s = i;
        }
        return s;
    }

    public int[][] getSlices() {
        int[][] s = new int[this.slice.length][0];
        for (int i = 0; i < this.slice.length; ++i) {
            s[i] = this.slice[i].getIndexesArray();
        }
        return s;
    }

    private void setSlicesBounds(AbstractMatrix[] bounds) {
        int numDim = this.M.getColumnDimension();
        int[] numberSlicesPerDimension = new int[numDim];
        for (int i = 0; i < numberSlicesPerDimension.length; ++i) {
            numberSlicesPerDimension[i] = bounds[i].getRowDimension() - 1;
        }
        this.slice = new Slice[Slicing.cumProd(numberSlicesPerDimension)];
        int[] counter = new int[numberSlicesPerDimension.length];
        Matrix sliceWidth = new Matrix(1, this.M.getColumnDimension());
        Matrix sliceCenter = new Matrix(1, this.M.getColumnDimension());
        for (int i = 0; i < this.slice.length; ++i) {
            for (int j = 0; j < numDim; ++j) {
                ((AbstractDoubleArray)sliceWidth).set(0, j, bounds[j].get(counter[j] + 1, 0) - bounds[j].get(counter[j], 0));
                ((AbstractDoubleArray)sliceCenter).set(0, j, (bounds[j].get(counter[j] + 1, 0) + bounds[j].get(counter[j], 0)) / (double)2);
            }
            this.slice[i] = new Slice(this, sliceCenter, sliceWidth);
            if (i >= this.slice.length - 1) continue;
            this.incCounter(counter, numberSlicesPerDimension);
        }
        this.countFromBounds();
    }

    private void setSlicesCentersnWidths(AbstractMatrix[] centers, AbstractMatrix[] widths) {
        int numDim = this.M.getColumnDimension();
        int[] numberSlicesPerDimension = new int[numDim];
        for (int i = 0; i < numberSlicesPerDimension.length; ++i) {
            numberSlicesPerDimension[i] = centers[i].getRowDimension();
        }
        this.slice = new Slice[Slicing.cumProd(numberSlicesPerDimension)];
        int[] counter = new int[numberSlicesPerDimension.length];
        Matrix sliceWidth = new Matrix(1, this.M.getColumnDimension());
        Matrix sliceCenter = new Matrix(1, this.M.getColumnDimension());
        for (int i = 0; i < this.slice.length; ++i) {
            for (int j = 0; j < numDim; ++j) {
                ((AbstractDoubleArray)sliceWidth).set(0, j, widths[j].get(counter[j], 0));
                ((AbstractDoubleArray)sliceCenter).set(0, j, centers[j].get(counter[j], 0));
            }
            this.slice[i] = new Slice(this, sliceCenter, sliceWidth);
            if (i >= this.slice.length - 1) continue;
            this.incCounter(counter, numberSlicesPerDimension);
        }
        this.countFromBounds();
    }

    private void setSlicesUniformBounds(int[] numberSlicesPerDimension) {
        int numDim = this.M.getColumnDimension();
        this.slice = new Slice[Slicing.cumProd(numberSlicesPerDimension)];
        int[] counter = new int[numberSlicesPerDimension.length];
        Matrix sliceWidth = new Matrix(1, this.M.getColumnDimension());
        Matrix sliceCenter = new Matrix(1, this.M.getColumnDimension());
        double[] Mmin = this.M.min().toDoubleArray();
        double[] Mmax = this.M.max().toDoubleArray();
        double[] pitch = new double[numDim];
        for (int j = 0; j < numDim; ++j) {
            pitch[j] = (Mmax[j] - Mmin[j]) / (double)numberSlicesPerDimension[j];
        }
        for (int i = 0; i < this.slice.length; ++i) {
            for (int j = 0; j < numDim; ++j) {
                ((AbstractDoubleArray)sliceWidth).set(0, j, pitch[j]);
                ((AbstractDoubleArray)sliceCenter).set(0, j, Mmin[j] + ((double)counter[j] + 0.5) * pitch[j]);
            }
            this.slice[i] = new Slice(this, sliceCenter, sliceWidth);
            if (i >= this.slice.length - 1) continue;
            this.incCounter(counter, numberSlicesPerDimension);
        }
        this.countFromBounds();
    }

    private void setSlicesAutoBounds(int[] numberSlicesPerDimension) {
        int numDim = this.M.getColumnDimension();
        this.slice = new Slice[Slicing.cumProd(numberSlicesPerDimension)];
        int[] counter = new int[numberSlicesPerDimension.length];
        Matrix sliceWidth = new Matrix(1, this.M.getColumnDimension());
        Matrix sliceCenter = new Matrix(1, this.M.getColumnDimension());
        int[] numberOfElement = new int[numDim];
        double[][] centers = new double[numDim][];
        double[][] widths = new double[numDim][];
        for (int j = 0; j < numDim; ++j) {
            int i;
            double[] column = this.M.getColumnArrayCopy(j);
            numberOfElement[j] = column.length / numberSlicesPerDimension[j];
            int[] sortIndex = new Sorting(column, false).getIndex();
            centers[j] = new double[numberSlicesPerDimension[j]];
            widths[j] = new double[numberSlicesPerDimension[j]];
            for (i = 0; i < numberSlicesPerDimension[j] - 1; ++i) {
                centers[j][i] = (column[(i + 1) * numberOfElement[j] - 1] + column[i * numberOfElement[j]]) / (double)2;
                widths[j][i] = column[(i + 1) * numberOfElement[j] - 1] - column[i * numberOfElement[j]];
            }
            i = numberSlicesPerDimension[j] - 1;
            centers[j][i] = (column[column.length - 1] + column[i * numberOfElement[j]]) / (double)2;
            widths[j][i] = column[column.length - 1] - column[i * numberOfElement[j]];
        }
        for (int i = 0; i < this.slice.length; ++i) {
            for (int j = 0; j < numDim; ++j) {
                ((AbstractDoubleArray)sliceWidth).set(0, j, widths[j][counter[j]]);
                ((AbstractDoubleArray)sliceCenter).set(0, j, centers[j][counter[j]]);
            }
            this.slice[i] = new Slice(this, sliceCenter, sliceWidth);
            if (i >= this.slice.length - 1) continue;
            this.incCounter(counter, numberSlicesPerDimension);
        }
        this.countFromBounds();
    }

    private void setSlices(int[][] s) {
        int numDim = this.M.getColumnDimension();
        this.slice = new Slice[s.length];
        AbstractMatrix sliceWidth = new Matrix(1, this.M.getColumnDimension());
        AbstractMatrix sliceCenter = new Matrix(1, this.M.getColumnDimension());
        for (int i = 0; i < this.slice.length; ++i) {
            AbstractMatrix tmp = this.M.getRows(s[i]);
            sliceWidth = tmp.max().minus(tmp.min());
            sliceCenter = tmp.max().plus(tmp.min()).divide(2.0);
            this.slice[i] = new Slice(this, sliceCenter, sliceWidth);
            for (int j = 0; j < tmp.getRowDimension(); ++j) {
                this.slice[i].add(tmp.getRow(j), s[i][j]);
            }
        }
    }

    private void countFromBounds() {
        int numOE = this.M.getRowDimension();
        Vector<Integer> inv = new Vector<Integer>(0);
        for (int i = 0; i < numOE; ++i) {
            int j;
            int in = 0;
            for (j = 0; j < this.slice.length; ++j) {
                if (!this.slice[j].isIn(this.M.getRow(i))) continue;
                this.slice[j].add(this.M.getRow(i), i);
                inv.add(new Integer(in));
                ++in;
            }
            if (in == true) continue;
            for (j = 0; j < inv.size(); ++j) {
                System.out.print(" ".concat(String.valueOf(String.valueOf(inv.toString()))));
            }
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("The element = ").append(this.M.getRow(i).toString()).append(" is in ").append(in).append(" slices !"))));
        }
    }

    private int[][] vectorToIntArray(Vector[] vectorArray) {
        int numSlices = vectorArray.length;
        int[][] slices = new int[numSlices][0];
        for (int i = 0; i < numSlices; ++i) {
            slices[i] = new int[vectorArray[i].size()];
            for (int j = 0; j < slices[i].length; ++j) {
                slices[i][j] = (Integer)vectorArray[i].get(j);
            }
        }
        return slices;
    }

    private static int cumProd(int[] a) {
        int res = 1;
        for (int i = 0; i < a.length; ++i) {
            res *= a[i];
        }
        return res;
    }

    private void incCounter(int[] counter, int[] counterMaxs) {
        int i;
        int decToInc = 0;
        for (i = 0; i < counter.length; ++i) {
            if (counter[i] < counterMaxs[i] - 1) {
                decToInc = i;
                break;
            }
            ++decToInc;
        }
        int n = decToInc;
        counter[n] = counter[n] + 1;
        for (i = 0; i < decToInc; ++i) {
            counter[i] = 0;
        }
    }

    private String arrayToString(int[] array) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            s.append(" ".concat(String.valueOf(String.valueOf(array[i]))));
        }
        return s.toString();
    }

    public void toCommandLine(String title) {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("\nSlicing ").append(title).append(" :"))));
        for (int i = 0; i < this.slice.length; ++i) {
            this.slice[i].toCommandeLine("Slice ".concat(String.valueOf(String.valueOf(i))));
        }
    }

    public static void main(String[] args) {
        Matrix X = Matrix.random(10, 2);
        X.toCommandLine("X");
        Slicing s1 = new Slicing((AbstractMatrix)X, new int[]{3, 2}, AUTO_BOUNDS);
        s1.toCommandLine("");
    }

    static {
        AUTO_BOUNDS = AUTO_BOUNDS;
        UNIFORM_BOUNDS = UNIFORM_BOUNDS;
        epsilon = 1.0E-6;
    }

    private class Slice {
        public Vector indexes;
        public int cardinal;
        public AbstractMatrix center;
        public AbstractMatrix width;

        public Slice(Slicing this$0, AbstractMatrix c, AbstractMatrix w) {
            c.checkRowDimension(1);
            w.checkRowDimension(1);
            this.center = c.copy();
            this.width = w.copy();
            this.indexes = new Vector();
        }

        public boolean isIn(AbstractDoubleArray x) {
            x.checkRowDimension(1);
            boolean in = true;
            for (int j = 0; j < x.getColumnDimension(); ++j) {
                boolean inj = Math.abs(x.get(0, j) - this.center.get(0, j)) - this.width.get(0, j) / (double)2 <= epsilon;
                in = in && inj;
            }
            return in;
        }

        public void add(AbstractDoubleArray x, int i) {
            ++this.cardinal;
            this.indexes.add(new Integer(i));
        }

        public int[] getIndexesArray() {
            int[] array = new int[this.indexes.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Integer)this.indexes.get(i);
            }
            return array;
        }

        public void toCommandeLine(String s) {
            System.out.println("\n".concat(String.valueOf(String.valueOf(s))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("  contains ").append(this.cardinal).append(" elements"))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("  min = ").append(this.center.minus(this.width.divide(2.0)).toString()).append("  max = ").append(this.center.plus(this.width.divide(2.0)).toString()))));
            System.out.println("  elements indices : ");
            for (int i = 0; i < this.indexes.size(); ++i) {
                System.out.print(" ".concat(String.valueOf(String.valueOf((Integer)this.indexes.get(i)))));
            }
        }
    }
}

