/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.data;

import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.data.RandomVariable;
import org.jmat.data.matrixTools.Shuffle;
import org.jmat.function.DoubleFunction;

public class RandomMatrix
extends Matrix {
    private boolean isSample = true;

    public RandomMatrix(int m, int n) {
        super(m, n);
    }

    public RandomMatrix(AbstractMatrix M) {
        super(M.toDouble2DArray());
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, M.get(i, j));
            }
        }
    }

    public static RandomMatrix uniform(int m, int n, double min, double max) {
        RandomMatrix X = new RandomMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double x = RandomVariable.uniform(min, max);
                X.set(i, j, x);
            }
        }
        return X;
    }

    public static RandomMatrix dirac(int m, int n, AbstractMatrix val_prob) {
        val_prob.checkColumnDimension(2);
        RandomMatrix X = new RandomMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double x = RandomVariable.dirac(val_prob.toDoubleColumnArray(0), val_prob.toDoubleColumnArray(1));
                X.set(i, j, x);
            }
        }
        return X;
    }

    public static RandomMatrix normal(int m, int n, double mu, double sigma) {
        RandomMatrix X = new RandomMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double x = RandomVariable.normal(mu, sigma);
                X.set(i, j, x);
            }
        }
        return X;
    }

    public static RandomMatrix logNormal(int m, int n, double mu, double sigma) {
        RandomMatrix X = new RandomMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double x = RandomVariable.logNormal(mu, sigma);
                X.set(i, j, Math.exp(x));
            }
        }
        return X;
    }

    public static RandomMatrix exponential(int m, int n, double lambda) {
        RandomMatrix X = new RandomMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double x = RandomVariable.exponential(lambda);
                X.set(i, j, x);
            }
        }
        return X;
    }

    public static RandomMatrix triangular(int m, int n, double min, double max) {
        RandomMatrix X = new RandomMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double x = RandomVariable.triangular(min, max);
                X.set(i, j, x);
            }
        }
        return X;
    }

    public static RandomMatrix triangular(int m, int n, double min, double med, double max) {
        RandomMatrix X = new RandomMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double x = RandomVariable.triangular(min, med, max);
                X.set(i, j, x);
            }
        }
        return X;
    }

    public static RandomMatrix beta(int m, int n, double a, double b) {
        RandomMatrix X = new RandomMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double x = RandomVariable.beta(a, b);
                X.set(i, j, x);
            }
        }
        return X;
    }

    public static RandomMatrix cauchy(int m, int n, double mu, double sigma) {
        RandomMatrix X = new RandomMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double x = RandomVariable.cauchy(mu, sigma);
                X.set(i, j, x);
            }
        }
        return X;
    }

    public static RandomMatrix weibull(int m, int n, double lambda, double c) {
        RandomMatrix X = new RandomMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double x = RandomVariable.weibull(lambda, c);
                X.set(i, j, x);
            }
        }
        return X;
    }

    public static RandomMatrix rejection(int m, int n, DoubleFunction fun, double min, double max) {
        RandomMatrix X = new RandomMatrix(m, n);
        double maxFun = 0.0;
        for (int i = 0; i < 10 * m * n; ++i) {
            double[] val = new double[]{min + (double)i * (max - min) / (double)(10 * m * n - 1)};
            maxFun = Math.max(maxFun, fun.eval(new Matrix(val, 1)));
        }
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double try_x = RandomVariable.rejection(fun, maxFun, min, max);
                X.set(i, j, try_x);
            }
        }
        return X;
    }

    public static RandomMatrix sampleWithReplacement(int m, int n, Matrix B) {
        RandomMatrix X = new RandomMatrix(m, n);
        Matrix b = (Matrix)B.reshapeRows(B.m * B.n, 1);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                int num = RandomVariable.randInt(0, B.n * B.m - 1);
                X.set(i, j, b.get(num, 0));
            }
        }
        return X;
    }

    public static RandomMatrix sampleWithoutReplacement(int m, int n, Matrix B) {
        RandomMatrix X = new RandomMatrix(m * n, 1);
        if (m * n > B.m * B.n) {
            throw new IllegalArgumentException("Matrix number of elements must be < ".concat(String.valueOf(String.valueOf(B.m * B.n))));
        }
        Shuffle order = new Shuffle(B.m * B.n);
        AbstractMatrix b = B.reshapeRows(B.m * B.n, 1);
        for (int i = 0; i < m * n; ++i) {
            X.set(i, 0, b.get(order.getOrder(i), 0));
        }
        return new RandomMatrix(X.reshapeRows(m, n));
    }

    public void setIsSample(boolean is) {
        this.isSample = is;
    }

    public boolean getIsSample() {
        return this.isSample;
    }

    public AbstractMatrix mean() {
        return super.mean();
    }

    public AbstractMatrix covariance() {
        int degrees = this.isSample ? this.m - 1 : this.m;
        return super.covariance().times((this.m - 1) / degrees);
    }

    public AbstractMatrix correlation() {
        int degrees = this.isSample ? this.m - 1 : this.m;
        return super.correlation().times((this.m - 1) / degrees);
    }

    public AbstractMatrix variance() {
        int degrees = this.isSample ? this.m - 1 : this.m;
        return super.variance().times((this.m - 1) / degrees);
    }
}

