/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.jmat.data.AbstractMatrix;

public class MapedMatrix
extends AbstractMatrix {
    private File file;
    private RandomAccessFile raf;
    private FileChannel fc;
    private MappedByteBuffer mbb;

    public MapedMatrix(int _m, int _n) {
        super(_m, _n);
        this.file = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(System.getProperty("user.home")))).append("/.Matrix").append(this.m).append("x").append(this.n).append(".").append(this.hashCode()).append(".bin"))));
        try {
            this.raf = new RandomAccessFile(this.file, "rw");
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        this.fc = this.raf.getChannel();
        try {
            this.mbb = this.fc.map(FileChannel.MapMode.READ_WRITE, 0L, this.fc.size());
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
        this.setAllConstant(0.0);
    }

    public void set(int i, int j, double s) {
        if (i > this.m || j > this.n) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Index (").append(i).append(",").append(j).append(") not available"))));
        }
        long pos = i * this.n + j;
        try {
            this.raf.seek(pos * (long)8);
            this.raf.writeDouble(s);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void close() {
        try {
            this.raf.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void reset(int m2, int n2) {
        this.m = m2;
        this.n = n2;
        this.setAllConstant(0.0);
    }

    public AbstractMatrix getInstance(int _m, int _n) {
        return new MapedMatrix(_m, _n);
    }

    public double get(int i, int j) {
        double v;
        if (i > this.m || j > this.n) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Index (").append(i).append(",").append(j).append(") not available"))));
        }
        long pos = i * this.n + j;
        try {
            this.raf.seek(pos * (long)8);
            v = this.raf.readDouble();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            v = -1.0;
        }
        return v;
    }

    public static void main(String[] args) {
        MapedMatrix MM = new MapedMatrix(5, 5);
        MM.toCommandLine("MM");
        MM.set(3, 2, 10.0);
        System.out.println("".concat(String.valueOf(String.valueOf(MM.get(3, 2)))));
        MM.set(2, 2, 1.0);
        MM.toCommandLine("MM");
    }
}

