/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.itcknow.bigml.algo.hadoop;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Random;
import kr.ac.kaist.itcknow.bigml.algo.hadoop.Dataset;
import kr.ac.kaist.itcknow.bigml.algo.multicore.cd.LRCD;
import kr.ac.kaist.itcknow.bigml.algo.multicore.sgd.LRSGD;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class DSCD
extends Configured
implements Tool {
    public static Logger logger = Logger.getLogger(DSCD.class);
    static String hdfsPath = "hdfs://172.20.1.1:9000/user/dykang/";

    protected JobConf THadoopDSCD(String inPath, Path outPath, int D, int C, int itr, String expt, String cfile, String dataType) throws Exception {
        JobConf conf = new JobConf(this.getConf(), DSCD.class);
        conf.setJobName(String.format("[DSCD][ITR-%d][%s] D=%d\tC=%d", itr, dataType, D, C));
        conf.set("d", "" + D);
        conf.set("c", "" + C);
        conf.set("itr", "" + itr);
        conf.set("cfile", cfile);
        conf.set("inPath", "" + inPath);
        conf.set("outPath", "" + outPath);
        conf.set("expt", "" + expt);
        conf.set("dataType", dataType);
        long milliSecionds = 0L;
        conf.setLong("mapred.task.timeout", milliSecionds);
        logger.info((Object)String.format("[DSCD][ITR-%d][%s] D=%d\tC=%d", itr, dataType, D, C));
        conf.setMapOutputKeyClass(Text.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(THadoopMyMapper.class);
        conf.setNumReduceTasks(0);
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(TextOutputFormat.class);
        FileInputFormat.setInputPaths((JobConf)conf, (String)inPath);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outPath);
        return conf;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 4) {
            return this.printUsage();
        }
        Path inPath = new Path(args[0]);
        Path outPath = new Path(args[1]);
        int hadoopitr = Integer.parseInt(args[2]);
        int C = Integer.parseInt(args[3]);
        Dataset ds = new Dataset(inPath);
        int D = ds.getD();
        int N = ds.getN();
        String dataType = ds.getDataType();
        String expt = "DSCD";
        System.out.println("Running.... [" + expt + "] " + dataType + "\tD=" + D + "\tC=" + C);
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        String local_output_path = "./output/dscd.local";
        String cfileName = String.format("dscd_%d_%d_%d.txt", D, hadoopitr, C);
        Path cfilePath = new Path(local_output_path + "/" + cfileName);
        BufferedWriter br = new BufferedWriter(new FileWriter(new File(cfilePath.toString())));
        for (int d = 1; d <= D / C; ++d) {
            br.write(d + "\n");
        }
        br.close();
        fs.copyFromLocalFile(cfilePath, outPath);
        String local_output_path_exp = local_output_path + "/" + hadoopitr + "_" + C + "/";
        Path hadoop_output_path_exp = new Path(outPath.toString() + "/" + hadoopitr + "_" + C + "/");
        expt = expt + "_" + hadoopitr + "_" + C;
        for (int itr = 1; itr <= hadoopitr; ++itr) {
            long start = System.currentTimeMillis();
            JobClient.runJob((JobConf)this.THadoopDSCD(outPath + "/" + cfileName, new Path(hadoop_output_path_exp.toString() + "/" + itr), D, C, itr, expt, inPath.toString(), dataType));
            long end = System.currentTimeMillis();
            FileUtil.fullyDelete((File)new File(local_output_path_exp + itr + "/"));
            fs.copyToLocalFile(new Path(hadoop_output_path_exp.toString() + "/" + itr), new Path(local_output_path_exp + itr + "/"));
            String[] args2 = ("--x " + dataType + " --f " + hdfsPath + inPath.toString() + " --tt " + hdfsPath + inPath.toString().replace("train", "test") + " --i " + 1).split(" ");
            PosixParser parser = new PosixParser();
            LRSGD.InitOptions();
            CommandLine cli = parser.parse(LRSGD.options, args2);
            LRCD lr = new LRCD(cli);
            lr.dim = D;
            lr.init();
            lr.mergeParamsDSCD(local_output_path_exp + itr + "/");
            lr.printParams(String.format("%s%s.params", local_output_path_exp, expt + "_" + itr));
            fs.copyFromLocalFile(new Path(String.format("%s%s.params", local_output_path_exp, expt + "_" + itr)), new Path(hadoop_output_path_exp.toString()));
            if (dataType.equals("rcv1") || dataType.equals("arcene") || dataType.equals("news20") || dataType.equals("zeta") || dataType.equals("a9") || dataType.equals("kdda") || dataType.equals("kddb")) {
                System.out.println(String.format("Iteration:%d\tTime:%d", itr, (end - start) / 1000L));
                continue;
            }
            if (!dataType.equals("1") && !dataType.equals("2") && !dataType.equals("3")) continue;
            System.out.println(String.format("Iteration:%d\tTime:%d", itr, (end - start) / 1000L));
        }
        return 0;
    }

    private int printUsage() {
        System.out.println("DSCD <in_path> <out_path> <hditr> <C>");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"./log4j.properties");
        logger.info((Object)"DSCD running....");
        int result = ToolRunner.run((Configuration)new Configuration(), (Tool)new DSCD(), (String[])args);
        System.exit(result);
    }

    public static class THadoopMyMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, Text> {
        int D;
        int itr;
        int C;
        String inPath;
        String cfile;
        String outPath;
        String expt;
        String dataType;
        LRCD lr = null;
        double samplingRatio = 0.5;

        public void configure(JobConf job) {
            this.D = Integer.parseInt(job.get("d"));
            this.itr = Integer.parseInt(job.get("itr"));
            this.C = Integer.parseInt(job.get("c"));
            this.cfile = job.get("cfile");
            this.inPath = job.get("inPath");
            this.outPath = job.get("outPath");
            this.expt = job.get("expt");
            this.dataType = job.get("dataType");
            logger.info((Object)String.format("[DSCD][ITR-%d][Map][%s] D=%d\tC=%d", this.itr, this.dataType, this.D, this.C));
        }

        public void map(LongWritable key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            int dIndex = Integer.parseInt(value.toString());
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            String returnStr = "";
            try {
                Path pt;
                String[] args = ("--x " + this.dataType + " --i " + 1).split(" ");
                PosixParser parser = new PosixParser();
                LRCD.InitOptions();
                CommandLine cli = parser.parse(LRCD.options, args);
                this.lr = new LRCD(cli);
                HashSet<String> dSet = this.randomDSetGenerate();
                this.lr.dim = this.D;
                this.lr.num_label = 2;
                this.lr.init();
                if (this.itr > 1) {
                    pt = new Path(String.format(hdfsPath + "%s/%s.params", this.outPath.substring(0, this.outPath.toString().lastIndexOf("/")), this.expt + "_" + (this.itr - 1)));
                    this.lr.readParams(new InputStreamReader((InputStream)fs.open(pt)));
                }
                pt = new Path(hdfsPath + this.cfile);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(pt)));
                String line = "";
                while ((line = br.readLine()) != null) {
                    if (line.equals("") || Math.random() > this.samplingRatio) continue;
                    int startIndex = 0;
                    if (this.lr.isHadoopGeneratedData) {
                        startIndex = 1;
                    }
                    String[] tokens = line.split(this.lr.dataDeliminator);
                    int y = this.lr.getIndex(this.lr.label_index, tokens[startIndex]);
                    double[] feature_vector = new double[this.lr.dim];
                    for (int i = startIndex + 1; i < tokens.length; ++i) {
                        String[] toks = tokens[i].split(":");
                        int feature = this.lr.getFeatureIndex(toks[0]);
                        feature_vector[feature] = Double.parseDouble(toks[1]);
                    }
                    this.lr.trainOneInstance(dSet, y, feature_vector);
                }
                returnStr = returnStr + this.lr.getParamFormatString(dSet);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            output.collect((Object)new Text("" + dIndex), (Object)new Text(returnStr));
        }

        private HashSet<String> randomDSetGenerate() {
            HashSet<String> dSet = new HashSet<String>();
            if (this.C == 1) {
                for (int d = 1; d <= this.D; ++d) {
                    dSet.add("" + d);
                }
            } else {
                int dCnt = this.D / this.C;
                Random rand = new Random();
                while (dSet.size() < dCnt) {
                    int dRand = rand.nextInt(this.D - 1 + 1) + 1;
                    if (dSet.contains(dRand)) continue;
                    dSet.add("" + dRand);
                }
            }
            if (dSet.size() != this.D / this.C) {
                System.exit(1);
            }
            return dSet;
        }
    }
}

