/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.itcknow.bigml.algo.hadoop;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import kr.ac.kaist.itcknow.bigml.algo.hadoop.DSGD;
import kr.ac.kaist.itcknow.bigml.algo.hadoop.Dataset;
import kr.ac.kaist.itcknow.bigml.algo.multicore.cd.LRCD;
import kr.ac.kaist.itcknow.bigml.algo.multicore.sgd.LRSGD;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class DPSCD
extends Configured
implements Tool {
    public static Logger logger = Logger.getLogger(DPSCD.class);
    static String hdfsPathStr = "hdfs://172.20.1.1:9000/user/dykang/";

    protected JobConf THadoopDPSCD(Path inPath, Path outPath, int nreducers, int D, int C, int itr, String expt, String dataType) throws Exception {
        JobConf conf = new JobConf(this.getConf(), DPSCD.class);
        conf.setJobName(String.format("[DPSCD][ITR-%d][%s] D=%d\tC=%d", itr, dataType, D, C));
        conf.set("nreducers", "" + nreducers);
        conf.set("d", "" + D);
        conf.set("c", "" + C);
        conf.set("itr", "" + itr);
        conf.set("expt", expt);
        conf.set("outPath", "" + outPath);
        conf.set("dataType", dataType);
        long milliSecionds = 0L;
        conf.setLong("mapred.task.timeout", milliSecionds);
        logger.info((Object)String.format("[FeDis][ITR-%d][%s] D=%d\tC=%d", itr, dataType, D, C));
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(DSGD.MyMapper.class);
        conf.setPartitionerClass(DSGD.MyPartitioner.class);
        conf.setReducerClass(THadoopDPSCDMyReducer.class);
        conf.setNumReduceTasks(nreducers);
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(TextOutputFormat.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inPath});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outPath);
        return conf;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 6) {
            return this.printUsage();
        }
        Path inPath = new Path(args[0]);
        Path outPath = new Path(args[1]);
        hdfsPathStr = args[2];
        int nreducers = Integer.parseInt(args[3]);
        int hadoopitr = Integer.parseInt(args[4]);
        int C = Integer.parseInt(args[5]);
        Dataset ds = new Dataset(inPath);
        int D = ds.getD();
        int N = ds.getN();
        String dataType = ds.getDataType();
        String expt = "FeDis";
        System.out.println("Running.... [" + expt + "] " + dataType + "\tD=" + D + "\tC=" + C);
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        String local_output_path = "./output/dpscd.local";
        String local_output_path_exp = String.valueOf(local_output_path) + "/" + hadoopitr + "_" + C + "/";
        Path outPath_exp = new Path(String.valueOf(outPath.toString()) + "/" + hadoopitr + "_" + C + "/");
        expt = String.valueOf(expt) + "_" + hadoopitr + "_" + C;
        int itr = 1;
        while (itr <= hadoopitr) {
            long start = System.currentTimeMillis();
            JobClient.runJob((JobConf)this.THadoopDPSCD(inPath, new Path(String.valueOf(outPath_exp.toString()) + "/" + itr), nreducers, D, C, itr, expt, dataType));
            long end = System.currentTimeMillis();
            FileUtil.fullyDelete((File)new File(String.valueOf(local_output_path_exp) + itr + "/"));
            fs.copyToLocalFile(new Path(String.valueOf(outPath_exp.toString()) + "/" + itr + "/"), new Path(String.valueOf(local_output_path_exp) + itr + "/"));
            String[] args2 = ("--x " + dataType + " --f " + hdfsPathStr + inPath.toString() + " --tt " + hdfsPathStr + inPath.toString().replace("train", "test") + " --i " + 1).split(" ");
            PosixParser parser = new PosixParser();
            LRSGD.InitOptions();
            CommandLine cli = parser.parse(LRSGD.options, args2);
            LRCD lr = new LRCD(cli);
            lr.dim = D;
            lr.num_label = 2;
            lr.init();
            lr.mergeParamsDPSCD(String.valueOf(local_output_path_exp) + itr + "/");
            lr.printParams(String.format("%s%s.params", local_output_path_exp, String.valueOf(expt) + "_" + itr));
            fs.copyFromLocalFile(new Path(String.format("%s%s.params", local_output_path_exp, String.valueOf(expt) + "_" + itr)), new Path(outPath_exp.toString()));
            if (dataType.equals("rcv1") || dataType.equals("arcene") || dataType.equals("news20") || dataType.equals("zeta") || dataType.equals("a9") || dataType.equals("kdda") || dataType.equals("kddb")) {
                LRSGD.Result res = lr.getAccuracy(new InputStreamReader((InputStream)fs.open(new Path(lr.test_file))));
                System.out.println("Calculating likelihood and accuracy...");
                double likelihood = 0.0;
                likelihood = lr.calculateLikelihoodSequential(fs);
                System.out.println(String.format("Iteration:%d\tTime:%d\tLikelihood:%f\tAccuracy:%f", itr, (end - start) / 1000L, likelihood, res.accuracy * 100.0));
            } else if (dataType.equals("1") || dataType.equals("2") || dataType.equals("3")) {
                System.out.println(String.format("Iteration:%d\tTime:%d", itr, (end - start) / 1000L));
            }
            ++itr;
        }
        return 0;
    }

    public int printUsage() {
        System.out.println("DPSCD <in_path> <out_path> <hdfsPath> <nreducer> <hditr> <C>");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public static void main(String[] args) throws Exception {
        logger.info((Object)"FeDis running....");
        int result = ToolRunner.run((Configuration)new Configuration(), (Tool)new DPSCD(), (String[])args);
        System.exit(result);
    }

    public static class THadoopDPSCDMyReducer
    extends MapReduceBase
    implements Reducer<IntWritable, Text, IntWritable, Text> {
        int D;
        int C;
        int itr;
        int nreducers;
        String expt;
        String outPath;
        String dataType;
        int mIndex = -1;

        public void configure(JobConf job) {
            this.D = Integer.parseInt(job.get("d"));
            this.C = Integer.parseInt(job.get("c"));
            this.itr = Integer.parseInt(job.get("itr"));
            this.nreducers = Integer.parseInt(job.get("nreducers"));
            this.outPath = job.get("outPath");
            this.expt = job.get("expt");
            this.dataType = job.get("dataType");
            logger.info((Object)String.format("[DSCD][ITR-%d][Reduce][%s] D=%d\tC=%d", this.itr, this.dataType, this.D, this.C));
        }

        public void reduce(IntWritable key, Iterator<Text> values, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            this.mIndex = Integer.parseInt(key.toString());
            LRCD lr = null;
            String returnStr = "";
            try {
                String[] args = ("--x " + this.dataType + " --i " + 1).split(" ");
                PosixParser parser = new PosixParser();
                LRCD.InitOptions();
                CommandLine cli = parser.parse(LRCD.options, args);
                lr = new LRCD(cli);
                HashSet<String> dSet = this.randomDSetGenerate();
                lr.dim = this.D;
                lr.num_label = 2;
                lr.init();
                int nInstance = 0;
                if (this.itr > 1) {
                    Path pt = new Path(String.format(String.valueOf(hdfsPathStr) + "%s/%s.params", this.outPath.substring(0, this.outPath.toString().lastIndexOf("/")), String.valueOf(this.expt) + "_" + (this.itr - 1)));
                    FileSystem fs = FileSystem.get((Configuration)new Configuration());
                    lr.addParams(new InputStreamReader((InputStream)fs.open(pt)));
                }
                while (values.hasNext()) {
                    ++nInstance;
                    int startIndex = 0;
                    if (lr.isHadoopGeneratedData) {
                        startIndex = 1;
                    }
                    String[] tokens = values.next().toString().split(lr.dataDeliminator);
                    int y = lr.getIndex(lr.label_index, tokens[startIndex]);
                    double[] feature_vector = new double[lr.dim];
                    int i = startIndex + 1;
                    while (i < tokens.length) {
                        String[] toks = tokens[i].split(":");
                        int feature = lr.getFeatureIndex(toks[0]);
                        feature_vector[feature] = Double.parseDouble(toks[1]);
                        ++i;
                    }
                    lr.trainOneInstance(dSet, y, feature_vector);
                }
                lr.num_instance = nInstance;
                returnStr = String.valueOf(returnStr) + nInstance + ":" + lr.num_label + ":" + lr.dim + lr.getParamFormatString(dSet);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            output.collect((Object)key, (Object)new Text(returnStr));
        }

        private HashSet<String> randomDSetGenerate() {
            HashSet<String> dSet = new HashSet<String>();
            int i = 1;
            while (i <= this.D) {
                if (i % (this.nreducers * this.C) == this.mIndex + this.itr) {
                    dSet.add("" + i);
                }
                ++i;
            }
            return dSet;
        }
    }
}

