/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.io.files;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.XMLOutputter;
import org.jmat.data.Matrix;
import org.jmat.io.files.DataFile;

public class XMLFile
extends DataFile {
    public XMLFile(File f) {
        super(f);
    }

    public static Element readRoot(File f) {
        XMLFile xf = new XMLFile(f);
        return xf.read();
    }

    public static String[] readContents(File f, String[] elementsNames, String[][] attributesNames, String[][] attributesValues) {
        XMLFile xf = new XMLFile(f);
        return xf.readContents(elementsNames, attributesNames, attributesValues);
    }

    public static String readContent(File f, String[] elementsNames, String[][] attributesNames, String[][] attributesValues) {
        XMLFile xf = new XMLFile(f);
        return xf.readContent(elementsNames, attributesNames, attributesValues);
    }

    public static void writeRoot(File f, Element e) {
        XMLFile xf = new XMLFile(f);
        xf.write(e);
    }

    public Element read() {
        try {
            DOMBuilder b = new DOMBuilder();
            Document d = b.build(this.file);
            Element element = d.getRootElement();
            return element;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unreadable : ").append(e.toString()))));
        }
    }

    public String readAttributeValue(String attributeName, String[] elementsNames, String[][] attributesNames, String[][] attributesValues) {
        String[] attributeValues = this.readAttributeValues(attributeName, elementsNames, attributesNames, attributesValues);
        if (attributeValues.length >= 2) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("The XML path specified is found ").append(attributeValues.length + 1).append(" times."))));
        }
        return attributeValues[0];
    }

    public String[] readAttributeValues(String attributeName, String[] elementsNames, String[][] attributesNames, String[][] attributesValues) {
        Element root = this.read();
        Vector elements = new Vector();
        elements.add(root);
        for (int i = 0; i < elementsNames.length; ++i) {
            elements = this.getElements(elements, elementsNames[i], attributesNames[i], attributesValues[i]);
        }
        String[] attributeValues = new String[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            attributeValues[i] = ((Element)elements.get(i)).getAttributeValue(attributeName).trim();
        }
        return attributeValues;
    }

    public String readContent(String[] elementsNames, String[][] attributesNames, String[][] attributesValues) {
        String[] datas = this.readContents(elementsNames, attributesNames, attributesValues);
        if (datas.length != 1) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("The XML path specified is found ").append(datas.length).append(" times."))));
        }
        return datas[0];
    }

    public String[] readContents(String[] elementsNames, String[][] attributesNames, String[][] attributesValues) {
        Element root = this.read();
        Vector elements = new Vector();
        elements.add(root);
        for (int i = 0; i < elementsNames.length; ++i) {
            elements = this.getElements(elements, elementsNames[i], attributesNames[i], attributesValues[i]);
        }
        String[] datas = new String[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            datas[i] = ((Element)elements.get(i)).getText().trim();
        }
        return datas;
    }

    public String readContent(String[] elementsNames) {
        return this.readContent(elementsNames, new int[elementsNames.length]);
    }

    public String readContent(String[] elementsNames, int[] subElementsIndexes) {
        Element current = this.read();
        for (int i = 0; i < elementsNames.length; ++i) {
            List elementsList = current.getChildren(elementsNames[i]);
            current = (Element)elementsList.get(subElementsIndexes[i]);
        }
        return current.getText().trim();
    }

    public void write(String elementName, String[] attributesNames, String[] attributesValues) {
        Element root = new Element(elementName);
        List attributes = root.getAttributes();
        for (int i = 0; i < attributesNames.length; ++i) {
            attributes.add(new Attribute(attributesNames[i], attributesValues[i]));
        }
        root.setAttributes(attributes);
        this.write(root);
    }

    public void write(Element e) {
        if (this.file.exists()) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Warning : the file ").append(this.file.getName()).append(" already exists !"))));
        }
        Document doc = new Document(e);
        XMLOutputter op = new XMLOutputter();
        op.setNewlines(true);
        op.setIndent(true);
        try {
            FileWriter fw = new FileWriter(this.file);
            BufferedWriter bw = new BufferedWriter(fw);
            op.output(doc, (Writer)bw);
            bw.close();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unwritable : ").append(e.toString()))));
        }
    }

    public Element getElement(Element root, String elementsName, String[] attributesNames, String[] attributesValues) {
        Vector<Element> roots = new Vector<Element>();
        roots.add(root);
        Vector el = this.getElements(roots, elementsName, attributesNames, attributesValues);
        if (el.size() != 1) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("The XML Element specified is found ").append(el.size()).append(" times."))));
        }
        return (Element)el.get(0);
    }

    public Element getElement(String elementsName, String[] attributesNames, String[] attributesValues) {
        return this.getElement(this.read(), elementsName, attributesNames, attributesValues);
    }

    private boolean attributesnNameEquals(Element e1, Element e2) {
        List e1attr = e1.getAttributes();
        List e2attr = e2.getAttributes();
        if (!e1.getName().equals(e2.getName())) {
            return false;
        }
        if (e1attr.size() != e2attr.size()) {
            return false;
        }
        for (int i = 0; i < e1attr.size(); ++i) {
            if (!((Attribute)e1attr.get(i)).getName().equals(((Attribute)e1attr.get(i)).getName())) {
                return false;
            }
            if (((Attribute)e1attr.get(i)).getValue().equals(((Attribute)e1attr.get(i)).getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean attributesEquals(Element e, String[] attributesNames, String[] attributesValues) {
        boolean equals = true;
        for (int i = 0; i < attributesNames.length; ++i) {
            equals = equals && (attributesNames[i] == null || attributesValues[i].equals("*") || e.getAttributeValue(attributesNames[i]).trim().equals(attributesValues[i].trim()));
        }
        return equals;
    }

    private Vector getElements(Vector roots, String elementsName, String[] attributesNames, String[] attributesValues) {
        Vector<Element> elements = new Vector<Element>();
        for (int i = 0; i < roots.size(); ++i) {
            int found = 0;
            List elementsList = ((Element)roots.get(i)).getChildren(elementsName);
            for (int j = 0; j < elementsList.size(); ++j) {
                if (!this.attributesEquals((Element)elementsList.get(j), attributesNames, attributesValues)) continue;
                if (((Element)elementsList.get(j)).getAttributes().size() > attributesNames.length) {
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer("Warning : ").append(((Element)elementsList.get(j)).toString()).append(" has some attributes not specified !!!"))));
                }
                ++found;
                elements.add((Element)elementsList.get(j));
            }
            if (found != 0) continue;
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(((Element)roots.get(i)).toString()))).append(" has no child <").append(elementsName).append("> !!!"))));
        }
        return elements;
    }

    public static void main(String[] args) {
        Matrix X = Matrix.random(3, 4);
        X.toCommandLine("X");
        Element m = new Element("matrix");
        for (int i = 0; i < X.getRowDimension(); ++i) {
            Element rowi = new Element("row").setAttribute("number", String.valueOf(String.valueOf(new StringBuffer("").append(i + 1))));
            for (int j = 0; j < X.getColumnDimension(); ++j) {
                Element columnjrowi = new Element("column").setAttribute("number", String.valueOf(String.valueOf(new StringBuffer("").append(j + 1))));
                columnjrowi.setText("".concat(String.valueOf(String.valueOf(X.get(i, j)))));
                rowi.addContent(columnjrowi);
            }
            m.addContent(rowi);
        }
        XMLFile.writeRoot(new File("matrix.xml"), m);
        String Y = XMLFile.readContent(new File("matrix.xml"), new String[]{"row", "column"}, new String[][]{{"number"}, {"number"}}, new String[][]{{"1"}, {"2"}});
        System.out.println(Y);
        String[] Ys = XMLFile.readContents(new File("matrix.xml"), new String[]{"row", "column"}, new String[][]{{"number"}, {"number"}}, new String[][]{{"*"}, {"2"}});
        for (int i = 0; i < Ys.length; ++i) {
            System.out.println(Ys[i]);
        }
    }
}

