/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.io;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jmat.data.AbstractDoubleArray;
import org.jmat.data.Matrix;

public class MatrixString {
    private static int decimalSize = 10;
    private static String defaultWordDelimiter = " ";
    private static String defaultSentenceDelimiter = "\n";

    public static String printMatrix(AbstractDoubleArray m) {
        return MatrixString.printMatrix(m, defaultWordDelimiter, defaultSentenceDelimiter);
    }

    public static String printMatrix(AbstractDoubleArray m, String wordDelimiter, String sentenceDelimiter) {
        StringBuffer str = new StringBuffer(25 * m.getRowDimension() * m.getColumnDimension());
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(decimalSize);
        format.setMinimumFractionDigits(decimalSize);
        ((NumberFormat)format).setGroupingUsed(false);
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                String s = format.format(m.get(i, j));
                str = str.append(wordDelimiter);
                str = str.append(s);
            }
            str = str.append(sentenceDelimiter);
        }
        return str.toString();
    }

    public static Matrix readString(String s) {
        return MatrixString.readString(s, defaultWordDelimiter, defaultSentenceDelimiter);
    }

    public static Matrix readString(String s, String wordDelimiter, String sentenceDelimiter) {
        String delimiterString = wordDelimiter;
        String newlineString = sentenceDelimiter;
        StringTokenizer linesTokenizer = new StringTokenizer(s, newlineString);
        Vector<double[]> lines = new Vector<double[]>();
        do {
            Vector<Double> words = new Vector<Double>();
            StringTokenizer wordsTokenizer = new StringTokenizer(linesTokenizer.nextToken(), delimiterString);
            do {
                words.addElement(Double.valueOf(wordsTokenizer.nextToken()));
            } while (wordsTokenizer.hasMoreElements());
            double[] line_i = new double[words.size()];
            for (int i = 0; i < line_i.length; ++i) {
                line_i[i] = (Double)words.get(i);
            }
            lines.add(line_i);
        } while (linesTokenizer.hasMoreElements());
        double[][] array = new double[lines.size()][];
        lines.copyInto((Object[])array);
        return new Matrix(array);
    }

    public static void main(String[] args) {
        Matrix X = MatrixString.readString("0.5 0.23 0.12 0.56\n0.45 0.12 0.12 0.0\n 0.1 0.2 0.3 0.4");
        X.toCommandLine("X");
        String s = MatrixString.printMatrix(X);
        System.out.println("X = ".concat(String.valueOf(String.valueOf(s))));
    }
}

