/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plots;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.RandomMatrix;
import org.jmat.gui.FrameView;
import org.jmat.gui.Plot3DPanel;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plots.Plot;

public class HistogramPlot3D
extends Plot {
    private AbstractMatrix widths;

    public HistogramPlot3D(AbstractMatrix XY, AbstractMatrix W, Color c, String n, Base b) {
        super(XY, c, n, b);
        this.widths = W;
        this.base.includeInBounds(new double[]{this.datas.min().get(0, 0) - this.widths.max().get(0, 0) / (double)2, this.datas.min().get(0, 1) - this.widths.max().get(0, 1) / (double)2, 0.0});
        this.base.includeInBounds(new double[]{this.datas.max().get(0, 0) + this.widths.max().get(0, 0) / (double)2, this.datas.max().get(0, 1) + this.widths.max().get(0, 1) / (double)2, 0.0});
    }

    public void plot(Graphics comp, Color c) {
        Graphics2D comp2D = (Graphics2D)comp;
        comp2D.setColor(c);
        for (int i = 0; i < this.datas.getRowDimension(); ++i) {
            double[] topNW = new double[]{this.datas.get(i, 0) - this.widths.get(i, 0) / (double)2, this.datas.get(i, 1) - this.widths.get(i, 1) / (double)2, this.datas.get(i, 2)};
            double[] topNE = new double[]{this.datas.get(i, 0) + this.widths.get(i, 0) / (double)2, this.datas.get(i, 1) - this.widths.get(i, 1) / (double)2, this.datas.get(i, 2)};
            double[] topSW = new double[]{this.datas.get(i, 0) - this.widths.get(i, 0) / (double)2, this.datas.get(i, 1) + this.widths.get(i, 1) / (double)2, this.datas.get(i, 2)};
            double[] topSE = new double[]{this.datas.get(i, 0) + this.widths.get(i, 0) / (double)2, this.datas.get(i, 1) + this.widths.get(i, 1) / (double)2, this.datas.get(i, 2)};
            double[] bottomNW = new double[]{this.datas.get(i, 0) - this.widths.get(i, 0) / (double)2, this.datas.get(i, 1) - this.widths.get(i, 1) / (double)2, 0.0};
            double[] bottomNE = new double[]{this.datas.get(i, 0) + this.widths.get(i, 0) / (double)2, this.datas.get(i, 1) - this.widths.get(i, 1) / (double)2, 0.0};
            double[] bottomSW = new double[]{this.datas.get(i, 0) - this.widths.get(i, 0) / (double)2, this.datas.get(i, 1) + this.widths.get(i, 1) / (double)2, 0.0};
            double[] bottomSE = new double[]{this.datas.get(i, 0) + this.widths.get(i, 0) / (double)2, this.datas.get(i, 1) + this.widths.get(i, 1) / (double)2, 0.0};
            this.drawLine(topNW, topNE, comp2D);
            this.drawLine(topNE, topSE, comp2D);
            this.drawLine(topSE, topSW, comp2D);
            this.drawLine(topSW, topNW, comp2D);
            this.drawLine(bottomNW, bottomNE, comp2D);
            this.drawLine(bottomNE, bottomSE, comp2D);
            this.drawLine(bottomSE, bottomSW, comp2D);
            this.drawLine(bottomSW, bottomNW, comp2D);
            this.drawLine(bottomNW, topNW, comp2D);
            this.drawLine(bottomNE, topNE, comp2D);
            this.drawLine(bottomSE, topSE, comp2D);
            this.drawLine(bottomSW, topSW, comp2D);
        }
    }

    public void note(Graphics comp) {
        this.plot(comp, Color.black);
    }

    public static void main(String[] args) {
        RandomMatrix.normal(1000, 2, 0.0, 1.0).slice(10).toCommandLine("");
        new FrameView(new Plot3DPanel(RandomMatrix.normal(1000, 2, 0.0, 1.0).slice(10), "Histogram Plot 3D", "HISTOGRAM"));
    }
}

