/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plots;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.RandomMatrix;
import org.jmat.gui.FrameView;
import org.jmat.gui.Plot2DPanel;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plots.Plot;

public class HistogramPlot2D
extends Plot {
    private AbstractMatrix widths;

    public HistogramPlot2D(AbstractMatrix XY, AbstractMatrix W, Color c, String n, Base b) {
        super(XY, c, n, b);
        this.widths = W;
        this.base.includeInBounds(new double[]{this.datas.min().get(0, 0) - this.widths.max().get(0, 0) / (double)2, 0.0});
        this.base.includeInBounds(new double[]{this.datas.max().get(0, 0) + this.widths.max().get(0, 0) / (double)2, 0.0});
    }

    public void plot(Graphics comp, Color c) {
        Graphics2D comp2D = (Graphics2D)comp;
        comp2D.setColor(c);
        for (int i = 0; i < this.datas.getRowDimension(); ++i) {
            double[] topLeft = new double[]{this.datas.get(i, 0) - this.widths.get(i, 0) / (double)2, this.datas.get(i, 1)};
            double[] topRight = new double[]{this.datas.get(i, 0) + this.widths.get(i, 0) / (double)2, this.datas.get(i, 1)};
            double[] bottomLeft = new double[]{this.datas.get(i, 0) - this.widths.get(i, 0) / (double)2, 0.0};
            double[] bottomRight = new double[]{this.datas.get(i, 0) + this.widths.get(i, 0) / (double)2, 0.0};
            this.drawLine(bottomLeft, topLeft, comp2D);
            this.drawLine(topLeft, topRight, comp2D);
            this.drawLine(topRight, bottomRight, comp2D);
            this.drawLine(bottomRight, bottomLeft, comp2D);
        }
    }

    public void note(Graphics comp) {
        this.plot(comp, Color.black);
    }

    public static void main(String[] args) {
        new FrameView(new Plot2DPanel(RandomMatrix.normal(100, 1, 0.0, 1.0).slice(10), "Histogram Plot 2D", "HISTOGRAM"));
    }
}

