/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plots;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.gui.FrameView;
import org.jmat.gui.Plot2DPanel;
import org.jmat.gui.Plot3DPanel;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plotObjects.RelativeCoord;
import org.jmat.gui.plots.Plot;

public class BarPlot
extends Plot {
    public BarPlot(AbstractMatrix XY, Color c, String n, Base b) {
        super(XY, c, n, b);
    }

    public void plot(Graphics comp, Color c) {
        RelativeCoord[] coords = this.getCoords();
        Graphics2D comp2D = (Graphics2D)comp;
        comp2D.setColor(c);
        for (int i = 0; i < this.datas.getRowDimension(); ++i) {
            this.drawLine(coords[i], coords[i].projection(this.datas.getColumnDimension() - 1), comp2D);
            this.drawDot(this.datas.toDoubleRowArray(i), comp2D);
        }
    }

    public void note(Graphics comp) {
        this.plot(comp, Color.black);
    }

    public static void main(String[] args) {
        new FrameView(new Plot2DPanel(Matrix.random(10, 2), "Bar Plot 2D", "BAR"));
        new FrameView(new Plot3DPanel(Matrix.random(10, 3), "Bar Plot 3D", "BAR"));
    }
}

