/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plotObjects;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import org.jmat.gui.plotObjects.Coord;
import org.jmat.gui.plotObjects.Plotable;

public class Label
implements Plotable {
    protected Coord coord;
    protected String label;
    protected Color color;
    protected double cornerN = 0.5;
    protected double cornerE = 0.5;

    public Label(String l, Coord c, Color col) {
        this.label = l;
        this.coord = c;
        this.color = col;
    }

    public Label(String l, Coord c) {
        this(l, c, Color.black);
    }

    public Label(Coord c) {
        this(Label.coordToString(c), c, Color.black);
    }

    public void setCorner(double n, double e) {
        this.cornerN = n;
        this.cornerE = e;
    }

    public void setOffset(double[] offset) {
        double[] newCoord = this.coord.getPlotCoordCopy();
        for (int i = 0; i < newCoord.length; ++i) {
            int n = i;
            newCoord[n] = newCoord[n] + offset[i];
        }
        this.coord.setPlotCoord(newCoord);
    }

    public void plot(Graphics comp) {
        Graphics2D comp2D = (Graphics2D)comp;
        FontRenderContext frc = comp2D.getFontRenderContext();
        comp2D.setColor(this.color);
        Font font = comp2D.getFont();
        int x = this.coord.getScreenCoordCopy()[0];
        int y = this.coord.getScreenCoordCopy()[1];
        float gh = font.getSize2D();
        comp2D.drawString(this.label, x -= (int)(font.getStringBounds(this.label, frc).getWidth() * this.cornerE), y += (int)((double)gh * this.cornerN));
    }

    public static double approx(double val, int decimal) {
        if (decimal < 0) {
            return Math.rint(val / Math.pow(10.0, -decimal)) * Math.pow(10.0, -decimal);
        }
        return Math.rint(val * Math.pow(10.0, decimal)) / Math.pow(10.0, decimal);
    }

    public static String coordToString(Coord c) {
        StringBuffer sb = new StringBuffer("(");
        for (int i = 0; i < c.getPlotCoordCopy().length; ++i) {
            sb.append(Label.approx(c.getPlotCoordCopy()[i], 2)).append(",");
        }
        sb.setLength(sb.length() - 1);
        if (sb.length() > 0) {
            sb.append(")");
        }
        return sb.toString();
    }
}

