/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plotObjects;

import java.awt.Graphics;
import org.jmat.gui.plotObjects.Axe;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plotObjects.BaseScalesDependant;
import org.jmat.gui.plotObjects.Plotable;

public class Grid
implements Plotable,
BaseScalesDependant {
    public static double borderCoeff = 0.1;
    protected Base base;
    protected Axe[] axes;

    public Grid(Base b, String[] as) {
        this.base = b;
        if (as.length != this.base.dimension) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("String array of axes names must have ").append(this.base.dimension).append(" elements."))));
        }
        this.axes = new Axe[this.base.dimension];
        for (int i = 0; i < this.base.dimension; ++i) {
            this.axes[i] = new Axe(this.base, as[i], i);
        }
        this.updateBase();
    }

    public void setLegend(String[] as) {
        if (as.length != this.base.dimension) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("String array of axes names must have ").append(this.base.dimension).append(" elements."))));
        }
        for (int i = 0; i < this.axes.length; ++i) {
            this.axes[i].setName(as[i]);
        }
        this.updateBase();
    }

    public void setLegend(int i, String as) {
        this.axes[i].setName(as);
        this.updateBase();
    }

    public String[] getLegend() {
        String[] array = new String[this.axes.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.axes[i].getName();
        }
        return array;
    }

    public String getLegend(int i) {
        return this.axes[i].getName();
    }

    public void setBase(Base b) {
        this.base = b;
        this.updateBase();
    }

    public void plot(Graphics comp) {
        for (int i = 0; i < this.axes.length; ++i) {
            this.axes[i].plot(comp);
        }
    }

    public Axe getAxe(int i) {
        return this.axes[i];
    }

    public void updateBase() {
        for (int i = 0; i < this.axes.length; ++i) {
            this.axes[i].updateBase();
        }
    }
}

