/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ParametersPanel
extends JPanel
implements ActionListener {
    private Dimension defaultSize;
    private String[] paramLabels;
    private String[] paramValues;
    private boolean[] isList;
    private int[] paramValuesIndex;
    private String[][] paramChoices;
    private JLabel[] labels;
    private JComboBox[] fields;
    private Runnable action;

    public ParametersPanel(String[] lab, String[] val) {
        this(lab, new int[lab.length], new String[][]{val});
    }

    public ParametersPanel(String[] lab) {
        this(lab, new String[lab.length]);
    }

    public ParametersPanel(String[] lab, int[] selected, String[][] ch) {
        int i;
        this.paramLabels = lab;
        this.isList = new boolean[this.paramLabels.length];
        for (i = 0; i < this.isList.length; ++i) {
            this.isList[i] = true;
        }
        this.paramValuesIndex = selected;
        this.paramChoices = ch;
        this.paramValues = new String[this.paramLabels.length];
        for (i = 0; i < this.paramChoices.length; ++i) {
            this.paramValues[i] = this.paramChoices[i][this.paramValuesIndex[i]];
        }
        this.setComponents();
        this.setAppearence();
        this.draw();
    }

    public ParametersPanel(String[] lab, String[][] ch) {
        this(lab, new int[lab.length], ch);
    }

    private void setComponents() {
        this.labels = new JLabel[this.paramLabels.length];
        this.fields = new JComboBox[this.paramLabels.length];
        for (int i = 0; i < this.paramLabels.length; ++i) {
            this.labels[i] = new JLabel(this.paramLabels[i], 4);
            this.fields[i] = this.isList[i] ? new JComboBox<String>(this.paramChoices[i]) : new JComboBox();
            this.fields[i].setEditable(!this.isList[i]);
        }
        this.defaultSize = new Dimension(400, this.paramLabels.length * 30);
    }

    private void setAppearence() {
        this.setPreferredSize(this.defaultSize);
        this.setSize(this.defaultSize);
    }

    private void update() {
        this.updateValues();
        this.updateValuesIndex();
    }

    private void updateValues() {
        for (int i = 0; i < this.paramLabels.length; ++i) {
            this.paramValues[i] = (String)this.fields[i].getSelectedItem();
        }
    }

    private void updateValuesIndex() {
        for (int i = 0; i < this.paramLabels.length; ++i) {
            if (!this.isList[i]) continue;
            this.paramValuesIndex[i] = this.fields[i].getSelectedIndex();
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.update();
        new Thread(this.action, String.valueOf(String.valueOf(new StringBuffer("PanelParameters ").append(this.toString()).append(" selection")))).start();
    }

    public int getValueIndex(int i) {
        if (!this.isList[i]) {
            throw new IllegalArgumentException("This PanelParameter element is not set to give an Index.");
        }
        this.update();
        return this.paramValuesIndex[i];
    }

    public int[] getValuesIndex() {
        this.update();
        return this.paramValuesIndex;
    }

    public String[] getValues() {
        this.update();
        return this.paramValues;
    }

    public String getValue(int i) {
        this.update();
        return this.paramValues[i];
    }

    public void setAction(Runnable t) {
        this.action = t;
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    private void draw() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gbl);
        for (int i = 0; i < this.paramLabels.length; ++i) {
            this.fields[i].addActionListener(this);
            this.buildConstraints(c, 0, i, 1, 1, 50, 20);
            c.anchor = 13;
            gbl.setConstraints(this.labels[i], c);
            panel.add(this.labels[i]);
            this.buildConstraints(c, 1, i, 1, 1, 50, 20);
            c.fill = 2;
            gbl.setConstraints(this.fields[i], c);
            panel.add(this.fields[i]);
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setPreferredSize(this.getSize());
        scrollPane.setSize(this.getSize());
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
    }
}

