/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.function.expressionParser;

import java.io.Serializable;
import java.util.HashMap;
import org.jmat.data.AbstractDoubleArray;
import org.jmat.data.Matrix;
import org.jmat.data.RandomMatrix;

public class Evaluator {
    protected static Operator[] operators = null;
    private Node node = null;
    private String expression = null;
    private HashMap variables = new HashMap();

    public Evaluator() {
        this.init();
    }

    public Evaluator(String s) {
        this.init();
        this.setExpression(s);
    }

    private void init() {
        if (operators == null) {
            this.initializeOperators();
        }
    }

    public void addVariable(String v, AbstractDoubleArray val) {
        this.variables.put(v, val);
    }

    public void addVariable(String v, double val) {
        this.variables.put(v, new Double(val));
    }

    public void addVariable(String v, Double val) {
        this.variables.put(v, val);
    }

    public void setExpression(String s) {
        this.expression = s;
    }

    public void reset() {
        this.node = null;
        this.expression = null;
        this.variables = new HashMap();
    }

    public void trace() {
        try {
            this.node = new Node(this.expression);
            this.node.trace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getValue() {
        if (this.expression == null) {
            return null;
        }
        try {
            this.node = new Node(this.expression);
            Object object = Evaluator.evaluate(this.node);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            Object var2_3 = null;
            return var2_3;
        }
    }

    private static Object evaluate(Node n) {
        if (n.hasOperator() && n.hasChild()) {
            if (n.getOperator().getType() == 1) {
                n.setValue(Evaluator.evaluateExpression1(n.getOperator(), Evaluator.evaluate(n.getLeft())));
            } else if (n.getOperator().getType() == 2) {
                n.setValue(Evaluator.evaluateExpression2(n.getOperator(), Evaluator.evaluate(n.getLeft()), Evaluator.evaluate(n.getRight())));
            }
        }
        return n.getValue();
    }

    private static Object evaluateExpression1(Operator o, Object o1) {
        Serializable res;
        block2: {
            double f1;
            String op;
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            block17: {
                                                block16: {
                                                    block15: {
                                                        block0: {
                                                            Matrix f12;
                                                            block14: {
                                                                block13: {
                                                                    block12: {
                                                                        block11: {
                                                                            block10: {
                                                                                block9: {
                                                                                    block8: {
                                                                                        block7: {
                                                                                            block6: {
                                                                                                block5: {
                                                                                                    block4: {
                                                                                                        block3: {
                                                                                                            block1: {
                                                                                                                op = o.getOperator();
                                                                                                                res = null;
                                                                                                                if (!(o1 instanceof Matrix)) break block0;
                                                                                                                f12 = (Matrix)o1;
                                                                                                                if (!"t".equals(op)) break block1;
                                                                                                                res = f12.transpose();
                                                                                                                break block2;
                                                                                                            }
                                                                                                            if (!"inv".equals(op)) break block3;
                                                                                                            res = f12.inverse();
                                                                                                            break block2;
                                                                                                        }
                                                                                                        if (!"diag".equals(op)) break block4;
                                                                                                        res = f12.getDiagonal();
                                                                                                        break block2;
                                                                                                    }
                                                                                                    if (!"det".equals(op)) break block5;
                                                                                                    res = new Double(f12.determinant());
                                                                                                    break block2;
                                                                                                }
                                                                                                if (!"trace".equals(op)) break block6;
                                                                                                res = new Double(f12.trace());
                                                                                                break block2;
                                                                                            }
                                                                                            if (!"rank".equals(op)) break block7;
                                                                                            res = new Double(f12.rank());
                                                                                            break block2;
                                                                                        }
                                                                                        if (!"sum".equals(op)) break block8;
                                                                                        res = f12.sum();
                                                                                        break block2;
                                                                                    }
                                                                                    if (!"prod".equals(op)) break block9;
                                                                                    res = f12.product();
                                                                                    break block2;
                                                                                }
                                                                                if (!"min".equals(op)) break block10;
                                                                                res = f12.min();
                                                                                break block2;
                                                                            }
                                                                            if (!"max".equals(op)) break block11;
                                                                            res = f12.max();
                                                                            break block2;
                                                                        }
                                                                        if (!"mean".equals(op)) break block12;
                                                                        res = ((RandomMatrix)f12).mean();
                                                                        break block2;
                                                                    }
                                                                    if (!"cov".equals(op)) break block13;
                                                                    res = ((RandomMatrix)f12).covariance();
                                                                    break block2;
                                                                }
                                                                if (!"var".equals(op)) break block14;
                                                                res = ((RandomMatrix)f12).variance();
                                                                break block2;
                                                            }
                                                            if (!"cor".equals(op)) break block2;
                                                            res = ((RandomMatrix)f12).correlation();
                                                            break block2;
                                                        }
                                                        f1 = (Double)o1;
                                                        if (!"cos".equals(op)) break block15;
                                                        res = new Double(Math.cos(f1));
                                                        break block2;
                                                    }
                                                    if (!"sin".equals(op)) break block16;
                                                    res = new Double(Math.sin(f1));
                                                    break block2;
                                                }
                                                if (!"tan".equals(op)) break block17;
                                                res = new Double(Math.tan(f1));
                                                break block2;
                                            }
                                            if (!"acos".equals(op)) break block18;
                                            res = new Double(Math.acos(f1));
                                            break block2;
                                        }
                                        if (!"asin".equals(op)) break block19;
                                        res = new Double(Math.asin(f1));
                                        break block2;
                                    }
                                    if (!"atan".equals(op)) break block20;
                                    res = new Double(Math.atan(f1));
                                    break block2;
                                }
                                if (!"sqrt".equals(op)) break block21;
                                res = new Double(Math.sqrt(f1));
                                break block2;
                            }
                            if (!"log".equals(op)) break block22;
                            res = new Double(Math.log(f1));
                            break block2;
                        }
                        if (!"exp".equals(op)) break block23;
                        res = new Double(Math.exp(f1));
                        break block2;
                    }
                    if (!"floor".equals(op)) break block24;
                    res = new Double(Math.floor(f1));
                    break block2;
                }
                if (!"ceil".equals(op)) break block25;
                res = new Double(Math.ceil(f1));
                break block2;
            }
            if (!"abs".equals(op)) break block2;
            res = new Double(Math.abs(f1));
        }
        return res;
    }

    private static Object evaluateExpression2(Operator o, Object o1, Object o2) {
        Object res;
        block3: {
            double f2;
            double f1;
            String op;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block11: {
                                                            block10: {
                                                                block9: {
                                                                    block0: {
                                                                        double f22;
                                                                        Matrix f12;
                                                                        block8: {
                                                                            block7: {
                                                                                block6: {
                                                                                    block1: {
                                                                                        Matrix f23;
                                                                                        block5: {
                                                                                            block4: {
                                                                                                block2: {
                                                                                                    op = o.getOperator();
                                                                                                    res = null;
                                                                                                    if (!(o1 instanceof Matrix)) break block0;
                                                                                                    f12 = (Matrix)o1;
                                                                                                    if (!(o2 instanceof Matrix)) break block1;
                                                                                                    f23 = (Matrix)o2;
                                                                                                    if (!"+".equals(op)) break block2;
                                                                                                    res = f12.plus(f23);
                                                                                                    break block3;
                                                                                                }
                                                                                                if (!"-".equals(op)) break block4;
                                                                                                res = f12.minus(f23);
                                                                                                break block3;
                                                                                            }
                                                                                            if (!"*".equals(op)) break block5;
                                                                                            res = f12.times(f23);
                                                                                            break block3;
                                                                                        }
                                                                                        if (!"/".equals(op)) break block3;
                                                                                        res = f12.divide(f23);
                                                                                        break block3;
                                                                                    }
                                                                                    f22 = (Double)o2;
                                                                                    if (!"*".equals(op)) break block6;
                                                                                    res = f12.times(f22);
                                                                                    break block3;
                                                                                }
                                                                                if (!"/".equals(op)) break block7;
                                                                                res = f12.divide(f22);
                                                                                break block3;
                                                                            }
                                                                            if (!"sort".equals(op)) break block8;
                                                                            res = f12.sort(Math.round((float)f22));
                                                                            break block3;
                                                                        }
                                                                        if (!"find".equals(op)) break block3;
                                                                        res = f12.find("==", f22);
                                                                        break block3;
                                                                    }
                                                                    f1 = (Double)o1;
                                                                    if (!(o2 instanceof Matrix)) break block9;
                                                                    Matrix f24 = (Matrix)o2;
                                                                    if (!"*".equals(op)) break block3;
                                                                    res = f24.times(f1);
                                                                    break block3;
                                                                }
                                                                f2 = (Double)o2;
                                                                if (!"+".equals(op)) break block10;
                                                                res = new Double(f1 + f2);
                                                                break block3;
                                                            }
                                                            if (!"-".equals(op)) break block11;
                                                            res = new Double(f1 - f2);
                                                            break block3;
                                                        }
                                                        if (!"*".equals(op)) break block12;
                                                        res = new Double(f1 * f2);
                                                        break block3;
                                                    }
                                                    if (!"/".equals(op)) break block13;
                                                    res = new Double(f1 / f2);
                                                    break block3;
                                                }
                                                if (!"^".equals(op)) break block14;
                                                res = new Double(Math.pow(f1, f2));
                                                break block3;
                                            }
                                            if (!"%".equals(op)) break block15;
                                            res = new Double(f1 % f2);
                                            break block3;
                                        }
                                        if (!"min".equals(op)) break block16;
                                        res = new Double(Math.min(f1, f2));
                                        break block3;
                                    }
                                    if (!"max".equals(op)) break block17;
                                    res = new Double(Math.max(f1, f2));
                                    break block3;
                                }
                                if (!"&".equals(op)) break block18;
                                res = new Double(f1 > 0.0 && f2 > 0.0 ? 1 : 0);
                                break block3;
                            }
                            if (!"|".equals(op)) break block19;
                            res = new Double(f1 > 0.0 || f2 > 0.0 ? 1 : 0);
                            break block3;
                        }
                        if (!"<".equals(op)) break block20;
                        res = new Double(f1 < f2 ? 1 : 0);
                        break block3;
                    }
                    if (!">".equals(op)) break block21;
                    res = new Double(f1 > f2 ? 1 : 0);
                    break block3;
                }
                if (!"=".equals(op)) break block22;
                res = new Double(f1 == f2 ? 1 : 0);
                break block3;
            }
            if (!"E".equals(op)) break block3;
            res = new Double(f1 * Math.pow(10.0, f2));
        }
        return res;
    }

    private void initializeOperators() {
        operators = new Operator[40];
        Evaluator.operators[0] = new Operator(this, "+", 2, 0);
        Evaluator.operators[1] = new Operator(this, "-", 2, 0);
        Evaluator.operators[2] = new Operator(this, "*", 2, 10);
        Evaluator.operators[3] = new Operator(this, "/", 2, 10);
        Evaluator.operators[4] = new Operator(this, "t", 1, 20);
        Evaluator.operators[5] = new Operator(this, "inv", 1, 20);
        Evaluator.operators[6] = new Operator(this, "diag", 1, 20);
        Evaluator.operators[7] = new Operator(this, "det", 1, 20);
        Evaluator.operators[8] = new Operator(this, "trace", 1, 20);
        Evaluator.operators[9] = new Operator(this, "rank", 1, 20);
        Evaluator.operators[10] = new Operator(this, "sum", 1, 20);
        Evaluator.operators[11] = new Operator(this, "prod", 1, 20);
        Evaluator.operators[12] = new Operator(this, "min", 1, 20);
        Evaluator.operators[13] = new Operator(this, "max", 1, 20);
        Evaluator.operators[14] = new Operator(this, "mean", 1, 20);
        Evaluator.operators[15] = new Operator(this, "cov", 1, 20);
        Evaluator.operators[16] = new Operator(this, "var", 1, 20);
        Evaluator.operators[17] = new Operator(this, "cor", 1, 20);
        Evaluator.operators[18] = new Operator(this, "sort", 2, 20);
        Evaluator.operators[19] = new Operator(this, "find", 2, 20);
        Evaluator.operators[20] = new Operator(this, "%", 2, 10);
        Evaluator.operators[21] = new Operator(this, "^", 2, 10);
        Evaluator.operators[22] = new Operator(this, "cos", 1, 20);
        Evaluator.operators[23] = new Operator(this, "sin", 1, 20);
        Evaluator.operators[24] = new Operator(this, "tan", 1, 20);
        Evaluator.operators[25] = new Operator(this, "acos", 1, 20);
        Evaluator.operators[26] = new Operator(this, "asin", 1, 20);
        Evaluator.operators[27] = new Operator(this, "atan", 1, 20);
        Evaluator.operators[28] = new Operator(this, "sqrt", 1, 20);
        Evaluator.operators[29] = new Operator(this, "exp", 1, 20);
        Evaluator.operators[30] = new Operator(this, "log", 1, 20);
        Evaluator.operators[31] = new Operator(this, "floor", 1, 20);
        Evaluator.operators[32] = new Operator(this, "ceil", 1, 20);
        Evaluator.operators[33] = new Operator(this, "abs", 1, 20);
        Evaluator.operators[34] = new Operator(this, "&", 2, 10);
        Evaluator.operators[35] = new Operator(this, "|", 2, 10);
        Evaluator.operators[36] = new Operator(this, "<", 2, 10);
        Evaluator.operators[37] = new Operator(this, ">", 2, 10);
        Evaluator.operators[38] = new Operator(this, "=", 2, 10);
        Evaluator.operators[39] = new Operator(this, "E", 2, 15);
    }

    public Object getVariable(String s) {
        return this.variables.get(s);
    }

    private Object getObject(String s) {
        if (s == null) {
            return null;
        }
        Double res = null;
        try {
            res = new Double(Double.parseDouble(s));
        }
        catch (Exception e) {
            Object object = this.getVariable(s);
            return object;
        }
        return res;
    }

    protected Operator[] getOperators() {
        return operators;
    }

    protected static void _D(String s) {
        System.err.println(s);
    }

    protected class Node {
        public String nString = null;
        public Operator nOperator = null;
        public Node nLeft = null;
        public Node nRight = null;
        public Node nParent = null;
        public int nLevel = 0;
        public Object nValue = null;

        public Node(String s) throws Exception {
            this.init(null, s, 0);
        }

        public Node(Node parent, String s, int level) throws Exception {
            this.init(parent, s, level);
        }

        private void init(Node parent, String s, int level) throws Exception {
            s = this.removeIllegalCharacters(s);
            s = this.removeBrackets(s);
            if (this.checkBrackets(s = this.addZero(s)) != 0) {
                throw new Exception(String.valueOf(String.valueOf(new StringBuffer("Wrong number of brackets in [").append(s).append("]"))));
            }
            this.nParent = parent;
            this.nString = s;
            this.nValue = Evaluator.this.getObject(s);
            this.nLevel = level;
            int sLength = s.length();
            int inBrackets = 0;
            int startOperator = 0;
            for (int i = 0; i < sLength; ++i) {
                Operator o;
                if (s.charAt(i) == '(') {
                    ++inBrackets;
                    continue;
                }
                if (s.charAt(i) == ')') {
                    --inBrackets;
                    continue;
                }
                if (inBrackets != 0 || (o = this.getOperator(this.nString, i)) == null || this.nOperator != null && this.nOperator.getPriority() < o.getPriority() || this.nOperator != null && (o.getOperator().equals("-") || !this.nOperator.getOperator().equals("E"))) continue;
                this.nOperator = o;
                startOperator = i;
            }
            if (this.nOperator != null) {
                if (startOperator == 0 && this.nOperator.getType() == 1) {
                    if (this.checkBrackets(s.substring(this.nOperator.getOperator().length())) == 0) {
                        this.nLeft = new Node(this, s.substring(this.nOperator.getOperator().length()), this.nLevel + 1);
                        this.nRight = null;
                        return;
                    }
                    throw new Exception(String.valueOf(String.valueOf(new StringBuffer("Error during parsing... missing brackets in [").append(s).append("]"))));
                }
                if (startOperator > 0 && this.nOperator.getType() == 2) {
                    this.nOperator = this.nOperator;
                    this.nLeft = new Node(this, s.substring(0, startOperator), this.nLevel + 1);
                    this.nRight = new Node(this, s.substring(startOperator + this.nOperator.getOperator().length()), this.nLevel + 1);
                }
            }
        }

        private Operator getOperator(String s, int start) {
            Operator[] operators = Evaluator.this.getOperators();
            String temp = s.substring(start);
            temp = this.getNextWord(temp);
            for (int i = 0; i < operators.length; ++i) {
                if (!temp.startsWith(operators[i].getOperator())) continue;
                return operators[i];
            }
            return null;
        }

        private String getNextWord(String s) {
            int sLength = s.length();
            for (int i = 1; i < sLength; ++i) {
                char c = s.charAt(i);
                if (c <= 'z' && c >= 'a' || c <= '9' && c >= '0' || c == '-') continue;
                return s.substring(0, i);
            }
            return s;
        }

        protected int checkBrackets(String s) {
            int sLength = s.length();
            int inBracket = 0;
            for (int i = 0; i < sLength; ++i) {
                if (s.charAt(i) == '(' && inBracket >= 0) {
                    ++inBracket;
                    continue;
                }
                if (s.charAt(i) != ')') continue;
                --inBracket;
            }
            return inBracket;
        }

        protected String addZero(String s) {
            if (s.startsWith("+") || s.startsWith("-")) {
                int sLength = s.length();
                for (int i = 0; i < sLength; ++i) {
                    if (this.getOperator(s, i) == null) continue;
                    return "0".concat(String.valueOf(String.valueOf(s)));
                }
            }
            return s;
        }

        public void trace() {
            String op = this.getOperator() == null ? " " : this.getOperator().getOperator();
            this._D(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(op))).append(" : ").append(this.getString()))));
            if (this.hasChild()) {
                if (this.hasLeft()) {
                    this.getLeft().trace();
                }
                if (this.hasRight()) {
                    this.getRight().trace();
                }
            }
        }

        protected boolean hasChild() {
            return this.nLeft != null || this.nRight != null;
        }

        protected boolean hasOperator() {
            return this.nOperator != null;
        }

        protected boolean hasLeft() {
            return this.nLeft != null;
        }

        protected Node getLeft() {
            return this.nLeft;
        }

        protected boolean hasRight() {
            return this.nRight != null;
        }

        protected Node getRight() {
            return this.nRight;
        }

        protected Operator getOperator() {
            return this.nOperator;
        }

        protected int getLevel() {
            return this.nLevel;
        }

        protected Object getValue() {
            return this.nValue;
        }

        protected void setValue(Object f) {
            this.nValue = f;
        }

        protected String getString() {
            return this.nString;
        }

        public String removeBrackets(String s) {
            String res = s;
            if (s.length() > 2 && res.startsWith("(") && res.endsWith(")") && this.checkBrackets(s.substring(1, s.length() - 1)) == 0) {
                res = res.substring(1, res.length() - 1);
            }
            if (res != s) {
                return this.removeBrackets(res);
            }
            return res;
        }

        public String removeIllegalCharacters(String s) {
            char[] illegalCharacters = new char[]{' '};
            String res = s;
            for (int j = 0; j < illegalCharacters.length; ++j) {
                int i = res.lastIndexOf(illegalCharacters[j], res.length());
                while (i != -1) {
                    String temp = res;
                    res = temp.substring(0, i);
                    res = String.valueOf(String.valueOf(res)).concat(String.valueOf(String.valueOf(temp.substring(i + 1))));
                    i = res.lastIndexOf(illegalCharacters[j], s.length());
                }
            }
            return res;
        }

        protected void _D(String s) {
            String nbSpaces = "";
            for (int i = 0; i < this.nLevel; ++i) {
                nbSpaces = String.valueOf(String.valueOf(nbSpaces)).concat("  ");
            }
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(nbSpaces))).append("|").append(s))));
        }
    }

    protected class Operator {
        private String op;
        private int type;
        private int priority;

        public Operator(Evaluator this$0, String o, int t, int p) {
            this.op = o;
            this.type = t;
            this.priority = p;
        }

        public String getOperator() {
            return this.op;
        }

        public void setOperator(String o) {
            this.op = o;
        }

        public int getType() {
            return this.type;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

