/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.data.matrixTools;

import java.util.Vector;
import org.jmat.data.AbstractMatrix;

public class Shuffle {
    private int numOE;
    private int[] order;

    public Shuffle(int n) {
        this.numOE = n;
        this.order = this.shuffle(this.numOE);
    }

    public int getOrder(int i) {
        return this.order[i];
    }

    public int[] getOrder() {
        return this.order;
    }

    public static double[] Array(double[] X) {
        double[] Y = new double[X.length];
        Shuffle s = new Shuffle(X.length);
        for (int i = 0; i < X.length; ++i) {
            Y[i] = X[s.getOrder(i)];
        }
        return Y;
    }

    public static AbstractMatrix MatrixRows(AbstractMatrix X) {
        Shuffle s = new Shuffle(X.getRowDimension());
        return X.getRows(s.getOrder());
    }

    public static AbstractMatrix MatrixColumns(AbstractMatrix X) {
        Shuffle s = new Shuffle(X.getColumnDimension());
        return X.getColumns(s.getOrder());
    }

    public static AbstractMatrix MatrixElements(AbstractMatrix X) {
        AbstractMatrix Y = Shuffle.MatrixRows(X.reshapeRows(X.getRowDimension() * X.getColumnDimension(), 1));
        return Y.reshapeRows(X.getRowDimension(), X.getColumnDimension());
    }

    private int[] shuffle(int numOE) {
        Vector<Integer> order_in = new Vector<Integer>();
        for (int i = 0; i < numOE; ++i) {
            order_in.add(i, new Integer(i));
        }
        Vector<Integer> v_order_out = new Vector<Integer>();
        for (int i = 0; i < numOE; ++i) {
            int ind = Shuffle.randInt(order_in.size() - 1);
            Integer val = (Integer)order_in.remove(ind);
            v_order_out.add(val);
        }
        return this.vectorToArray(v_order_out);
    }

    private int[] vectorToArray(Vector v) {
        int[] array = new int[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            array[i] = (Integer)v.get(i);
        }
        return array;
    }

    public static void main(String[] args) {
        Shuffle s = new Shuffle(10);
        for (int i = 0; i < 10; ++i) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i))).append(" -> ").append(s.getOrder(i)))));
        }
    }

    private static int randInt(int i) {
        double x = Math.random();
        int r = (int)Math.floor((double)(i + 1) * x);
        return r;
    }
}

