/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.data.matrixTools;

import java.util.Vector;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.io.CommandLinePrintable;

public class Finding
implements CommandLinePrintable {
    private AbstractMatrix A;
    private int[][] index;
    private double value;
    private double min;
    private double max;
    private String test;

    public Finding(AbstractMatrix a, double min, double max) {
        this.A = a;
        this.max = max;
        this.min = min;
        this.index = this.find(this.A, min, max);
    }

    public Finding(AbstractMatrix a, String t, double v) {
        this.A = a;
        this.value = v;
        this.test = t;
        this.index = this.find(this.A, this.test, this.value);
    }

    public int[][] getIndex() {
        return this.index;
    }

    public AbstractMatrix getIndexMatrix() {
        Matrix ind = new Matrix(this.index.length, 2);
        for (int i = 0; i < this.index.length; ++i) {
            ind.set(i, 0, this.index[i][0]);
            ind.set(i, 1, this.index[i][1]);
        }
        return ind;
    }

    public AbstractMatrix getBooleanMatrix() {
        Matrix M = new Matrix(this.A.getRowDimension(), this.A.getColumnDimension());
        for (int i = 0; i < this.index.length; ++i) {
            M.set(this.index[i][0], this.index[i][1], 1.0);
        }
        return M;
    }

    public boolean isFound(int I, int J) {
        for (int i = 0; i < this.index.length; ++i) {
            if (this.index[i][0] != I || this.index[i][1] != J) continue;
            return true;
        }
        return false;
    }

    public static AbstractMatrix BooleanMatrix(AbstractMatrix A, double min, double max) {
        Finding f = new Finding(A, min, max);
        return f.getBooleanMatrix();
    }

    public static AbstractMatrix BooleanMatrix(AbstractMatrix A, String test, double value) {
        Finding f = new Finding(A, test, value);
        return f.getBooleanMatrix();
    }

    public static AbstractMatrix IndexMatrix(AbstractMatrix A, double min, double max) {
        Finding f = new Finding(A, min, max);
        return f.getIndexMatrix();
    }

    public static AbstractMatrix IndexMatrix(AbstractMatrix A, String test, double value) {
        Finding f = new Finding(A, test, value);
        return f.getIndexMatrix();
    }

    private int[][] find(AbstractMatrix a, double min, double max) {
        int m = a.getRowDimension();
        int n = a.getColumnDimension();
        Vector<int[]> ind = new Vector<int[]>();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!(a.get(i, j) >= min) || !(a.get(i, j) <= max)) continue;
                ind.add(new int[]{i, j});
            }
        }
        return this.vectorToArray2D(ind);
    }

    private int[][] find(AbstractMatrix a, String t, double v) {
        if (t.equals("==")) {
            return this.findEqual(a, v);
        }
        if (t.equals("<=")) {
            return this.findInfEqual(a, v);
        }
        if (t.equals(">=")) {
            return this.findSupEqual(a, v);
        }
        if (t.equals("<")) {
            return this.findInf(a, v);
        }
        if (t.equals(">")) {
            return this.findSup(a, v);
        }
        if (t.equals("!=")) {
            return this.findDiff(a, v);
        }
        throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Test String ").append(t).append(" is unknown."))));
    }

    private int[][] findEqual(AbstractMatrix a, double v) {
        int m = a.getRowDimension();
        int n = a.getColumnDimension();
        Vector<int[]> ind = new Vector<int[]>();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (a.get(i, j) != v) continue;
                ind.add(new int[]{i, j});
            }
        }
        return this.vectorToArray2D(ind);
    }

    private int[][] findInfEqual(AbstractMatrix a, double v) {
        int m = a.getRowDimension();
        int n = a.getColumnDimension();
        Vector<int[]> ind = new Vector<int[]>();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!(a.get(i, j) <= v)) continue;
                ind.add(new int[]{i, j});
            }
        }
        return this.vectorToArray2D(ind);
    }

    private int[][] findSupEqual(AbstractMatrix a, double v) {
        int m = a.getRowDimension();
        int n = a.getColumnDimension();
        Vector<int[]> ind = new Vector<int[]>();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!(a.get(i, j) >= v)) continue;
                ind.add(new int[]{i, j});
            }
        }
        return this.vectorToArray2D(ind);
    }

    private int[][] findInf(AbstractMatrix a, double v) {
        int m = a.getRowDimension();
        int n = a.getColumnDimension();
        Vector<int[]> ind = new Vector<int[]>();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!(a.get(i, j) < v)) continue;
                ind.add(new int[]{i, j});
            }
        }
        return this.vectorToArray2D(ind);
    }

    private int[][] findSup(AbstractMatrix a, double v) {
        int m = a.getRowDimension();
        int n = a.getColumnDimension();
        Vector<int[]> ind = new Vector<int[]>();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!(a.get(i, j) > v)) continue;
                ind.add(new int[]{i, j});
            }
        }
        return this.vectorToArray2D(ind);
    }

    private int[][] findDiff(AbstractMatrix a, double v) {
        int m = a.getRowDimension();
        int n = a.getColumnDimension();
        Vector<int[]> ind = new Vector<int[]>();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (a.get(i, j) == v) continue;
                ind.add(new int[]{i, j});
            }
        }
        return this.vectorToArray2D(ind);
    }

    private int[][] vectorToArray2D(Vector v) {
        int[][] array2d = new int[v.size()][2];
        for (int i = 0; i < v.size(); ++i) {
            int[] tmp = (int[])v.get(i);
            array2d[i][0] = tmp[0];
            array2d[i][1] = tmp[1];
        }
        return array2d;
    }

    public static void main(String[] args) {
        Matrix a = Matrix.random(5, 5);
        a.toCommandLine("a");
        Finding f = new Finding((AbstractMatrix)a, ">=", 0.5);
        f.toCommandLine("find");
        f.getBooleanMatrix().toCommandLine("bolean matrix");
    }

    public void toCommandLine(String title) {
        System.out.println(title);
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("test : ").append(this.test).append(" ").append(this.value))));
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("min = ").append(this.min).append(" max = ").append(this.max))));
        for (int i = 0; i < this.index.length; ++i) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.index[i][0]))).append(" ").append(this.index[i][1]))));
        }
    }
}

