/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.data.matrixDecompositions;

import java.io.Serializable;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;

public class CholeskyDecomposition
implements Serializable {
    private double[][] L;
    private int n;
    private boolean isspd;

    public CholeskyDecomposition(AbstractMatrix Arg) {
        this.n = Arg.getRowDimension();
        this.L = new double[this.n][this.n];
        this.isspd = Arg.getColumnDimension() == this.n;
        for (int j = 0; j < this.n; ++j) {
            int k;
            double[] Lrowj = this.L[j];
            double d = 0.0;
            for (k = 0; k < j; ++k) {
                double[] Lrowk = this.L[k];
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += Lrowk[i] * Lrowj[i];
                }
                Lrowj[k] = s = (Arg.get(j, k) - s) / this.L[k][k];
                d += s * s;
                this.isspd = this.isspd && Arg.get(k, j) == Arg.get(j, k);
            }
            d = Arg.get(j, j) - d;
            this.isspd = this.isspd && d > 0.0;
            this.L[j][j] = Math.sqrt(Math.max(d, 0.0));
            for (k = j + 1; k < this.n; ++k) {
                this.L[j][k] = 0.0;
            }
        }
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public AbstractMatrix getL() {
        return new Matrix(this.L);
    }

    public AbstractMatrix solve(AbstractMatrix B) {
        int j;
        int j2;
        int i;
        int k;
        if (B.getRowDimension() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] X = B.toDouble2DArray();
        int nx = B.getColumnDimension();
        for (k = 0; k < this.n; ++k) {
            for (i = k + 1; i < this.n; ++i) {
                for (j2 = 0; j2 < nx; ++j2) {
                    double[] dArray = X[i];
                    int n = j2;
                    dArray[n] = dArray[n] - X[k][j2] * this.L[i][k];
                }
            }
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.L[k][k];
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.L[k][k];
            }
            for (i = 0; i < k; ++i) {
                for (j2 = 0; j2 < nx; ++j2) {
                    double[] dArray = X[i];
                    int n = j2;
                    dArray[n] = dArray[n] - X[k][j2] * this.L[k][i];
                }
            }
        }
        return new Matrix(X);
    }
}

