/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.data;

import java.util.Vector;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;

public class SparseMatrix
extends AbstractMatrix {
    private Vector elements = new Vector();

    public SparseMatrix(int _m, int _n) {
        super(_m, _n);
    }

    public AbstractMatrix getInstance(int _m, int _n) {
        return new SparseMatrix(_m, _n);
    }

    private Element search(int i, int j) {
        if (i > this.m || j > this.n) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Index (").append(i).append(",").append(j).append(") not available"))));
        }
        if (this.elements.size() == 0) {
            return null;
        }
        for (int _i = 0; _i < this.elements.size(); ++_i) {
            Element e = (Element)this.elements.get(_i);
            if (!e.is(i, j)) continue;
            return e;
        }
        return null;
    }

    public double get(int i, int j) {
        Element e = this.search(i, j);
        if (e == null) {
            return 0.0;
        }
        return e.getValue();
    }

    public void set(int i, int j, double s) {
        Element e = this.search(i, j);
        if (e == null) {
            this.elements.add(new Element(this, i, j, s, this));
        } else {
            e.setValue(s);
        }
    }

    protected void reset(int m2, int n2) {
        this.m = m2;
        this.n = n2;
        this.elements = new Vector();
    }

    public static void main(String[] args) {
        SparseMatrix sm = new SparseMatrix(10, 10);
        sm.set(5, 2, 1.0);
        sm.set(0, 0, 2.0);
        sm.toCommandLine("sm");
        sm.insertRows(3, Matrix.random(2, 10)).toCommandLine("");
    }

    private class Element {
        private SparseMatrix matrix;
        private int i;
        private int j;
        private double val;

        public Element(SparseMatrix this$0, int _i, int _j, double _v, SparseMatrix m) {
            this.matrix = m;
            this.i = _i;
            this.j = _j;
            this.val = _v;
        }

        public void setValue(double _v) {
            this.val = _v;
        }

        public void setRow(int _i) {
            this.i = _i;
        }

        public void setColumn(int _j) {
            this.j = _j;
        }

        public double getValue() {
            return this.val;
        }

        public int getRow() {
            return this.i;
        }

        public int getColumn() {
            return this.j;
        }

        public boolean is(int _i, int _j) {
            return this.i == _i && this.j == _j;
        }
    }
}

