/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.data;

import org.jmat.data.AbstractDoubleArray;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;

public class LightMatrix
extends AbstractMatrix {
    private float[][] A;

    public AbstractMatrix getInstance(int _m, int _n) {
        return new Matrix(_m, _n);
    }

    public LightMatrix(int _m, int _n) {
        super(_m, _n);
        this.A = new float[this.m][this.n];
    }

    public LightMatrix(int _m, int _n, double s) {
        this(_m, _n);
        this.setAllConstant(s);
    }

    public LightMatrix(double[][] _A) {
        this(_A.length, _A[0].length);
        for (int i = 0; i < this.m; ++i) {
            if (_A[i].length != this.n) {
                throw new IllegalArgumentException("All rows must have the same length : ".concat(String.valueOf(String.valueOf(this.n))));
            }
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, _A[i][j]);
            }
        }
    }

    public LightMatrix(double[] vals, int _m) {
        super(_m, vals.length / _m);
        if (this.m * this.n != vals.length) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Array length = ").append(vals.length).append(" but must be a multiple of ").append(this.m))));
        }
        this.A = new float[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, vals[i + j * this.m]);
            }
        }
    }

    public static Matrix random(int m, int n) {
        Matrix X = new Matrix(m, n);
        X.setAllRandom();
        return X;
    }

    public static Matrix identity(int m, int n) {
        Matrix X = new Matrix(m, n);
        X.setAllIdentity();
        return X;
    }

    public static Matrix diagonal(double[] d) {
        Matrix X = new Matrix(d.length, d.length);
        X.setAllDiagonal(d);
        return X;
    }

    public static Matrix incrementRows(int m, int n, double begin, double pitch) {
        Matrix X = new Matrix(m, n);
        X.setAllIncrementRows(begin, pitch);
        return X;
    }

    public static Matrix incrementRows(int m, int n, double[] begin, double[] pitch) {
        Matrix X = new Matrix(m, n);
        X.setAllIncrementRows(begin, pitch);
        return X;
    }

    public static Matrix incrementColumns(int m, int n, double begin, double pitch) {
        Matrix X = new Matrix(m, n);
        X.setAllIncrementColumns(begin, pitch);
        return X;
    }

    public static Matrix incrementColumns(int m, int n, double[] begin, double[] pitch) {
        Matrix X = new Matrix(m, n);
        X.setAllIncrementColumns(begin, pitch);
        return X;
    }

    public static Matrix mergeRows(AbstractDoubleArray[] Xs) {
        int M = 0;
        for (int i = 0; i < Xs.length; ++i) {
            M += Xs[i].getRowDimension();
        }
        Matrix X = new Matrix(M, Xs[0].getColumnDimension());
        X.setAllMergeRows(Xs);
        return X;
    }

    public static Matrix mergeColumns(AbstractDoubleArray[] Xs) {
        int N = 0;
        for (int i = 0; i < Xs.length; ++i) {
            N += Xs[i].getColumnDimension();
        }
        Matrix X = new Matrix(Xs[0].getRowDimension(), N);
        X.setAllMergeColumns(Xs);
        return X;
    }

    public double get(int i, int j) {
        try {
            double d = this.A[i][j];
            return d;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Index (").append(i).append(",").append(j).append(") not available"))));
        }
    }

    public void set(int i, int j, double s) {
        try {
            this.A[i][j] = (float)s;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Index (").append(i).append(",").append(j).append(") not available"))));
        }
    }

    public void reset(int m2, int n2) {
        this.m = m2;
        this.n = n2;
        this.A = new float[this.m][this.n];
    }
}

