/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.data;

import java.io.Serializable;

public abstract class AbstractDoubleArray
implements Cloneable,
Serializable {
    protected int m;
    protected int n;

    public AbstractDoubleArray(int _m, int _n) {
        this.m = _m;
        this.n = _n;
    }

    public abstract AbstractDoubleArray getDoubleArrayCopy();

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public abstract double get(int var1, int var2);

    public abstract void set(int var1, int var2, double var3);

    public void setSubMatrix(int i0, int j0, AbstractDoubleArray X) {
        for (int i = i0; i < i0 + X.m; ++i) {
            for (int j = j0; j < j0 + X.n; ++j) {
                this.set(i, j, X.get(i - i0, j - j0));
            }
        }
    }

    public void setSubMatrix(int i0, int i1, int j0, int j1, double v) {
        for (int i = i0; i <= i1; ++i) {
            for (int j = j0; j <= j1; ++j) {
                this.set(i, j, v);
            }
        }
    }

    public void setRow(int i, AbstractDoubleArray B) {
        B.checkDimensions(1, this.n);
        for (int j = 0; j < this.n; ++j) {
            this.set(i, j, B.get(0, j));
        }
    }

    public void setRow(int i, double B) {
        for (int j = 0; j < this.n; ++j) {
            this.set(i, j, B);
        }
    }

    public void setRows(int[] I, AbstractDoubleArray B) {
        B.checkDimensions(I.length, this.n);
        for (int i = 0; i < I.length; ++i) {
            int j = 0;
            while (j < B.getColumnDimension()) {
                this.set(I[i], j, B.get(i, j));
                ++i;
            }
        }
    }

    public void setRows(int i0, AbstractDoubleArray B) {
        this.checkColumnDimension(B);
        for (int i = 0; i < B.getRowDimension(); ++i) {
            int j = 0;
            while (j < B.getColumnDimension()) {
                this.set(i + i0, j, B.get(i, j));
                ++i;
            }
        }
    }

    public void setColumn(int j, AbstractDoubleArray B) {
        B.checkDimensions(this.m, 1);
        for (int i = 0; i < this.m; ++i) {
            this.set(i, j, B.get(i, 0));
        }
    }

    public void setColumn(int j, double B) {
        for (int i = 0; i < this.m; ++i) {
            this.set(i, j, B);
        }
    }

    public void setColumns(int[] J, AbstractDoubleArray B) {
        B.checkDimensions(this.m, J.length);
        for (int j = 0; j < J.length; ++j) {
            for (int i = 0; i < B.getRowDimension(); ++i) {
                this.set(i, J[j], B.get(i, j));
            }
        }
    }

    public void setColumns(int j0, AbstractDoubleArray B) {
        this.checkRowDimension(B);
        for (int j = 0; j < B.getColumnDimension(); ++j) {
            for (int i = 0; i < B.getRowDimension(); ++i) {
                this.set(i, j + j0, B.get(i, j));
            }
        }
    }

    protected void setAllRandom() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, Math.random());
            }
        }
    }

    protected void setAllConstant(double v) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, v);
            }
        }
    }

    protected void setAllDiagonal(double[] d) {
        int i;
        if (d.length != this.m || d.length != this.n) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("The diagonal length : ").append(d.length).append(" is incompatible with matrix size : (").append(this.m).append(",").append(this.n).append(")"))));
        }
        for (i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, 0.0);
            }
        }
        for (i = 0; i < Math.min(this.m, this.n); ++i) {
            this.set(i, i, d[i]);
        }
    }

    protected void setAllIdentity() {
        int i;
        for (i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, 0.0);
            }
        }
        for (i = 0; i < Math.min(this.m, this.n); ++i) {
            this.set(i, i, 1.0);
        }
    }

    protected void setAllIncrementRows(double begin, double pitch) {
        for (int i = 0; i < this.m; ++i) {
            this.setRow(i, begin + (double)i * pitch);
        }
    }

    protected void setAllIncrementRows(double[] begin, double[] pitch) {
        if (begin.length != this.n || pitch.length != this.n) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("The lengths : ").append(begin.length).append(",").append(pitch.length).append(" are incompatible with matrix columns size : ").append(this.n))));
        }
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, begin[i] + (double)i * pitch[i]);
            }
        }
    }

    protected void setAllIncrementColumns(double begin, double pitch) {
        for (int j = 0; j < this.n; ++j) {
            this.setColumn(j, begin + (double)j * pitch);
        }
    }

    protected void setAllIncrementColumns(double[] begin, double[] pitch) {
        if (begin.length != this.n || pitch.length != this.n) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("The lengths : ").append(begin.length).append(",").append(pitch.length).append(" are incompatible with matrix rows size : ").append(this.m))));
        }
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, begin[j] + (double)j * pitch[j]);
            }
        }
    }

    protected void setAllMergeRows(AbstractDoubleArray[] Xs) {
        int N = Xs[0].n;
        int M = 0;
        for (int k = 0; k < Xs.length; ++k) {
            M += Xs[k].m;
        }
        this.checkDimensions(M, N);
        int ind = 0;
        for (int k = 0; k < Xs.length; ++k) {
            for (int i = 0; i < Xs[k].m; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    this.set(i + ind, j, Xs[k].get(i, j));
                }
            }
            ind += Xs[k].m;
        }
    }

    protected void setAllMergeColumns(AbstractDoubleArray[] Xs) {
        int M = Xs[0].m;
        int N = 0;
        for (int k = 0; k < Xs.length; ++k) {
            N += Xs[k].n;
        }
        this.checkDimensions(M, N);
        int ind = 0;
        for (int k = 0; k < Xs.length; ++k) {
            for (int i = 0; i < this.m; ++i) {
                for (int j = 0; j < Xs[k].n; ++j) {
                    this.set(i, j + ind, Xs[k].get(i, j));
                }
            }
            ind += Xs[k].n;
        }
    }

    protected void putSubMatrixIn(int i0, int i1, int j0, int j1, AbstractDoubleArray X) {
        for (int i = i0; i <= i1; ++i) {
            for (int j = j0; j <= j1; ++j) {
                X.set(i - i0, j - j0, this.get(i, j));
            }
        }
    }

    protected void putRowIn(int i, AbstractDoubleArray X) {
        for (int j = 0; j < this.n; ++j) {
            X.set(0, j, this.get(i, j));
        }
    }

    protected void putRowsIn(int[] I, AbstractDoubleArray X) {
        for (int i = 0; i < I.length; ++i) {
            for (int j = 0; j < this.n; ++j) {
                X.set(i, j, this.get(I[i], j));
            }
        }
    }

    protected void putRowsIn(int i0, int i1, AbstractDoubleArray X) {
        for (int i = 0; i < i1 - i0 + 1; ++i) {
            for (int j = 0; j < this.n; ++j) {
                X.set(i, j, this.get(i0 + i, j));
            }
        }
    }

    protected void putColumnIn(int j, AbstractDoubleArray X) {
        for (int i = 0; i < this.m; ++i) {
            X.set(i, 0, this.get(i, j));
        }
    }

    protected void putColumnsIn(int[] J, AbstractDoubleArray X) {
        for (int j = 0; j < J.length; ++j) {
            for (int i = 0; i < this.m; ++i) {
                X.set(i, j, this.get(i, J[j]));
            }
        }
    }

    protected void putColumnsIn(int j0, int j1, AbstractDoubleArray X) {
        for (int j = 0; j < j1 - j0 + 1; ++j) {
            for (int i = 0; i < this.m; ++i) {
                X.set(i, j, this.get(i, j0 + j));
            }
        }
    }

    protected void putDiagonalIn(AbstractDoubleArray X) {
        int d = Math.min(this.m, this.n);
        for (int i = 0; i < d; ++i) {
            X.set(i, 0, this.get(i, i));
        }
    }

    protected void putDiagonalIn(int num, AbstractDoubleArray X) {
        int l = 0;
        l = this.n < this.m ? (num >= 0 ? this.n - num : (num < this.n - this.m ? this.m + num : this.n)) : (num <= 0 ? this.m + num : (num > this.n - this.m ? this.n - num : this.m));
        for (int i = 0; i < l; ++i) {
            X.set(i, 0, num > 0 ? this.get(i, i + num) : this.get(i - num, i));
        }
    }

    protected abstract void reset(int var1, int var2);

    public void resizeEquals(int m2, int n2) {
        AbstractDoubleArray X = this.getDoubleArrayCopy();
        this.reset(m2, n2);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, i < X.getRowDimension() && j < X.getColumnDimension() ? X.get(i, j) : 0.0);
            }
        }
    }

    public void reshapeRowsEquals(int m2, int n2) {
        if (m2 * n2 != this.m * this.n) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("New matrix dimensions product ").append(m2).append("*").append(n2).append(" must equals ").append(this.m).append("*").append(this.n))));
        }
        AbstractDoubleArray X = this.getDoubleArrayCopy();
        this.reset(m2, n2);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                int i2 = (int)Math.floor((double)(j + this.n * i) / (double)X.n);
                int j2 = (int)((double)(j + this.n * i) - (double)(X.n * i2));
                this.set(i, j, X.get(i2, j2));
            }
        }
    }

    public void reshapeColumnsEquals(int m2, int n2) {
        if (m2 * n2 != this.m * this.n) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("New matrix dimensions product ").append(m2).append("*").append(n2).append(" must equals ").append(this.m).append("*").append(this.n))));
        }
        AbstractDoubleArray X = this.getDoubleArrayCopy();
        this.reset(m2, n2);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                int j2 = (int)Math.floor((i + this.m * j) / X.m);
                int i2 = i + this.m * j - X.m * j2;
                this.set(i, j, X.get(i2, j2));
            }
        }
    }

    public void mergeRowsEquals(AbstractDoubleArray B) {
        this.checkColumnDimension(B);
        int old_m = this.m;
        this.resizeEquals(this.m + B.m, this.n);
        for (int i = 0; i < B.m; ++i) {
            for (int j = 0; j < B.n; ++j) {
                this.set(old_m + i, j, B.get(i, j));
            }
        }
    }

    public void mergeColumnsEquals(AbstractDoubleArray B) {
        this.checkRowDimension(B);
        int old_n = this.n;
        this.resizeEquals(this.m, this.n + B.n);
        for (int i = 0; i < B.m; ++i) {
            for (int j = 0; j < B.n; ++j) {
                this.set(i, old_n + j, B.get(i, j));
            }
        }
    }

    public void insertRowsEquals(int I, AbstractDoubleArray B) {
        int j;
        int i;
        this.checkColumnDimension(B);
        this.resizeEquals(this.m + B.m, this.n);
        for (i = this.m - 1; i >= I + B.m; --i) {
            for (j = 0; j < this.n; ++j) {
                this.set(i, j, this.get(i - B.m, j));
            }
        }
        for (i = 0; i < B.m; ++i) {
            for (j = 0; j < this.n; ++j) {
                this.set(i + I, j, B.get(i, j));
            }
        }
    }

    public void insertColumnsEquals(int J, AbstractDoubleArray B) {
        int j;
        int i;
        this.checkRowDimension(B);
        this.resizeEquals(this.m, this.n + B.n);
        for (i = 0; i < this.n; ++i) {
            for (j = this.n - 1; j >= J + B.n; --j) {
                this.set(i, j, this.get(i, j - B.n));
            }
        }
        for (i = 0; i < this.n; ++i) {
            for (j = 0; j < B.n; ++j) {
                this.set(i, j + J, B.get(i, j));
            }
        }
    }

    public void deleteRowEquals(int I) {
        for (int i = I; i < this.m - 1; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, this.get(i + 1, j));
            }
        }
        this.resizeEquals(this.m - 1, this.n);
    }

    public void deleteColumnEquals(int J) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = J; j < this.n - 1; ++j) {
                this.set(i, j, this.get(i, j + 1));
            }
        }
        this.resizeEquals(this.m, this.n - 1);
    }

    public void deleteRowsEquals(int[] I) {
        for (int i = 0; i < I.length; ++i) {
            this.deleteRowEquals(I[i]);
        }
    }

    public void deleteRowsEquals(int i0, int i1) {
        for (int i = i0; i < i1; ++i) {
            this.deleteRowEquals(i);
        }
    }

    public void deleteColumnsEquals(int[] J) {
        for (int j = 0; j < J.length; ++j) {
            this.deleteColumnEquals(J[j]);
        }
    }

    public void deleteColumnsEquals(int j0, int j1) {
        for (int j = j0; j < j1; ++j) {
            this.deleteColumnEquals(j);
        }
    }

    public double toDouble() {
        this.checkDimensions(1, 1);
        return this.get(0, 0);
    }

    public double[] toDoubleArray() {
        if (this.n == 1) {
            return this.toDoubleColumnArray(0);
        }
        if (this.m == 1) {
            return this.toDoubleRowArray(0);
        }
        throw new IllegalArgumentException("Matrix Columns or Rows dimensions must equals 1");
    }

    public double[][] toDouble2DArray() {
        double[][] C = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.get(i, j);
            }
        }
        return C;
    }

    public double[][] getArrayCopy() {
        return this.toDouble2DArray();
    }

    public double[] toDoubleRowArray(int i) {
        double[] C = new double[this.n];
        for (int j = 0; j < this.n; ++j) {
            C[j] = this.get(i, j);
        }
        return C;
    }

    public double[] getRowArrayCopy(int i) {
        return this.toDoubleRowArray(i);
    }

    public double[] toDoubleColumnArray(int j) {
        double[] C = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            C[i] = this.get(i, j);
        }
        return C;
    }

    public double[] getColumnArrayCopy(int j) {
        return this.toDoubleColumnArray(j);
    }

    public boolean isEqual(AbstractDoubleArray B) {
        this.checkDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.get(i, j) == B.get(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDiagonal() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.get(i, j) == 0.0 || i == j) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymetric() {
        this.checkColumnDimension(this.m);
        for (int i = 0; i < this.m; ++i) {
            for (int j = i + 1; j < this.n; ++j) {
                if (this.get(i, j) == this.get(j, i)) continue;
                return false;
            }
        }
        return true;
    }

    public void checkDiagonal() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.get(i, j) == 0.0 || i == j) continue;
                throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Matrix is not diagonal : element (").append(i).append(",").append(j).append(") is not null."))));
            }
        }
    }

    public void checkSymetric() {
        this.checkColumnDimension(this.m);
        for (int i = 0; i < this.m; ++i) {
            for (int j = i + 1; j < this.n; ++j) {
                if (this.get(i, j) == this.get(j, i)) continue;
                throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Matrix is not symetrix at (").append(i).append(",").append(j).append(")."))));
            }
        }
    }

    public void checkDimensions(AbstractDoubleArray B) {
        this.checkDimensions(B.m, B.n);
    }

    public void checkDimensions(int m2, int n2) {
        if (m2 != this.m || n2 != this.n) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Bad matrix dimensions : expected = (").append(m2).append(",").append(n2).append("), found = (").append(this.m).append(",").append(this.n).append(")"))));
        }
    }

    public void checkRowDimension(AbstractDoubleArray B) {
        this.checkRowDimension(B.m);
    }

    public void checkRowDimension(int row) {
        if (row != this.m) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Bad matrix rows dimensions : expected = ").append(row).append(", found = ").append(this.m))));
        }
    }

    public void checkColumnDimension(AbstractDoubleArray B) {
        this.checkColumnDimension(B.n);
    }

    public void checkColumnDimension(int column) {
        if (column != this.n) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("Bad matrix columns dimensions : expected = ").append(column).append(", found = ").append(this.n))));
        }
    }
}

