/*
 * Decompiled with CFR 0.152.
 */
package org.jmat;

import java.io.File;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.data.RandomMatrix;
import org.jmat.data.matrixTools.Sorting;
import org.jmat.gui.FrameView;
import org.jmat.gui.Plot2DPanel;
import org.jmat.gui.Plot3DPanel;

public class MatlabSyntax {
    protected long t;

    public static Matrix zeros(int m, int n) {
        return new Matrix(m, n);
    }

    public static Matrix ones(int m, int n) {
        return new Matrix(m, n, 1.0);
    }

    public static Matrix matrix(int m, int n, double s) {
        return new Matrix(m, n, s);
    }

    public static Matrix matrix(double[][] B) {
        return new Matrix(B);
    }

    public static RandomMatrix normRnd(double mu, double sigma, int m, int n) {
        return RandomMatrix.normal(m, n, mu, sigma);
    }

    public static RandomMatrix expRnd(double mu, int m, int n) {
        return RandomMatrix.exponential(m, n, mu);
    }

    public static RandomMatrix unifRnd(int m, int n, double min, double max) {
        return RandomMatrix.uniform(m, n, min, max);
    }

    public static RandomMatrix triangRnd(int m, int n, double min, double mod, double max) {
        return RandomMatrix.triangular(m, n, min, mod, max);
    }

    public static Matrix rand(int m, int n) {
        return Matrix.random(m, n);
    }

    public static Matrix eye(int m, int n) {
        return Matrix.identity(m, n);
    }

    public static Matrix inc(int m, int n, double begin, double pitch) {
        return Matrix.incrementRows(m, n, begin, pitch);
    }

    public static Matrix inc(int m, int n) {
        return Matrix.incrementRows(m, n, 1.0, n);
    }

    public static Matrix merge(Matrix A, Matrix B, int n) {
        if (n == 1) {
            return (Matrix)A.mergeRows(B);
        }
        if (n == 2) {
            return (Matrix)A.mergeColumns(B);
        }
        return A;
    }

    public static double get(Matrix A, int i, int j) {
        return A.get(i - 1, j - 1);
    }

    public static Matrix get(Matrix A, int i0, int i1, int j0, int j1) {
        return (Matrix)A.getSubMatrix(i0 - 1, i1 - 1, j0 - 1, j1 - 1);
    }

    public static Matrix getRow(Matrix A, int l) {
        return (Matrix)A.getRow(l - 1);
    }

    public static Matrix getColumn(Matrix A, int c) {
        return (Matrix)A.getColumn(c - 1);
    }

    public static int size(Matrix A, int dim) {
        if (dim == 1) {
            return A.getRowDimension();
        }
        if (dim == 2) {
            return A.getColumnDimension();
        }
        return 0;
    }

    public static Matrix diag(Matrix A) {
        return (Matrix)A.getDiagonal();
    }

    public static Matrix diag(Matrix A, int num) {
        return (Matrix)A.getDiagonal(num);
    }

    public static void set(Matrix A, int i, int j, double s) {
        A.set(i - 1, j - 1, s);
    }

    public static void set(Matrix A, int i0, int i1, int j0, int j1, Matrix X) {
        A.setSubMatrix(i0 - 1, j0 - 1, X);
    }

    public static void setRow(Matrix A, int l, Matrix B) {
        A.setRow(l - 1, B);
    }

    public static void setColumn(Matrix A, int c, Matrix B) {
        A.setColumn(c - 1, B);
    }

    public static Matrix resize(Matrix A, int m2, int n2) {
        return (Matrix)A.resize(m2, n2);
    }

    public static Matrix reshape(Matrix A, int m2, int n2) {
        return (Matrix)A.reshapeRows(m2, n2);
    }

    public static Matrix t(Matrix A) {
        return (Matrix)A.transpose();
    }

    public static double norm(Matrix A, String n) {
        if (n.equals("1")) {
            return A.norm1();
        }
        if (n.equals("2")) {
            return A.norm2();
        }
        if (n.equals("Inf")) {
            return A.normInfinity();
        }
        if (n.equals("Fro")) {
            return A.normFrobenius();
        }
        return Double.NaN;
    }

    public static double det(Matrix A) {
        return A.determinant();
    }

    public static int rank(Matrix A) {
        return A.rank();
    }

    public static double cond(Matrix A) {
        return A.condition();
    }

    public static double trace(Matrix A) {
        return A.trace();
    }

    public static Matrix min(Matrix A) {
        return (Matrix)A.min();
    }

    public static Matrix max(Matrix A) {
        return (Matrix)A.max();
    }

    public static Matrix sum(Matrix A) {
        return (Matrix)A.sum();
    }

    public static Matrix prod(Matrix A) {
        return (Matrix)A.product();
    }

    public static Matrix mean(Matrix A) {
        return (Matrix)new RandomMatrix(A).mean();
    }

    public static Matrix cov(Matrix A) {
        return (Matrix)new RandomMatrix(A).covariance();
    }

    public static Matrix corrcoef(Matrix A) {
        return (Matrix)new RandomMatrix(A).correlation();
    }

    public static Matrix var(Matrix A) {
        return (Matrix)new RandomMatrix(A).variance();
    }

    public static Matrix uminus(Matrix A) {
        return (Matrix)A.uminus();
    }

    public static Matrix plus(Matrix A, Matrix B) {
        return (Matrix)A.plus(B);
    }

    public static Matrix minus(Matrix A, Matrix B) {
        return (Matrix)A.minus(B);
    }

    public static Matrix times(Matrix A, double s) {
        return (Matrix)A.times(s);
    }

    public static Matrix times(Matrix A, Matrix B) {
        return (Matrix)A.times(B);
    }

    public static Matrix divide(Matrix A, double s) {
        return (Matrix)A.divide(s);
    }

    public static Matrix divide(Matrix A, Matrix B) {
        return (Matrix)A.divide(B);
    }

    public static Matrix solve(Matrix A, Matrix B) {
        return (Matrix)A.solve(B);
    }

    public static Matrix inv(Matrix A) {
        return (Matrix)A.inverse();
    }

    public static Matrix ebeTimes(Matrix A, Matrix B) {
        return (Matrix)A.ebeTimes(B);
    }

    public static Matrix ebeDivide(Matrix A, Matrix B) {
        return (Matrix)A.ebeDivide(B);
    }

    public static Matrix cos(Matrix A) {
        return (Matrix)A.ebeCos();
    }

    public static Matrix sin(Matrix A) {
        return (Matrix)A.ebeSin();
    }

    public static Matrix exp(Matrix A) {
        return (Matrix)A.ebeExp();
    }

    public static Matrix power(Matrix A, double p) {
        return (Matrix)A.ebePower(p);
    }

    public static Matrix power(Matrix A, Matrix B) {
        return (Matrix)A.ebePower(B);
    }

    public static Matrix log(Matrix A) {
        return (Matrix)A.ebeLog();
    }

    public static Matrix sqrt(Matrix A) {
        return (Matrix)A.ebeSqrt();
    }

    public static Matrix abs(Matrix A) {
        return (Matrix)A.ebeAbs();
    }

    public static Matrix lu_L(Matrix A) {
        return (Matrix)A.lu().getL();
    }

    public static Matrix lu_U(Matrix A) {
        return (Matrix)A.lu().getU();
    }

    public static Matrix lu_P(Matrix A) {
        return (Matrix)A.lu().getP();
    }

    public static Matrix qr_Q(Matrix A) {
        return (Matrix)A.qr().getQ();
    }

    public static Matrix qr_R(Matrix A) {
        return (Matrix)A.qr().getR();
    }

    public static Matrix chol(Matrix A) {
        return (Matrix)A.cholesky().getL();
    }

    public static Matrix svd_S(Matrix A) {
        return (Matrix)A.svd().getS();
    }

    public static Matrix svd_U(Matrix A) {
        return (Matrix)A.svd().getU();
    }

    public static Matrix svd_V(Matrix A) {
        return (Matrix)A.svd().getV();
    }

    public static Matrix eig_V(Matrix A) {
        return (Matrix)A.eig().getV();
    }

    public static Matrix eig_D(Matrix A) {
        return (Matrix)A.eig().getD();
    }

    public static Matrix sort_I(Matrix A) {
        Matrix X = new Matrix(A.getRowDimension(), A.getColumnDimension());
        for (int i = 0; i < A.getColumnDimension(); ++i) {
            X.setColumn(i, Sorting.MatrixRowsIndex(A, i));
        }
        return X;
    }

    public static Matrix sort_Y(Matrix A) {
        Matrix X = new Matrix(A.getRowDimension(), A.getColumnDimension());
        for (int i = 0; i < A.getColumnDimension(); ++i) {
            Matrix Xi = (Matrix)A.sort(i).getColumn(i);
            X.setColumn(i, Xi);
        }
        return X;
    }

    public static Matrix find(Matrix A, String test, double e) {
        return (Matrix)A.find(test, e).getIndexMatrix();
    }

    public static void disp(Matrix A) {
        A.toCommandLine("");
    }

    public static void disp(String text) {
        System.out.println(text);
    }

    public static void save(String fileName, Matrix A) {
        A.toASCIIFile(new File(fileName));
    }

    public static Matrix load(String fileName) {
        return (Matrix)AbstractMatrix.fromASCIIFile(new File(fileName));
    }

    public static Plot2DPanel hist(Matrix X, int n) {
        return MatlabSyntax.hist("", X, n);
    }

    public static Plot2DPanel hist(String title, Matrix X, int n) {
        Plot2DPanel p = new RandomMatrix(X).slice(n).toPlot2DPanel(title, "HISTOGRAM");
        new FrameView(title, p);
        return p;
    }

    public static Plot2DPanel plot(Matrix X, Matrix Y) {
        return MatlabSyntax.plot("", X, Y);
    }

    public static Plot2DPanel plot(String title, Matrix X, Matrix Y) {
        Plot2DPanel p = X.mergeColumns(Y).toPlot2DPanel(title, "SCATTER");
        new FrameView(title, p);
        return p;
    }

    public static Plot3DPanel plot3(Matrix X, Matrix Y, Matrix Z) {
        return MatlabSyntax.plot3("", X, Y, Z);
    }

    public static Plot3DPanel plot3(String title, Matrix X, Matrix Y, Matrix Z) {
        Plot3DPanel p = X.mergeColumns(Y).mergeColumns(Z).toPlot3DPanel(title, "SCATTER");
        new FrameView(title, p);
        return p;
    }

    public void tic() {
        this.t = System.currentTimeMillis();
    }

    public double toc() {
        this.t = System.currentTimeMillis() - this.t;
        return this.t;
    }
}

