/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.itcknow.bigml.util;

import java.math.BigInteger;
import java.util.Map;
import java.util.TreeMap;

public class SparseMatrix {
    private int defaultValue;
    private int m;
    private int n;
    private Map<BigInteger, Integer> data = new TreeMap<BigInteger, Integer>();

    public SparseMatrix(int m, int n, int defaultValue) {
        this.m = m;
        this.n = n;
        this.defaultValue = defaultValue;
    }

    public void setValueAt(int i, int j, int value) {
        if (i >= this.m || j >= this.n || i < 0 || j < 0) {
            throw new IllegalArgumentException("index (" + i + ", " + j + ") out of bounds");
        }
        if (this.data.containsKey(BigInteger.valueOf(i * this.n + j))) {
            this.data.put(BigInteger.valueOf(i * this.n + j), this.getValueAt(i, j) + value);
        } else {
            this.data.put(BigInteger.valueOf(i * this.n + j), value);
        }
    }

    public int getValueAt(int i, int j) {
        if (i >= this.m || j >= this.n || i < 0 || j < 0) {
            throw new IllegalArgumentException("index (" + i + ", " + j + ") out of bounds");
        }
        Integer value = this.data.get(BigInteger.valueOf(i * this.n + j));
        return value != null ? value : this.defaultValue;
    }

    public double[] getIndegree() {
        double[] r = new double[this.n];
        for (Map.Entry<BigInteger, Integer> entry : this.data.entrySet()) {
            BigInteger key = entry.getKey();
            Integer value = entry.getValue();
            r[key.remainder((BigInteger)BigInteger.valueOf((long)((long)this.m))).intValue()] = r[key.remainder(BigInteger.valueOf(this.m)).intValue()] + (double)value.intValue();
        }
        return r;
    }

    public int getEdgeCount() {
        return this.data.size();
    }
}

