/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.itcknow.bigml.util;

public class MyVector {
    private final int N;
    private double[] data;

    public MyVector(int N) {
        this.N = N;
        this.data = new double[N];
    }

    public MyVector(double[] data) {
        this.N = data.length;
        this.data = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.data[i] = data[i];
        }
    }

    public int length() {
        return this.N;
    }

    public double dot(MyVector that) {
        if (this.N != that.N) {
            throw new RuntimeException("Dimensions don't agree");
        }
        double sum = 0.0;
        for (int i = 0; i < this.N; ++i) {
            sum += this.data[i] * that.data[i];
        }
        return sum;
    }

    public double magnitude() {
        return Math.sqrt(this.dot(this));
    }

    public double distanceTo(MyVector that) {
        if (this.N != that.N) {
            throw new RuntimeException("Dimensions don't agree");
        }
        return this.minus(that).magnitude();
    }

    public MyVector plus(MyVector that) {
        if (this.N != that.N) {
            throw new RuntimeException("Dimensions don't agree");
        }
        MyVector c = new MyVector(this.N);
        for (int i = 0; i < this.N; ++i) {
            c.data[i] = this.data[i] + that.data[i];
        }
        return c;
    }

    public MyVector minus(MyVector that) {
        if (this.N != that.N) {
            throw new RuntimeException("Dimensions don't agree");
        }
        MyVector c = new MyVector(this.N);
        for (int i = 0; i < this.N; ++i) {
            c.data[i] = this.data[i] - that.data[i];
        }
        return c;
    }

    public double cartesian(int i) {
        return this.data[i];
    }

    public MyVector times(double factor) {
        MyVector c = new MyVector(this.N);
        for (int i = 0; i < this.N; ++i) {
            c.data[i] = factor * this.data[i];
        }
        return c;
    }

    public MyVector direction() {
        if (this.magnitude() == 0.0) {
            throw new RuntimeException("Zero-vector has no direction");
        }
        return this.times(1.0 / this.magnitude());
    }

    public String toString() {
        String s = "(";
        for (int i = 0; i < this.N; ++i) {
            s = s + this.data[i];
            if (i >= this.N - 1) continue;
            s = s + ", ";
        }
        return s + ")";
    }

    public static void main(String[] args) {
        double[] xdata = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] ydata = new double[]{5.0, 2.0, 4.0, 1.0};
        MyVector x = new MyVector(xdata);
        MyVector y = new MyVector(ydata);
        System.out.println("x        =  " + x);
        System.out.println("y        =  " + y);
        System.out.println("x + y    =  " + x.plus(y));
        System.out.println("10x      =  " + x.times(10.0));
        System.out.println("|x|      =  " + x.magnitude());
        System.out.println("<x, y>   =  " + x.dot(y));
        System.out.println("|x - y|  =  " + x.minus(y).magnitude());
    }
}

