/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.itcknow.bigml.util;

import java.util.Arrays;

public class MyMatrix {
    public static double[][] random(int m, int n) {
        double[][] C = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = Math.random();
            }
        }
        return C;
    }

    public static double[][] identity(int n) {
        double[][] I = new double[n][n];
        for (int i = 0; i < n; ++i) {
            I[i][i] = 1.0;
        }
        return I;
    }

    public static double dot(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("Illegal vector dimensions.");
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * y[i];
        }
        return sum;
    }

    public static double[][] transpose(double[][] A) {
        int m = A.length;
        int n = A[0].length;
        double[][] C = new double[n][m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[j][i] = A[i][j];
            }
        }
        return C;
    }

    public static double[][] add(double[][] A, double[][] B) {
        int m = A.length;
        int n = A[0].length;
        double[][] C = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = A[i][j] + B[i][j];
            }
        }
        return C;
    }

    public static double[][] subtract(double[][] A, double[][] B) {
        int m = A.length;
        int n = A[0].length;
        double[][] C = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = A[i][j] - B[i][j];
            }
        }
        return C;
    }

    public static double[][] multiply(double[][] A, double[][] B) {
        int mA = A.length;
        int nA = A[0].length;
        int mB = B.length;
        int nB = A[0].length;
        if (nA != mB) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        double[][] C = new double[mA][nB];
        for (int i = 0; i < mA; ++i) {
            for (int j = 0; j < nB; ++j) {
                for (int k = 0; k < nA; ++k) {
                    double[] dArray = C[i];
                    int n = j;
                    dArray[n] = dArray[n] + A[i][k] * B[k][j];
                }
            }
        }
        return C;
    }

    public static double[] multiply(double[][] A, double[] x) {
        int m = A.length;
        int n = A[0].length;
        if (x.length != n) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        double[] y = new double[m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                y[n2] = y[n2] + A[i][j] * x[j];
            }
        }
        return y;
    }

    public static double[] multiply(double[] x, double[][] A) {
        int m = A.length;
        int n = A[0].length;
        if (x.length != m) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        double[] y = new double[n];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                int n2 = j;
                y[n2] = y[n2] + A[i][j] * x[i];
            }
        }
        return y;
    }

    public static void main(String[] args) {
        System.out.println("D");
        System.out.println("--------------------");
        double[][] d = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {9.0, 1.0, 3.0}};
        System.out.print(Arrays.deepToString((Object[])d));
        System.out.println();
        System.out.println("I");
        System.out.println("--------------------");
        double[][] c = MyMatrix.identity(5);
        System.out.print(Arrays.deepToString((Object[])c));
        System.out.println();
        System.out.println("A");
        System.out.println("--------------------");
        double[][] a = MyMatrix.random(5, 5);
        System.out.print(Arrays.deepToString((Object[])a));
        System.out.println();
        System.out.println("A^T");
        System.out.println("--------------------");
        double[][] b = MyMatrix.transpose(a);
        System.out.print(b);
        System.out.println();
        System.out.println("A + A^T");
        System.out.println("--------------------");
        double[][] e = MyMatrix.add(a, b);
        System.out.print(Arrays.deepToString((Object[])e));
        System.out.println();
        System.out.println("A * A^T");
        System.out.println("--------------------");
        double[][] f = MyMatrix.multiply(a, b);
        System.out.print(Arrays.deepToString((Object[])f));
        System.out.println();
    }
}

